/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.core.network.NetProxy;
import forestry.core.network.PacketUpdate;
import forestry.mail.ContainerLetter;
import forestry.mail.ContainerTradeName;
import forestry.mail.POBox;
import forestry.mail.PostOffice;
import forestry.mail.network.PacketPOBoxInfo;
import forge.IPacketHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class PacketHandlerMail
implements IPacketHandler {
    public void onPacketData(qq network, String channel, byte[] bytes) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            mm net = (mm)network.getNetHandler();
            int packetID = data.read();
            switch (packetID) {
                case 80: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onLetterRecipient((ih)net.getPlayerEntity(), packet);
                    break;
                }
                case 81: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onLetterText((ih)net.getPlayerEntity(), packet);
                    break;
                }
                case 82: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onMonikerSet((ih)net.getPlayerEntity(), packet);
                    break;
                }
                case 86: {
                    this.onPOBoxInfoRequest((ih)net.getPlayerEntity());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onMonikerSet(ih player, PacketUpdate packet) {
        if (!(player.m instanceof ContainerTradeName)) {
            return;
        }
        ((ContainerTradeName)player.m).handleSetMoniker(packet);
    }

    private void onLetterText(ih player, PacketUpdate packet) {
        if (!(player.m instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)player.m).handleSetText(packet);
    }

    private void onLetterRecipient(ih player, PacketUpdate packet) {
        if (!(player.m instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)player.m).handleSetRecipient(player, packet);
    }

    private void onPOBoxInfoRequest(ih player) {
        POBox pobox = PostOffice.getPOBox(player.bi, player.v);
        if (pobox == null) {
            return;
        }
        NetProxy.sendToPlayer(new PacketPOBoxInfo(85, pobox.getPOBoxInfo()), player);
    }
}

