/*
 * Decompiled with CFR 0.152.
 */
package forestry.food;

import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.core.Proxy;
import forestry.core.unity.IItemColourOverlayed;
import forestry.core.unity.IItemDisplayNamed;
import forestry.core.unity.IItemNBTSynched;
import forestry.core.unity.IItemTooltipped;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ItemBeverage
extends id
implements IItemTooltipped,
IItemNBTSynched,
IItemColourOverlayed,
IItemDisplayNamed {
    public BeverageInfo[] beverages;

    public ItemBeverage(int index, BeverageInfo[] beverages) {
        super(index);
        this.bQ = 1;
        this.beverages = beverages;
        this.setTextureFile("/gfx/forestry/items/liquids.png");
    }

    public boolean i() {
        return true;
    }

    @Override
    public boolean func_46056_k() {
        return true;
    }

    public kp b(kp itemstack, ge world, ih entityplayer) {
        int meta = itemstack.h();
        BeverageInfo beverage = this.beverages[meta];
        IBeverageEffect[] effects = beverage.loadEffects(itemstack);
        --itemstack.a;
        entityplayer.af().a(beverage.heal, beverage.saturation);
        world.a((tv)entityplayer, "random.burp", 0.5f, world.r.nextFloat() * 0.1f + 0.9f);
        if (Proxy.isMultiplayerWorld()) {
            return itemstack;
        }
        for (IBeverageEffect effect : effects) {
            effect.doEffect(world, entityplayer);
        }
        return itemstack;
    }

    public int c(kp itemstack) {
        return 32;
    }

    public kt d(kp itemstack) {
        return kt.c;
    }

    public kp a(kp itemstack, ge world, ih entityplayer) {
        int meta = itemstack.h();
        BeverageInfo beverage = this.beverages[meta];
        if (entityplayer.b(beverage.isAlwaysEdible)) {
            entityplayer.a(itemstack, this.c(itemstack));
        }
        return itemstack;
    }

    public void addCreativeItems(ArrayList itemList) {
        for (int i = 0; i < this.beverages.length; ++i) {
            if (this.beverages[i].isSecret) continue;
            itemList.add(new kp((id)this, 1, i));
        }
    }

    @Override
    public void addInformation(kp itemstack, List list) {
        IBeverageEffect[] effects;
        int meta = itemstack.h();
        BeverageInfo beverage = this.beverages[meta];
        for (IBeverageEffect effect : effects = beverage.loadEffects(itemstack)) {
            if (effect.getDescription() == null) continue;
            list.add(effect.getDescription());
        }
    }

    @Override
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @Override
    public String getItemDisplayName(kp itemstack) {
        return StringUtil.localize("item.beverage." + this.beverages[itemstack.h()].name);
    }

    @Override
    public int getColorFromDamage(int i, int j) {
        if (j == 0 || this.beverages[i].secondaryColor == 0) {
            return this.beverages[i].primaryColor;
        }
        return this.beverages[i].secondaryColor;
    }

    @Override
    public int getIconFromDamageForRenderPass(int i, int j) {
        if (j > 0 && this.beverages[i].secondaryColor != 0) {
            return this.beverages[i].iconType;
        }
        return this.beverages[i].iconType + 240;
    }

    public static class BeverageInfo {
        public final String name;
        public final int iconType;
        public final int primaryColor;
        public final int secondaryColor;
        public final int heal;
        public final float saturation;
        public final boolean isAlwaysEdible;
        public boolean isSecret = false;

        public BeverageInfo(String name, int iconType, int primaryColor, int secondaryColor, int heal, float saturation, boolean isAlwaysEdible) {
            this.name = name;
            this.iconType = iconType;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
            this.heal = heal;
            this.saturation = saturation;
            this.isAlwaysEdible = isAlwaysEdible;
        }

        public IBeverageEffect[] loadEffects(kp stack) {
            IBeverageEffect[] effects = new IBeverageEffect[]{};
            ph nbttagcompound = stack.o();
            if (nbttagcompound == null) {
                return effects;
            }
            if (nbttagcompound.c("E")) {
                int effectLength = nbttagcompound.f("L");
                tx nbttaglist = nbttagcompound.n("E");
                effects = new IBeverageEffect[effectLength];
                for (int i = 0; i < nbttaglist.d(); ++i) {
                    ph nbttagcompound1 = (ph)nbttaglist.a(i);
                    byte byte0 = nbttagcompound1.d("S");
                    if (byte0 < 0 || byte0 >= effects.length) continue;
                    effects[byte0] = BeverageManager.effectList[nbttagcompound1.f("ID")];
                }
            }
            return effects;
        }

        public void saveEffects(kp stack, IBeverageEffect[] effects) {
            ph nbttagcompound = new ph();
            tx nbttaglist = new tx();
            nbttagcompound.a("L", effects.length);
            for (int i = 0; i < effects.length; ++i) {
                if (effects[i] == null) continue;
                ph nbttagcompound1 = new ph();
                nbttagcompound1.a("S", (byte)i);
                nbttagcompound1.a("ID", effects[i].getId());
                nbttaglist.a((jz)nbttagcompound1);
            }
            nbttagcompound.a("E", (jz)nbttaglist);
            stack.d(nbttagcompound);
        }
    }
}

