/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.ForestryAPI;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.ISqueezerManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class MachineSqueezer
extends Machine {
    @EntityNetData
    public TankSlot productTank = new TankSlot(10000);
    private kp[] inventoryStacks = new kp[12];
    private Recipe currentRecipe;
    private short resourceSlot1 = 0;
    private short remnantSlot = (short)9;
    private short canSlot = (short)10;
    private short outputSlot = (short)11;
    private Stack pendingLiquids = new Stack();
    private Stack pendingRemnants = new Stack();
    private int productionTime;
    private int timePerItem;

    public MachineSqueezer(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("squeezer"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.9");
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.SqueezerGUI.ordinal(), player.bi, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("ProductionTime", this.productionTime);
        nbttagcompound.a("TimePerItem", this.timePerItem);
        tx nbttaglist = new tx();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Items", (jz)nbttaglist);
        nbttaglist = new tx();
        kp[] remnants = this.pendingRemnants.toArray(new kp[this.pendingRemnants.size()]);
        for (int i = 0; i < remnants.length; ++i) {
            if (remnants[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            remnants[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("PendingRemnants", (jz)nbttaglist);
        nbttaglist = new tx();
        LiquidStack[] liquids = this.pendingLiquids.toArray(new LiquidStack[this.pendingLiquids.size()]);
        for (int i = 0; i < liquids.length; ++i) {
            if (liquids[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            liquids[i].writeToNBT(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("PendingLiquids", (jz)nbttaglist);
        ph NBTproductSlot = new ph();
        this.productTank.writeToNBT(NBTproductSlot);
        nbttagcompound.a("ProductTank", (jz)NBTproductSlot);
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        ph nbttagcompound1;
        int i;
        super.readFromNBT(nbttagcompound);
        this.productionTime = nbttagcompound.f("ProductionTime");
        this.timePerItem = nbttagcompound.f("TimePerItem");
        tx nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new kp[this.c()];
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ph)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = kp.a((ph)nbttagcompound1);
        }
        nbttaglist = nbttagcompound.n("PendingRemnants");
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ph)nbttaglist.a(i);
            this.pendingRemnants.add(kp.a((ph)nbttagcompound1));
        }
        nbttaglist = nbttagcompound.n("PendingLiquids");
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ph)nbttaglist.a(i);
            this.pendingLiquids.add(LiquidStack.loadLiquidStackFromNBT(nbttagcompound1));
        }
        this.productTank = new TankSlot(10000);
        if (nbttagcompound.c("ProductTank")) {
            this.productTank.readFromNBT(nbttagcompound.m("ProductTank"));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        LiquidContainer container;
        if (this.inventoryStacks[this.canSlot] != null && (container = LiquidManager.getEmptyContainer(this.inventoryStacks[this.canSlot], new LiquidStack(this.productTank.liquidId, this.productTank.quantity))) != null) {
            this.inventoryStacks[this.outputSlot] = this.bottleIntoContainer(this.inventoryStacks[this.canSlot], this.inventoryStacks[this.outputSlot], container, this.productTank);
            if (this.inventoryStacks[this.canSlot].a <= 0) {
                this.inventoryStacks[this.canSlot] = null;
            }
        }
        if (this.tile.k.o() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        this.checkRecipe();
        this.tryAddPending();
        if (!this.pendingLiquids.isEmpty() || !this.pendingRemnants.isEmpty()) {
            return false;
        }
        if (this.productionTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        --this.productionTime;
        if (this.productionTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        this.pendingLiquids.push(this.currentRecipe.liquid.copy());
        if (this.currentRecipe.remnants != null && this.tile.k.r.nextInt(100) < this.currentRecipe.chance) {
            this.pendingRemnants.push(this.currentRecipe.remnants.j());
        }
        this.removeResources(this.currentRecipe.resources);
        this.checkRecipe();
        this.resetRecipe();
        this.tryAddPending();
        this.setErrorState(EnumErrorCode.OK);
        return true;
    }

    private void checkRecipe() {
        kp[] resources = new kp[9];
        System.arraycopy(this.inventoryStacks, 0, resources, 0, 9);
        Recipe sameRec = RecipeManager.findMatchingRecipe(resources);
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.productionTime = 0;
            this.timePerItem = 0;
            return;
        }
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private boolean tryAddPending() {
        LiquidStack next;
        if (!this.pendingLiquids.isEmpty() && this.addProduct(next = (LiquidStack)this.pendingLiquids.peek())) {
            this.pendingLiquids.pop();
            return true;
        }
        if (!this.pendingRemnants.isEmpty() && this.addRemnant((kp)(next = (kp)this.pendingRemnants.peek()))) {
            this.pendingRemnants.pop();
            return true;
        }
        if (!this.pendingLiquids.isEmpty() || !this.pendingRemnants.isEmpty()) {
            this.setErrorState(EnumErrorCode.NOSPACE);
        }
        return false;
    }

    private boolean addProduct(LiquidStack stack) {
        stack.liquidAmount -= this.productTank.fill(null, stack.liquidAmount, stack.itemID, true);
        return stack.liquidAmount <= 0;
    }

    private boolean addRemnant(kp stack) {
        if (this.inventoryStacks[this.remnantSlot] == null) {
            this.inventoryStacks[this.remnantSlot] = stack;
            return true;
        }
        if (!this.inventoryStacks[this.remnantSlot].a(stack)) {
            return false;
        }
        int space = this.inventoryStacks[this.remnantSlot].b() - this.inventoryStacks[this.remnantSlot].a;
        if (space <= 0) {
            return false;
        }
        this.inventoryStacks[this.remnantSlot].a += stack.a;
        stack.a -= space;
        return true;
    }

    private void removeResources(kp[] stacks) {
        int[] removed = new int[stacks.length];
        block0: for (int i = this.resourceSlot1; i < this.remnantSlot; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            for (int j = 0; j < stacks.length && this.inventoryStacks[i] != null; ++j) {
                if (removed[j] >= stacks[j].a || !this.inventoryStacks[i].a(stacks[j])) continue;
                if (this.inventoryStacks[i].a >= stacks[j].a) {
                    this.a(i, stacks[j].a);
                    removed[j] = stacks[j].a;
                    continue;
                }
                int avail = this.inventoryStacks[i].a;
                this.inventoryStacks[i].a -= stacks[j].a;
                int n = j;
                removed[n] = removed[n] + avail;
                if (this.inventoryStacks[i].a > 0) continue;
                this.inventoryStacks[i] = null;
                continue block0;
            }
        }
    }

    @Override
    public boolean isWorking() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null && this.productTank.quantity < this.productTank.capacity;
    }

    public int getProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return i;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public int getResourceScaled(int i) {
        return this.productTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return this.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.productionTime = j;
                break;
            }
            case 1: {
                this.timePerItem = j;
                break;
            }
            case 2: {
                this.productTank.liquidId = j;
                break;
            }
            case 3: {
                this.productTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
        iCrafting.a(container, 0, this.productionTime);
        iCrafting.a(container, 1, this.timePerItem);
        iCrafting.a(container, 2, this.productTank.liquidId);
        iCrafting.a(container, 3, this.productTank.quantity);
    }

    @Override
    public int c() {
        return this.inventoryStacks.length;
    }

    @Override
    public kp g_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public kp a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            kp product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        kp product = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    @Override
    public void a(int i, kp itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.a()) {
            itemstack.a = this.a();
        }
    }

    @Override
    public kp b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        kp toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return this.canSlot;
        }
        if (side == 1) {
            return this.remnantSlot;
        }
        return this.resourceSlot1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 1;
        }
        return 9;
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        if (LiquidManager.isEmptyContainer(stack)) {
            if (this.inventoryStacks[this.canSlot] == null) {
                if (doAdd) {
                    this.inventoryStacks[this.canSlot] = stack.j();
                    stack.a = 0;
                }
                return true;
            }
            if (!this.inventoryStacks[this.canSlot].a(stack)) {
                return false;
            }
            int space = this.inventoryStacks[this.canSlot].b() - this.inventoryStacks[this.canSlot].a;
            if (space <= 0) {
                return false;
            }
            if (space < stack.a) {
                if (doAdd) {
                    this.inventoryStacks[this.canSlot].a = this.inventoryStacks[this.canSlot].b();
                    stack.a -= space;
                }
                return true;
            }
            if (doAdd) {
                this.inventoryStacks[this.canSlot].a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        int freeSlots = 0;
        int slot = -1;
        for (int i = 0; i < this.remnantSlot; ++i) {
            int space;
            if (this.inventoryStacks[i] == null) {
                ++freeSlots;
                slot = i;
                continue;
            }
            if (!this.inventoryStacks[i].a(stack) || (space = this.inventoryStacks[i].b() - this.inventoryStacks[i].a) <= 0) continue;
            if (space < stack.a) {
                if (doAdd) {
                    this.inventoryStacks[i].a = this.inventoryStacks[i].b();
                    stack.a -= space;
                    continue;
                }
                return true;
            }
            if (doAdd) {
                this.inventoryStacks[i].a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        if (freeSlots <= 0) {
            return false;
        }
        if (doAdd) {
            this.inventoryStacks[slot] = stack.j();
            stack.a = 0;
        }
        return true;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        kp product = null;
        if (this.inventoryStacks[this.outputSlot] != null) {
            product = new kp(this.inventoryStacks[this.outputSlot].c, 1, this.inventoryStacks[this.outputSlot].h());
            if (doRemove) {
                --this.inventoryStacks[this.outputSlot].a;
                if (this.inventoryStacks[this.outputSlot].a <= 0) {
                    this.inventoryStacks[this.outputSlot] = null;
                }
            }
            return product;
        }
        if (this.inventoryStacks[this.remnantSlot] == null) {
            return null;
        }
        product = new kp(this.inventoryStacks[this.remnantSlot].c, 1, this.inventoryStacks[this.remnantSlot].h());
        if (doRemove) {
            --this.inventoryStacks[this.remnantSlot].a;
            if (this.inventoryStacks[this.remnantSlot].a <= 0) {
                this.inventoryStacks[this.remnantSlot] = null;
            }
        }
        return product;
    }

    @Override
    public int fill(Orientations from, int quantity, int id2, boolean doFill) {
        return 0;
    }

    @Override
    public int empty(int quantityMax, boolean doEmpty) {
        int product = 0;
        if (this.productTank.quantity >= quantityMax) {
            product = quantityMax;
            if (doEmpty) {
                this.productTank.quantity -= quantityMax;
            }
        } else {
            product = this.productTank.quantity;
            if (doEmpty) {
                this.productTank.quantity = 0;
            }
        }
        if (doEmpty && product > 0) {
            this.tile.sendNetworkUpdate();
        }
        return product;
    }

    @Override
    public int getLiquidQuantity() {
        return this.productTank.quantity;
    }

    @Override
    public int getCapacity() {
        return 10000;
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.productTank};
    }

    @Override
    public int getLiquidId() {
        return this.productTank.liquidId;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
        RecipeManagers.squeezerManager.addRecipe(10, new kp[]{new kp(id.i)}, new LiquidStack(ForestryItem.liquidJuice, 200), new kp(ForestryItem.mulch), 40);
        RecipeManagers.squeezerManager.addRecipe(10, new kp[]{new kp(ForestryItem.honeyDrop)}, new LiquidStack(ForestryItem.liquidHoney, 100), new kp(ForestryItem.propolis), 5);
        RecipeManagers.squeezerManager.addRecipe(10, new kp[]{new kp(ForestryItem.honeydew)}, new LiquidStack(ForestryItem.liquidHoney, 100));
        RecipeManagers.squeezerManager.addRecipe(10, new kp[]{new kp(id.R)}, new LiquidStack(ForestryItem.liquidSeedOil, 100));
        RecipeManagers.squeezerManager.addRecipe(10, new kp[]{new kp(id.bf)}, new LiquidStack(ForestryItem.liquidSeedOil, 100));
        RecipeManagers.squeezerManager.addRecipe(10, new kp[]{new kp(id.bg)}, new LiquidStack(ForestryItem.liquidSeedOil, 100));
        RecipeManagers.squeezerManager.addRecipe(10, new kp[]{new kp(ForestryItem.phosphor, 2), new kp(vz.w)}, new LiquidStack(vz.D, 1600));
        RecipeManagers.squeezerManager.addRecipe(10, new kp[]{new kp(ForestryItem.phosphor, 2), new kp(vz.E)}, new LiquidStack(vz.D, 2000));
        RecipeManagers.squeezerManager.addRecipe(10, new kp[]{new kp(ForestryItem.phosphor, 2), new kp(vz.v)}, new LiquidStack(vz.D, 1600));
        RecipeManagers.squeezerManager.addRecipe(10, new kp[]{new kp(vz.aV)}, new LiquidStack(vz.B, 500));
    }

    public static class RecipeManager
    implements ISqueezerManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int timePerItem, kp[] resources, LiquidStack liquid, kp remnants, int chance) {
            recipes.add(new Recipe(timePerItem, resources, liquid, remnants, chance));
        }

        @Override
        public void addRecipe(int timePerItem, kp[] resources, LiquidStack liquid) {
            this.addRecipe(timePerItem, resources, liquid, null, 0);
        }

        public static Recipe findMatchingRecipe(kp[] items) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(items)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public List getRecipes() {
            HashMap<kp[], kp[]> recipeList = new HashMap<kp[], kp[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(recipe.resources, new kp[]{recipe.remnants, recipe.liquid.asItemStack()});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final int timePerItem;
        public final kp[] resources;
        public final LiquidStack liquid;
        public final kp remnants;
        public final int chance;

        public Recipe(int timePerItem, kp[] resources, LiquidStack liquid, kp remnants, int chance) {
            this.timePerItem = timePerItem;
            this.resources = resources;
            this.liquid = liquid;
            this.remnants = remnants;
            this.chance = chance;
        }

        public boolean matches(kp[] res) {
            if (res == null || res.length <= 0) {
                return false;
            }
            boolean matchedAll = true;
            for (kp stack : this.resources) {
                boolean matched = false;
                for (kp matchStack : res) {
                    if (matchStack == null || !matchStack.a(stack) || matchStack.a < stack.a) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                matchedAll = false;
            }
            return matchedAll;
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachineSqueezer((TileMachine)tile);
        }
    }
}

