/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.EnumHumidity;
import forestry.api.core.ForestryAPI;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.core.EnumErrorCode;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.genetics.ClimateHelper;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import java.util.LinkedList;

public class MachineRaintank
extends Machine {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(30000);
    private kp[] inventoryStacks = new kp[3];
    private boolean isValidBiome = true;
    private int fillingTime;
    private int fillingTotalTime;
    private LiquidContainer productPending;
    private kp usedEmpty;

    public MachineRaintank(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("raintank"));
        if (tile.k != null) {
            lt biome = tile.k.a(tile.l, tile.n);
            if (ClimateHelper.getHumidity(biome.G) == EnumHumidity.ARID) {
                this.setErrorState(EnumErrorCode.INVALIDBIOME);
                this.isValidBiome = false;
            }
        }
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.3");
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.RaintankGUI.ordinal(), player.bi, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("FillingTime", this.fillingTime);
        nbttagcompound.a("FillingTotalTime", this.fillingTotalTime);
        nbttagcompound.a("IsValidBiome", this.isValidBiome);
        ph NBTresourceSlot = new ph();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (jz)NBTresourceSlot);
        tx nbttaglist = new tx();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Items", (jz)nbttaglist);
        if (this.usedEmpty != null) {
            ph nbttagcompoundP = new ph();
            this.usedEmpty.b(nbttagcompoundP);
            nbttagcompound.a("UsedEmpty", (jz)nbttagcompoundP);
        }
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.fillingTime = nbttagcompound.f("FillingTime");
        this.fillingTotalTime = nbttagcompound.f("FillingTotalTime");
        this.isValidBiome = nbttagcompound.o("IsValidBiome");
        this.resourceTank = new TankSlot(30000);
        if (nbttagcompound.c("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.m("ResourceTank"));
        }
        tx nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new kp[this.c()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ph nbttagcompound1 = (ph)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = kp.a((ph)nbttagcompound1);
        }
        if (nbttagcompound.c("UsedEmpty")) {
            ph nbttagcompoundP = nbttagcompound.m("UsedEmpty");
            this.usedEmpty = kp.a((ph)nbttagcompoundP);
        }
    }

    @Override
    public void updateServerSide() {
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        if (!this.isValidBiome) {
            this.setErrorState(EnumErrorCode.INVALIDBIOME);
            return;
        }
        if (!this.tile.k.l(this.tile.Coords().x, this.tile.Coords().y, this.tile.Coords().z)) {
            this.setErrorState(EnumErrorCode.NOSKY);
            return;
        }
        if (!this.tile.k.x()) {
            this.setErrorState(EnumErrorCode.NOTRAINING);
            return;
        }
        this.resourceTank.fill(null, 10, vz.B.bO, true);
        this.setErrorState(EnumErrorCode.OK);
    }

    @Override
    public boolean doWork() {
        if (Proxy.isMultiplayerWorld()) {
            return false;
        }
        if (this.productPending != null) {
            if (this.tryProductAdd(this.productPending.filled.j(), true)) {
                this.productPending = null;
                return true;
            }
            return false;
        }
        if (this.fillingTime > 0) {
            LiquidContainer container;
            --this.fillingTime;
            if (this.fillingTime <= 0 && this.usedEmpty != null && (container = LiquidManager.getEmptyContainer(this.usedEmpty, new LiquidStack(vz.B, 1))) != null && !this.tryProductAdd(container.filled.j(), true)) {
                this.productPending = container;
            }
            return true;
        }
        if (this.tryStart()) {
            return true;
        }
        this.usedEmpty = null;
        return false;
    }

    private boolean tryStart() {
        if (this.inventoryStacks[0] == null) {
            return false;
        }
        if (this.inventoryStacks[0].a <= 0) {
            return false;
        }
        LiquidContainer container = LiquidManager.getEmptyContainer(this.inventoryStacks[0], new LiquidStack(vz.B, 1));
        if (container == null) {
            return false;
        }
        if (!this.tryProductAdd(container.filled, false)) {
            return false;
        }
        if (this.resourceTank.quantity < container.liquid.liquidAmount) {
            return false;
        }
        this.resourceTank.quantity -= container.liquid.liquidAmount;
        if (this.resourceTank.quantity < 0) {
            this.resourceTank.quantity = 0;
        }
        this.a(0, 1);
        this.fillingTotalTime = 10;
        this.fillingTime = 10;
        this.usedEmpty = container.empty;
        return true;
    }

    private boolean tryProductAdd(kp product, boolean doAdd) {
        if (product == null) {
            return false;
        }
        if (this.inventoryStacks[1] != null) {
            if (this.inventoryStacks[1].c != product.c) {
                return false;
            }
            if (this.inventoryStacks[1].a >= this.inventoryStacks[1].b()) {
                return false;
            }
        }
        if (!doAdd) {
            return true;
        }
        if (this.inventoryStacks[1] == null) {
            this.inventoryStacks[1] = product;
        } else {
            this.inventoryStacks[1].a += product.a;
        }
        return true;
    }

    @Override
    public boolean isWorking() {
        return this.fillingTime > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventoryStacks[0] == null) {
            return false;
        }
        return (float)this.inventoryStacks[0].a / (float)this.inventoryStacks[0].b() > percentage;
    }

    @Override
    public boolean hasWork() {
        if (this.fillingTime > 0) {
            return true;
        }
        if (this.inventoryStacks[0] == null) {
            return false;
        }
        LiquidContainer container = LiquidManager.getEmptyContainer(this.inventoryStacks[0], new LiquidStack(vz.B, 1));
        if (container == null) {
            return false;
        }
        return this.resourceTank.quantity >= container.liquid.liquidAmount;
    }

    public int getFillProgressScaled(int i) {
        if (this.fillingTotalTime == 0) {
            return 0;
        }
        return this.fillingTime * i / this.fillingTotalTime;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return this.rateTankLevel(this.getResourceScaled(100));
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 30000;
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        LiquidContainer container = LiquidManager.getEmptyContainer(stack, new LiquidStack(vz.B, 1));
        if (container == null) {
            return false;
        }
        if (this.inventoryStacks[0] == null) {
            if (doAdd) {
                this.inventoryStacks[0] = stack.j();
                stack.a = 0;
            }
            return true;
        }
        if (this.inventoryStacks[0].a >= this.inventoryStacks[0].b()) {
            return false;
        }
        if (!this.inventoryStacks[0].a(stack)) {
            return false;
        }
        int space = this.a() - this.inventoryStacks[0].a;
        if (space >= stack.a) {
            if (doAdd) {
                this.inventoryStacks[0].a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        if (doAdd) {
            this.inventoryStacks[0].a = this.a();
            stack.a -= space;
        }
        return true;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        if (this.inventoryStacks[1] == null) {
            return null;
        }
        if (this.inventoryStacks[1].a <= 0) {
            return null;
        }
        kp product = new kp(this.inventoryStacks[1].a(), 1);
        if (doRemove) {
            --this.inventoryStacks[1].a;
            if (this.inventoryStacks[1].a <= 0) {
                this.inventoryStacks[1] = null;
            }
        }
        return product;
    }

    @Override
    public int c() {
        return this.inventoryStacks.length;
    }

    @Override
    public kp g_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public kp a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            kp removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        kp removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public void a(int i, kp itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.a()) {
            itemstack.a = this.a();
        }
    }

    @Override
    public kp b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        kp toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 1;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
                break;
            }
            case 1: {
                this.fillingTotalTime = j;
                break;
            }
            case 2: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 3: {
                this.resourceTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
        iCrafting.a(container, 0, this.fillingTime);
        iCrafting.a(container, 1, this.fillingTotalTime);
        iCrafting.a(container, 2, this.resourceTank.liquidId);
        iCrafting.a(container, 3, this.resourceTank.quantity);
    }

    @Override
    public int fill(Orientations from, int quantity, int id2, boolean doFill) {
        if (id2 != vz.B.bO) {
            return 0;
        }
        int used = this.resourceTank.fill(from, quantity, id2, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int empty(int quantityMax, boolean doEmpty) {
        int product = 0;
        if (this.resourceTank.quantity >= quantityMax) {
            product = quantityMax;
            if (doEmpty) {
                this.resourceTank.quantity -= quantityMax;
            }
        } else {
            product = this.resourceTank.quantity;
            if (doEmpty) {
                this.resourceTank.quantity = 0;
            }
        }
        if (doEmpty && product > 0) {
            this.tile.sendNetworkUpdate();
        }
        return product;
    }

    @Override
    public int getLiquidQuantity() {
        return this.resourceTank.quantity;
    }

    @Override
    public int getCapacity() {
        return 30000;
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public int getLiquidId() {
        return this.resourceTank.liquidId;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachineRaintank((TileMachine)tile);
        }
    }
}

