/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ICentrifugeManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class MachineCentrifuge
extends Machine {
    private kp[] inventoryStacks = new kp[10];
    public Recipe currentRecipe;
    private int resourceSlot = 0;
    private int inventorySlot1 = 1;
    private Stack pendingProducts = new Stack();
    private int productionTime;
    private int timePerItem;

    public MachineCentrifuge(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("centrifuge"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.8");
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.CentrifugeGUI.ordinal(), player.bi, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("ProductionTime", this.productionTime);
        nbttagcompound.a("TimePerItem", this.timePerItem);
        tx nbttaglist = new tx();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Items", (jz)nbttaglist);
        nbttaglist = new tx();
        kp[] offspring = this.pendingProducts.toArray(new kp[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            offspring[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("PendingProducts", (jz)nbttaglist);
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        ph nbttagcompound1;
        int i;
        super.readFromNBT(nbttagcompound);
        this.productionTime = nbttagcompound.f("ProductionTime");
        this.timePerItem = nbttagcompound.f("TimePerItem");
        tx nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new kp[this.c()];
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ph)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = kp.a((ph)nbttagcompound1);
        }
        nbttaglist = nbttagcompound.n("PendingProducts");
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ph)nbttaglist.a(i);
            this.pendingProducts.add(kp.a((ph)nbttagcompound1));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        if (this.tile.k.o() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        this.checkRecipe();
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.productionTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        --this.productionTime;
        if (this.productionTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        for (Map.Entry entry : this.currentRecipe.products.entrySet()) {
            if ((Integer)entry.getValue() >= 100) {
                this.pendingProducts.push(((kp)entry.getKey()).j());
                continue;
            }
            if (this.tile.k.r.nextInt(100) >= (Integer)entry.getValue()) continue;
            this.pendingProducts.push(((kp)entry.getKey()).j());
        }
        --this.inventoryStacks[this.resourceSlot].a;
        if (this.inventoryStacks[this.resourceSlot].a <= 0) {
            this.inventoryStacks[this.resourceSlot] = null;
        }
        this.checkRecipe();
        this.resetRecipe();
        this.tryAddPending();
        return true;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.inventoryStacks[this.resourceSlot]);
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.productionTime = 0;
            this.timePerItem = 0;
            return;
        }
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        kp next = (kp)this.pendingProducts.peek();
        if (this.addProduct(next, true)) {
            this.pendingProducts.pop();
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    private boolean addProduct(kp product, boolean all) {
        for (int i = this.inventorySlot1; i < this.inventoryStacks.length; ++i) {
            int space;
            if (this.inventoryStacks[i] == null) {
                this.inventoryStacks[i] = product;
                return true;
            }
            if (!this.inventoryStacks[i].a(product) || (space = this.inventoryStacks[i].b() - this.inventoryStacks[i].a) <= 0) continue;
            if (space >= product.a) {
                this.inventoryStacks[i].a += product.a;
                product.a = 0;
                return true;
            }
            if (all) continue;
            this.inventoryStacks[i].a = this.inventoryStacks[i].b();
            product.a -= space;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventoryStacks[this.resourceSlot] == null) {
            return false;
        }
        return (float)this.inventoryStacks[this.resourceSlot].a / (float)this.inventoryStacks[this.resourceSlot].b() > percentage;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    public int getProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return i;
        }
        return this.productionTime * i / this.timePerItem;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.productionTime = j;
                break;
            }
            case 1: {
                this.timePerItem = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
        iCrafting.a(container, 0, this.productionTime);
        iCrafting.a(container, 1, this.timePerItem);
    }

    @Override
    public int c() {
        return this.inventoryStacks.length;
    }

    @Override
    public kp g_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public kp a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            kp product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        kp product = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    @Override
    public void a(int i, kp itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.a()) {
            itemstack.a = this.a();
        }
    }

    @Override
    public kp b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        kp toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0 || side == 1) {
            return this.resourceSlot;
        }
        return this.inventorySlot1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 1;
        }
        return 9;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        kp product = null;
        for (int i = this.inventorySlot1; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            product = new kp(this.inventoryStacks[i].c, 1, this.inventoryStacks[i].h());
            if (!doRemove) break;
            this.a(i, 1);
            break;
        }
        return product;
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        if (this.inventoryStacks[this.resourceSlot] == null) {
            if (doAdd) {
                this.inventoryStacks[this.resourceSlot] = stack.j();
                stack.a = 0;
            }
            return true;
        }
        if (!this.inventoryStacks[this.resourceSlot].a(stack)) {
            return false;
        }
        int space = this.inventoryStacks[this.resourceSlot].b() - this.inventoryStacks[this.resourceSlot].a;
        if (space <= 0) {
            return false;
        }
        if (doAdd) {
            if (stack.a <= space) {
                this.inventoryStacks[this.resourceSlot].a += stack.a;
                stack.a = 0;
            } else {
                this.inventoryStacks[this.resourceSlot].a += space;
                stack.a -= space;
            }
        }
        return true;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 0), new kp(ForestryItem.beeswax), new kp(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 1), new kp(ForestryItem.beeswax), new kp(id.aV, 1, 3), 50);
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 2), new kp(ForestryItem.refractoryWax), new kp(ForestryItem.phosphor), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 3), new kp(ForestryItem.propolis), new kp(ForestryItem.honeyDrop), 40);
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 5), new kp(ForestryItem.honeydew), new kp(ForestryItem.honeyDrop), 40);
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 4), new kp[]{new kp(ForestryItem.beeswax), new kp(ForestryItem.honeyDrop), new kp(id.aC), new kp(ForestryItem.pollen, 1, 1)}, new int[]{80, 70, 20, 20});
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 6), new kp(ForestryItem.honeyDrop), new kp(ForestryItem.propolis, 1, 3), 80);
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 7), new kp(ForestryItem.beeswax), new kp(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 8), new kp[]{new kp(ForestryItem.honeyDrop), new kp(ForestryItem.propolis, 1, 2)}, new int[]{40, 100});
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 9), new kp[0], new int[0]);
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 10), new kp[]{new kp(ForestryItem.honeyDrop), new kp(ForestryItem.beeswax), new kp(id.L)}, new int[]{20, 20, 90});
        RecipeManagers.centrifugeManager.addRecipe(80, new kp(ForestryItem.beeComb, 1, 11), new kp[]{new kp(ForestryItem.honeyDrop, 2, 1)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(80, new kp(ForestryItem.beeComb, 1, 12), new kp[]{new kp(ForestryItem.honeyDrop, 1, 1)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(400, new kp(ForestryItem.beeComb, 1, 13), new kp[]{new kp(ForestryItem.honeyDrop, 1, 2)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 14), new kp[]{new kp(ForestryItem.honeyDrop), new kp(ForestryItem.beeswax), new kp(id.S)}, new int[]{20, 20, 80});
        RecipeManagers.centrifugeManager.addRecipe(20, new kp(ForestryItem.beeComb, 1, 15), new kp(ForestryItem.beeswax), new kp(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(5, new kp(ForestryItem.propolis, 1, 3), new kp[]{new kp(ForestryItem.craftingMaterial, 1, 2), new kp(ForestryItem.propolis)}, new int[]{60, 10});
    }

    public static class RecipeManager
    implements ICentrifugeManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int timePerItem, kp resource, HashMap products) {
            recipes.add(new Recipe(timePerItem, resource, products));
        }

        @Override
        public void addRecipe(int timePerItem, kp resource, kp[] produce, int[] chances) {
            HashMap<kp, Integer> products = new HashMap<kp, Integer>();
            int i = 0;
            for (kp prod : produce) {
                products.put(prod, chances[i]);
                ++i;
            }
            this.addRecipe(timePerItem, resource, products);
        }

        @Override
        public void addRecipe(int timePerItem, kp resource, kp primary, kp secondary, int chance) {
            HashMap<kp, Integer> products = new HashMap<kp, Integer>();
            products.put(primary, 100);
            if (secondary != null) {
                products.put(secondary, chance);
            }
            this.addRecipe(timePerItem, resource, products);
        }

        @Override
        public void addRecipe(int timePerItem, kp resource, kp primary) {
            HashMap<kp, Integer> products = new HashMap<kp, Integer>();
            products.put(primary, 100);
            this.addRecipe(timePerItem, resource, products);
        }

        public static Recipe findMatchingRecipe(kp item) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public List getRecipes() {
            HashMap<kp[], kp[]> recipeList = new HashMap<kp[], kp[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new kp[]{recipe.resource}, recipe.products.keySet().toArray(new kp[0]));
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final int timePerItem;
        public final kp resource;
        public final HashMap products;

        public Recipe(int timePerItem, kp resource, HashMap products) {
            this.timePerItem = timePerItem;
            this.resource = resource;
            this.products = products;
        }

        public boolean matches(kp res) {
            if (res == null && this.resource == null) {
                return true;
            }
            if (res == null && this.resource != null) {
                return false;
            }
            if (res != null && this.resource == null) {
                return false;
            }
            return this.resource.a(res);
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachineCentrifuge((TileMachine)tile);
        }
    }
}

