/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.ForestryAPI;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.IBottlerManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class MachineBottler
extends Machine {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    public static final short SLOT_CAN = 2;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private kp[] inventoryStacks = new kp[3];
    private boolean productPending = false;
    private Recipe currentRecipe;
    private Stack pendingProducts = new Stack();
    private int fillingTime;
    private int fillingTotalTime;

    public MachineBottler(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("bottler"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.2");
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.BottlerGUI.ordinal(), player.bi, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("FillingTime", this.fillingTime);
        nbttagcompound.a("FillingTotalTime", this.fillingTotalTime);
        nbttagcompound.a("ProductPending", this.productPending);
        ph NBTresourceSlot = new ph();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (jz)NBTresourceSlot);
        tx nbttaglist = new tx();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Items", (jz)nbttaglist);
        nbttaglist = new tx();
        kp[] offspring = this.pendingProducts.toArray(new kp[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            offspring[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("PendingProducts", (jz)nbttaglist);
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        ph nbttagcompound1;
        int i;
        super.readFromNBT(nbttagcompound);
        this.fillingTime = nbttagcompound.f("FillingTime");
        this.fillingTotalTime = nbttagcompound.f("FillingTotalTime");
        this.productPending = nbttagcompound.o("ProductPending");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.c("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.m("ResourceTank"));
        }
        tx nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new kp[this.c()];
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ph)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = kp.a((ph)nbttagcompound1);
        }
        nbttaglist = nbttagcompound.n("PendingProducts");
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ph)nbttaglist.a(i);
            this.pendingProducts.add(kp.a((ph)nbttagcompound1));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        LiquidContainer container;
        if (this.inventoryStacks[2] != null && (container = LiquidManager.getLiquidContainer(this.inventoryStacks[2])) != null && RecipeManager.isInput(container.liquid)) {
            this.inventoryStacks[2] = this.replenishByContainer(this.inventoryStacks[2], container, this.resourceTank);
            if (this.inventoryStacks[2].a <= 0) {
                this.inventoryStacks[2] = null;
            }
        }
        if (this.tile.k.o() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        this.checkRecipe();
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.fillingTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
            return false;
        }
        --this.fillingTime;
        if (this.fillingTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        this.pendingProducts.push(this.currentRecipe.bottled.j());
        --this.inventoryStacks[0].a;
        if (this.inventoryStacks[0].a <= 0) {
            this.inventoryStacks[0] = null;
        }
        this.resourceTank.quantity -= this.currentRecipe.input.liquidAmount;
        if (this.resourceTank.quantity < 0) {
            this.resourceTank.quantity = 0;
        }
        this.checkRecipe();
        this.resetRecipe();
        while (this.tryAddPending()) {
        }
        return true;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity), this.inventoryStacks[0]);
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.fillingTime = 0;
            this.fillingTotalTime = 0;
            return;
        }
        this.fillingTime = this.currentRecipe.cyclesPerUnit;
        this.fillingTotalTime = this.currentRecipe.cyclesPerUnit;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        kp next = (kp)this.pendingProducts.peek();
        if (this.addProduct(next, true)) {
            this.pendingProducts.pop();
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    private boolean addProduct(kp product, boolean all) {
        for (int i = 1; i < 2; ++i) {
            int space;
            if (this.inventoryStacks[i] == null) {
                this.inventoryStacks[i] = product;
                return true;
            }
            if (!this.inventoryStacks[i].a(product) || (space = this.inventoryStacks[i].b() - this.inventoryStacks[i].a) <= 0) continue;
            if (space >= product.a) {
                this.inventoryStacks[i].a += product.a;
                product.a = 0;
                return true;
            }
            if (all) continue;
            this.inventoryStacks[i].a = this.inventoryStacks[i].b();
            product.a -= space;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.fillingTime > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventoryStacks[0] == null) {
            return false;
        }
        return (float)this.inventoryStacks[0].a / (float)this.inventoryStacks[0].b() > percentage;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    public int getFillProgressScaled(int i) {
        if (this.fillingTotalTime == 0) {
            return 0;
        }
        return this.fillingTime * i / this.fillingTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return this.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
                break;
            }
            case 1: {
                this.fillingTotalTime = j;
                break;
            }
            case 2: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 3: {
                this.resourceTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
        iCrafting.a(container, 0, this.fillingTime);
        iCrafting.a(container, 1, this.fillingTotalTime);
        iCrafting.a(container, 2, this.resourceTank.liquidId);
        iCrafting.a(container, 3, this.resourceTank.quantity);
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        if (!RecipeManager.hasCan(stack)) {
            return false;
        }
        if (this.inventoryStacks[0] == null) {
            if (doAdd) {
                this.inventoryStacks[0] = stack.j();
                stack.a = 0;
            }
            return true;
        }
        if (this.inventoryStacks[0].a >= this.inventoryStacks[0].b()) {
            return false;
        }
        if (!this.inventoryStacks[0].a(stack)) {
            return false;
        }
        int space = this.a() - this.inventoryStacks[0].a;
        if (space >= stack.a) {
            if (doAdd) {
                this.inventoryStacks[0].a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        if (doAdd) {
            this.inventoryStacks[0].a = this.a();
            stack.a -= space;
        }
        return true;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        if (this.inventoryStacks[1] == null) {
            return null;
        }
        if (this.inventoryStacks[1].a <= 0) {
            return null;
        }
        kp product = new kp(this.inventoryStacks[1].c, 1, this.inventoryStacks[1].h());
        if (doRemove) {
            --this.inventoryStacks[1].a;
            if (this.inventoryStacks[1].a <= 0) {
                this.inventoryStacks[1] = null;
            }
        }
        return product;
    }

    @Override
    public int c() {
        return this.inventoryStacks.length;
    }

    @Override
    public kp g_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public kp a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            kp removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        kp removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public void a(int i, kp itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.a()) {
            itemstack.a = this.a();
        }
    }

    @Override
    public kp b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        kp toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return 2;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 1;
    }

    @Override
    public int fill(Orientations from, int quantity, int id2, boolean doFill) {
        if (this.resourceTank.quantity > 0 && this.resourceTank.liquidId != id2) {
            return 0;
        }
        if (!RecipeManager.isInput(new LiquidStack(id2, 1))) {
            return 0;
        }
        int used = this.resourceTank.fill(from, quantity, id2, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int getCapacity() {
        return 10000;
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
    }

    public static class RecipeManager
    implements IBottlerManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int cyclesPerUnit, LiquidStack input, kp can, kp bottled) {
            recipes.add(new Recipe(cyclesPerUnit, input, can, bottled));
        }

        public static Recipe findMatchingRecipe(LiquidStack res, kp empty) {
            if (res == null || empty == null) {
                return null;
            }
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(res, empty)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isInput(LiquidStack res) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.hasInput(res)) continue;
                return true;
            }
            return false;
        }

        public static boolean hasCan(kp res) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.hasCan(res)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List getRecipes() {
            HashMap<kp[], kp[]> recipeList = new HashMap<kp[], kp[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new kp[]{recipe.input.asItemStack(), recipe.can}, new kp[]{recipe.bottled});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final int cyclesPerUnit;
        public final LiquidStack input;
        public final kp can;
        public final kp bottled;

        public Recipe(int cyclesPerUnit, LiquidStack input, kp can, kp bottled) {
            this.cyclesPerUnit = cyclesPerUnit;
            this.input = input;
            this.can = can;
            this.bottled = bottled;
        }

        public boolean matches(LiquidStack res, kp empty) {
            return this.input.isLiquidEqual(res) && res.liquidAmount >= this.input.liquidAmount && this.can.a(empty);
        }

        public boolean hasInput(LiquidStack res) {
            return this.input.isLiquidEqual(res);
        }

        public boolean hasCan(kp res) {
            return this.can.a(res);
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachineBottler((TileMachine)tile);
        }
    }
}

