/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.planters;

import forestry.api.core.GlobalManager;
import forestry.api.cultivation.ICropProvider;
import forestry.core.EnumErrorCode;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.TileMachine;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Orientations;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StructureBlueprint;
import forestry.core.utils.StructureConstruction;
import forestry.core.utils.Vect;
import forestry.cultivation.TilePlanter;
import java.util.ArrayList;
import java.util.LinkedList;

public abstract class Planter
extends Machine {
    public kp validSoil;
    public kp validGround;
    public kp validWaste;
    public kp validDisposal;
    public StructureBlueprint site;
    public Vect siteOffset;
    public StructureBlueprint soil;
    public Vect soilOffset;
    public StructureBlueprint plantation;
    public Vect plantationOffset;
    protected boolean requiresSoil = true;
    protected boolean requiresGermling = false;
    protected ArrayList cropProviders = new ArrayList();
    protected kp[] fuelItemStacks = new kp[12];
    protected StructureConstruction templateArboretum;
    protected boolean isCleared = false;
    protected boolean isUnbroken = false;
    protected StructureConstruction templateSoil;
    protected StructureConstruction templateWater;
    protected StructureConstruction templatePlantation;

    @Override
    public abstract void openGui(ih var1, ni var2);

    public boolean hasGermlingBySeed(kp germling) {
        for (ICropProvider provider : this.cropProviders) {
            if (!provider.isGermling(germling)) continue;
            return true;
        }
        return false;
    }

    private ICropProvider getCropProvider(kp germling) {
        for (ICropProvider provider : this.cropProviders) {
            if (!provider.isGermling(germling)) continue;
            return provider;
        }
        return null;
    }

    public Planter(TileMachine tile) {
        super(tile);
    }

    public Planter(TileMachine tile, ICropProvider provider) {
        super(tile);
        this.cropProviders.add(provider);
    }

    public Planter(TileMachine tile, ArrayList providers) {
        super(tile);
        for (ICropProvider provider : providers) {
            this.cropProviders.add(provider);
        }
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.isCleared = nbttagcompound.o("IsCleared");
        this.isUnbroken = nbttagcompound.o("IsBuilt");
        tx nbttaglist = nbttagcompound.n("Items");
        this.fuelItemStacks = new kp[this.c()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ph nbttagcompound1 = (ph)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.fuelItemStacks.length) continue;
            this.fuelItemStacks[byte0] = kp.a((ph)nbttagcompound1);
        }
        if (nbttagcompound.c("TemplateArboretum")) {
            this.templateArboretum = new StructureConstruction();
            tx nbttaglistStructure = nbttagcompound.n("TemplateArboretum");
            this.templateArboretum.readFromNBT((ph)nbttaglistStructure.a(0));
        }
        if (nbttagcompound.c("TemplateSoil")) {
            this.templateSoil = new StructureConstruction();
            this.templateWater = new StructureConstruction();
            tx nbttaglistStructure = nbttagcompound.n("TemplateSoil");
            this.templateSoil.readFromNBT((ph)nbttaglistStructure.a(0));
            this.templateWater.readFromNBT((ph)nbttaglistStructure.a(0));
        }
        if (nbttagcompound.c("TemplatePlantation")) {
            this.templatePlantation = new StructureConstruction();
            tx nbttaglistStructure = nbttagcompound.n("TemplatePlantation");
            this.templatePlantation.readFromNBT((ph)nbttaglistStructure.a(0));
        }
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        ph nbttagcompoundStructure;
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("IsCleared", this.isCleared);
        nbttagcompound.a("IsBuilt", this.isUnbroken);
        tx nbttaglist = new tx();
        for (int i = 0; i < this.fuelItemStacks.length; ++i) {
            if (this.fuelItemStacks[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            this.fuelItemStacks[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Items", (jz)nbttaglist);
        if (this.templateArboretum != null) {
            tx nbttaglistStructure = new tx();
            nbttagcompoundStructure = new ph();
            this.templateArboretum.writeToNBT(nbttagcompoundStructure);
            nbttaglistStructure.a((jz)nbttagcompoundStructure);
            nbttagcompound.a("TemplateArboretum", (jz)nbttaglistStructure);
        }
        if (this.templateSoil != null) {
            tx nbttaglistStructure = new tx();
            nbttagcompoundStructure = new ph();
            this.templateSoil.writeToNBT(nbttagcompoundStructure);
            nbttaglistStructure.a((jz)nbttagcompoundStructure);
            nbttagcompound.a("TemplateSoil", (jz)nbttaglistStructure);
        }
        if (this.templatePlantation != null) {
            tx nbttaglistStructure = new tx();
            nbttagcompoundStructure = new ph();
            this.templatePlantation.writeToNBT(nbttagcompoundStructure);
            nbttaglistStructure.a((jz)nbttagcompoundStructure);
            nbttagcompound.a("TemplatePlantation", (jz)nbttaglistStructure);
        }
    }

    protected boolean isSoilSlot(int i) {
        return i < 4;
    }

    protected boolean isGermlingSlot(int i) {
        return i < 8;
    }

    protected boolean isDisposalSlot(int i) {
        return i >= 8;
    }

    protected int getSoilStack() {
        for (int i = 0; i < this.fuelItemStacks.length; ++i) {
            if (!this.isSoilSlot(i) || this.fuelItemStacks[i] == null || !this.fuelItemStacks[i].a(this.validSoil)) continue;
            return i;
        }
        return -1;
    }

    protected int getGermlingStack() {
        for (int i = 0; i < this.fuelItemStacks.length; ++i) {
            if (!this.isGermlingStack(i)) continue;
            return i;
        }
        return -1;
    }

    protected boolean isGermlingStack(int i) {
        if (!this.isGermlingSlot(i)) {
            return false;
        }
        if (this.fuelItemStacks[i] == null) {
            return false;
        }
        return this.hasGermlingBySeed(this.fuelItemStacks[i]);
    }

    protected int getDisposalStack() {
        for (int i = 0; i < this.fuelItemStacks.length; ++i) {
            if (!this.isDisposalSlot(i) || this.fuelItemStacks[i] == null || !this.fuelItemStacks[i].a(this.validDisposal)) continue;
            return i;
        }
        return -1;
    }

    protected int getFreeSoilSlot() {
        for (int i = 0; i < 4; ++i) {
            if (this.fuelItemStacks[i] == null) {
                return i;
            }
            if (!this.fuelItemStacks[i].a(this.validSoil) || this.fuelItemStacks[i].a >= this.fuelItemStacks[i].b()) continue;
            return i;
        }
        return -1;
    }

    protected int getFreeGermlingSlot(kp germling) {
        for (int i = 4; i < 8; ++i) {
            if (this.fuelItemStacks[i] == null) {
                return i;
            }
            if (!this.fuelItemStacks[i].a(germling) || this.fuelItemStacks[i].a >= this.fuelItemStacks[i].b()) continue;
            return i;
        }
        return -1;
    }

    protected int getFreeDisposalSlot() {
        for (int i = 8; i < this.fuelItemStacks.length; ++i) {
            if (this.fuelItemStacks[i] == null) {
                return i;
            }
            if (!this.fuelItemStacks[i].a(this.validDisposal) || this.fuelItemStacks[i].a >= this.fuelItemStacks[i].b()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateServerSide() {
        if (this.tile.k.o() % 20L * 10L != 0L) {
            return;
        }
        if (this.requiresSoil && this.getSoilStack() < 0) {
            this.setErrorState(EnumErrorCode.NORESOURCE);
        } else if (this.requiresGermling && this.getGermlingStack() < 0) {
            this.setErrorState(EnumErrorCode.NORESOURCE);
        } else if (this.getFreeDisposalSlot() < 0) {
            this.setErrorState(EnumErrorCode.NODISPOSAL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        if (Proxy.isMultiplayerWorld()) {
            return false;
        }
        if (this.templateArboretum == null) {
            this.templateArboretum = new StructureConstruction(this.site, this.tile.Coords(), this.siteOffset);
        }
        if (this.soil != null && this.templateSoil == null) {
            this.templateSoil = new StructureConstruction(this.soil, this.tile.Coords(), this.soilOffset);
            this.templateWater = new StructureConstruction(this.soil, this.tile.Coords(), this.soilOffset);
        }
        if (this.plantation != null && this.templatePlantation == null) {
            this.templatePlantation = new StructureConstruction(this.plantation, this.tile.Coords(), this.plantationOffset);
        }
        if (!this.isCleared) {
            this.clearArea();
            return true;
        }
        if (this.maintainWater()) {
            // empty if block
        }
        if (this.maintainSoil() || this.maintainVegetation()) {
            // empty if block
        }
        this.dumpStash();
        return true;
    }

    private void clearArea() {
        if (this.templateArboretum.isFinished) {
            this.isCleared = true;
            this.templateArboretum.reset();
            return;
        }
        int curblockid = 0;
        while (curblockid == 0 && !this.templateArboretum.isFinished) {
            Vect curPos = new Vect(this.templateArboretum.getCurrentX(), this.templateArboretum.getCurrentY(), this.templateArboretum.getCurrentZ());
            curblockid = this.tile.k.a(curPos.x, curPos.y, curPos.z);
            if (curblockid != 0 && !GlobalManager.holyBlockIds.contains(curblockid) && this.templateArboretum.getCurrentBlockId() > -1) {
                ArrayList items = BlockUtil.getBlockItemStack(this.tile.k, curPos);
                this.tile.k.e(curPos.x, curPos.y, curPos.z, 0);
                if (items != null) {
                    for (int i = 0; i < items.size(); ++i) {
                        if (items.get(i) == null || ((kp)items.get(i)).a() == null || ((kp)items.get((int)i)).a <= 0) continue;
                        ja entity = new ja(this.tile.k, (double)curPos.x, (double)curPos.y, (double)curPos.z, (kp)items.get(i));
                        this.tile.k.b((tv)entity);
                    }
                }
            }
            this.templateArboretum.advanceStep();
        }
    }

    private boolean maintainSoil() {
        if (this.templateSoil.isFinished) {
            this.templateSoil.reset();
        }
        int processedBlocks = 0;
        while (!this.templateSoil.isFinished && processedBlocks < Config.planterThrottle) {
            ++processedBlocks;
            if (this.templateSoil.getCurrentBlockId() == this.validGround.c) {
                Vect pos = this.templateSoil.getCurrentPos();
                int blockid = this.tile.k.a(pos.x, pos.y, pos.z);
                int aboveid = this.tile.k.a(pos.x, pos.y + 1, pos.z);
                if (blockid != this.validGround.c && (aboveid == 0 || aboveid == vz.aS.bO)) {
                    if (this.validWaste != null) {
                        if (blockid == this.validWaste.c) {
                            this.collectSand(pos);
                        }
                        if (this.validWaste.c == vz.v.bO && blockid == vz.u.bO) {
                            this.collectSand(pos);
                        }
                    }
                    return this.fillBlock(pos);
                }
            }
            this.templateSoil.advanceStep();
        }
        this.isUnbroken = true;
        return false;
    }

    private boolean maintainWater() {
        if (this.templateWater.isFinished) {
            this.templateWater.reset();
        }
        while (!this.templateWater.isFinished) {
            if (this.templateWater.getCurrentBlockId() == vz.B.bO) {
                Vect pos = this.templateWater.getCurrentPos();
                boolean skip = false;
                int blockid = this.tile.k.a(pos.x, pos.y, pos.z);
                if (blockid != vz.B.bO) {
                    int[] neighbourids = new int[]{this.tile.k.a(pos.x - 1, pos.y, pos.z), this.tile.k.a(pos.x + 1, pos.y, pos.z), this.tile.k.a(pos.x, pos.y, pos.z - 1), this.tile.k.a(pos.x, pos.y, pos.z + 1)};
                    for (int i = 0; i < neighbourids.length; ++i) {
                        if (neighbourids[i] == this.validGround.c || neighbourids[i] == this.validWaste.c) continue;
                        skip = true;
                        break;
                    }
                    if (!skip) {
                        return this.waterBlock(this.templateWater.getCurrentPos());
                    }
                }
            }
            this.templateWater.advanceStep();
        }
        return false;
    }

    private void collectSand(Vect blockPos) {
        this.tile.k.e(blockPos.x, blockPos.y, blockPos.z, 0);
        int slot = this.getFreeDisposalSlot();
        if (slot >= 0) {
            if (this.fuelItemStacks[slot] == null) {
                this.fuelItemStacks[slot] = this.validDisposal.j();
            } else {
                ++this.fuelItemStacks[slot].a;
            }
            return;
        }
    }

    protected boolean maintainVegetation() {
        if (this.templatePlantation == null) {
            return false;
        }
        if (this.templatePlantation.isFinished) {
            this.templatePlantation.reset();
        }
        for (int processedBlocks = 0; !this.templatePlantation.isFinished && processedBlocks < Config.planterThrottle; ++processedBlocks) {
            int z;
            int y;
            int x;
            if (this.templatePlantation.getCurrentBlockId() == vz.y.bO && this.plantSapling(x = this.templatePlantation.getCurrentX(), y = this.templatePlantation.getCurrentY(), z = this.templatePlantation.getCurrentZ())) {
                this.templatePlantation.advanceStep();
                return true;
            }
            this.templatePlantation.advanceStep();
        }
        return false;
    }

    private boolean canFill() {
        return this.getSoilStack() >= 0;
    }

    private void decrSoilStack(int n) {
        int i = this.getSoilStack();
        if (i < 0) {
            return;
        }
        if (this.fuelItemStacks[i] == null) {
            return;
        }
        this.fuelItemStacks[i].a -= n;
        if (this.fuelItemStacks[i].a <= 0) {
            this.fuelItemStacks[i] = null;
        }
    }

    protected void decrSaplingStack(int i, int n) {
        if (i < 0) {
            return;
        }
        if (this.fuelItemStacks[i] == null) {
            return;
        }
        this.fuelItemStacks[i].a -= n;
        if (this.fuelItemStacks[i].a <= 0) {
            this.fuelItemStacks[i] = null;
        }
    }

    private boolean waterBlock(Vect pos) {
        this.tile.k.e(pos.x, pos.y, pos.z, vz.B.bO);
        return true;
    }

    private boolean fillBlock(Vect pos) {
        if (!this.canFill()) {
            return false;
        }
        this.tile.k.b(pos.x, pos.y, pos.z, this.validGround.c, this.validGround.h());
        int blockid = this.tile.k.a(pos.x, pos.y, pos.z);
        if (blockid == this.validGround.c) {
            this.decrSoilStack(1);
        }
        return true;
    }

    protected boolean plantSapling(int x, int y, int z) {
        for (int stack = 0; stack < this.fuelItemStacks.length; ++stack) {
            if (!this.isGermlingStack(stack)) continue;
            if (stack <= 0) {
                return false;
            }
            ICropProvider provider = this.getCropProvider(this.fuelItemStacks[stack]);
            if (provider == null || !provider.doPlant(this.fuelItemStacks[stack], this.tile.k, x, y, z)) continue;
            this.decrSaplingStack(stack, 1);
            return true;
        }
        return false;
    }

    private void dumpStash() {
        buildcraft.api.Orientations[] pipes = BlockUtil.getPipeDirections(this.tile.k, this.tile.Coords(), this.tile.getOrientation());
        if (pipes.length > 0) {
            this.dumpToPipe(pipes);
        } else {
            ni[] inventories = BlockUtil.getAdjacentInventories(this.tile.k, this.tile.Coords());
            this.dumpToInventory(inventories);
        }
    }

    private void dumpToPipe(buildcraft.api.Orientations[] pipes) {
        for (int i = 8; i < this.fuelItemStacks.length; ++i) {
            if (this.fuelItemStacks[i] == null || this.fuelItemStacks[i].a <= 0) continue;
            buildcraft.api.Orientations[] filtered = !Config.planterSideSensitive ? pipes : BlockUtil.filterPipeDirections(pipes, new buildcraft.api.Orientations[]{buildcraft.api.Orientations.YNeg, buildcraft.api.Orientations.YPos});
            while (this.fuelItemStacks[i].a > 0 && filtered.length > 0) {
                BlockUtil.putFromStackIntoPipe(this.tile, filtered, this.fuelItemStacks[i]);
            }
            if (this.fuelItemStacks[i].a > 0) continue;
            this.fuelItemStacks[i] = null;
        }
    }

    private void dumpToInventory(ni[] inventories) {
        for (int i = 8; i < this.fuelItemStacks.length; ++i) {
            if (this.fuelItemStacks[i] == null || this.fuelItemStacks[i].a <= 0) continue;
            block1: for (int j = 0; j < inventories.length; ++j) {
                if (this.fuelItemStacks[i] == null || inventories[j] instanceof TilePlanter) continue;
                for (int k = 0; k < inventories[j].c(); ++k) {
                    int available;
                    kp stack = inventories[j].g_(k);
                    if (stack == null) {
                        inventories[j].a(k, this.fuelItemStacks[i]);
                        this.fuelItemStacks[i] = null;
                        continue block1;
                    }
                    if (stack.c != this.fuelItemStacks[i].c || (available = inventories[j].a() - stack.a) <= 0) continue;
                    if (available >= this.fuelItemStacks[i].a) {
                        stack.a += this.fuelItemStacks[i].a;
                        this.fuelItemStacks[i] = null;
                        continue block1;
                    }
                    stack.a = inventories[j].a();
                    this.fuelItemStacks[i].a -= available;
                }
            }
        }
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        int max = 0;
        int avail = 0;
        for (int i = 4; i < 8; ++i) {
            max += 64;
            if (this.fuelItemStacks[i] == null) continue;
            avail += this.fuelItemStacks[i].a;
        }
        return (float)avail / (float)max > percentage;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int max = 0;
        int avail = 0;
        for (int i = 0; i < 4; ++i) {
            max += 64;
            if (this.fuelItemStacks[i] == null) continue;
            avail += this.fuelItemStacks[i].a;
        }
        return (float)avail / (float)max > percentage;
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        if (stack.a(this.validSoil)) {
            int slot = this.getFreeSoilSlot();
            if (slot < 0) {
                return false;
            }
            if (doAdd) {
                while (stack.a > 0 && slot >= 0) {
                    if (this.fuelItemStacks[slot] == null) {
                        this.fuelItemStacks[slot] = stack.j();
                        stack.a = 0;
                    } else {
                        StackUtils.mergeStacks(stack, this.fuelItemStacks[slot]);
                    }
                    slot = this.getFreeSoilSlot();
                }
            }
            return true;
        }
        if (this.hasGermlingBySeed(stack)) {
            int slot = this.getFreeGermlingSlot(stack);
            if (slot < 0) {
                return false;
            }
            if (doAdd) {
                while (stack.a > 0 && slot >= 0) {
                    if (this.fuelItemStacks[slot] == null) {
                        this.fuelItemStacks[slot] = stack.j();
                        stack.a = 0;
                    } else {
                        StackUtils.mergeStacks(stack, this.fuelItemStacks[slot]);
                    }
                    slot = this.getFreeGermlingSlot(stack);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        for (int i = 8; i < this.fuelItemStacks.length; ++i) {
            if (this.fuelItemStacks[i] == null || !this.fuelItemStacks[i].a(this.validDisposal)) continue;
            kp product = this.validDisposal.j();
            if (doRemove) {
                this.a(i, 1);
            }
            return product;
        }
        return null;
    }

    @Override
    public int c() {
        return this.fuelItemStacks.length;
    }

    @Override
    public kp g_(int i) {
        return this.fuelItemStacks[i];
    }

    @Override
    public kp a(int i, int j) {
        if (this.fuelItemStacks[i] == null) {
            return null;
        }
        if (this.fuelItemStacks[i].a <= j) {
            kp removed = this.fuelItemStacks[i];
            this.fuelItemStacks[i] = null;
            return removed;
        }
        kp removed = this.fuelItemStacks[i].a(j);
        if (this.fuelItemStacks[i].a == 0) {
            this.fuelItemStacks[i] = null;
        }
        return removed;
    }

    @Override
    public kp b(int slot) {
        if (this.fuelItemStacks[slot] == null) {
            return null;
        }
        kp toReturn = this.fuelItemStacks[slot];
        this.fuelItemStacks[slot] = null;
        return toReturn;
    }

    @Override
    public void a(int i, kp itemstack) {
        this.fuelItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.a()) {
            itemstack.a = this.a();
        }
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return 0;
        }
        if (side == 1) {
            return 4;
        }
        return 8;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 4;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowSoil25);
        res.add(ForestryTrigger.lowSoil10);
        res.add(ForestryTrigger.lowGermlings25);
        res.add(ForestryTrigger.lowGermlings10);
        return res;
    }
}

