/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.harvesters;

import forestry.api.cultivation.ICropEntity;
import forestry.api.cultivation.ICropProvider;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.TileMachine;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Orientations;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.cultivation.TilePlanter;
import java.util.ArrayList;
import java.util.List;

public abstract class Harvester
extends Machine {
    private ArrayList validWindfallIds = new ArrayList();
    private ArrayList validWindfall = new ArrayList();
    protected ArrayList cropProviders = new ArrayList();
    protected boolean isSideSensitive = true;
    protected kp[] harvestStacks = new kp[8];
    protected Vect area = new Vect(21, 13, 21);
    protected Vect posOffset = new Vect(-10, -2, -10);
    protected Vect posCurrent = new Vect(0, 0, 0);
    protected Vect posNext = null;
    protected boolean isFinished = false;
    private short productSlot1 = 0;
    private short windfallSlot1 = (short)4;

    public void putWindfall(kp windfall) {
        this.validWindfallIds.add(windfall.c);
        this.validWindfall.add(windfall);
    }

    public boolean isCropAt(int x, int y, int z) {
        for (ICropProvider provider : this.cropProviders) {
            if (!provider.isCrop(this.tile.k, x, y, z)) continue;
            return true;
        }
        return false;
    }

    private ICropProvider getCropProvider(int x, int y, int z) {
        for (ICropProvider provider : this.cropProviders) {
            if (!provider.isCrop(this.tile.k, x, y, z)) continue;
            return provider;
        }
        return null;
    }

    public boolean hasWindfallById(int id2) {
        return this.validWindfallIds.contains(id2);
    }

    public kp getWindfall(kp windfall) {
        for (kp stack : this.validWindfall) {
            if (!stack.a(windfall)) continue;
            return stack;
        }
        return null;
    }

    public Harvester(TileMachine machine) {
        super(machine);
    }

    public Harvester(TileMachine machine, ICropProvider provider) {
        super(machine);
        this.cropProviders.add(provider);
        kp[] windfall = provider.getWindfall();
        if (windfall != null && windfall.length > 0) {
            for (kp itemstack : windfall) {
                this.putWindfall(itemstack);
            }
        }
    }

    public Harvester(TileMachine machine, ArrayList providers) {
        super(machine);
        for (ICropProvider provider : providers) {
            this.cropProviders.add(provider);
            kp[] windfall = provider.getWindfall();
            if (windfall == null || windfall.length <= 0) continue;
            for (kp itemstack : windfall) {
                this.putWindfall(itemstack);
            }
        }
    }

    @Override
    public void openGui(ih player, ni tile) {
    }

    @Override
    public void updateServerSide() {
    }

    protected int getFreeProductSlot(kp product) {
        for (int i = this.productSlot1; i < this.windfallSlot1; ++i) {
            if (this.harvestStacks[i] == null) {
                return i;
            }
            if (!this.harvestStacks[i].a(product) || this.harvestStacks[i].a >= this.harvestStacks[i].b()) continue;
            return i;
        }
        return -1;
    }

    private int getFreeWindfallSlot(kp windfall) {
        for (int i = this.windfallSlot1; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null) {
                return i;
            }
            if (!this.harvestStacks[i].a(windfall) || this.harvestStacks[i].a >= this.harvestStacks[i].b()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean doWork() {
        if (Proxy.isMultiplayerWorld()) {
            return false;
        }
        if (this.posNext != null) {
            Vect killMe = this.posNext;
            this.posNext = null;
            ICropProvider provider = this.getCropProvider(killMe.x, killMe.y, killMe.z);
            if (provider == null) {
                return false;
            }
            ICropEntity crop = provider.getCrop(this.tile.k, killMe.x, killMe.y, killMe.z);
            if (crop != null && crop.isHarvestable()) {
                this.hewTree(crop);
            }
            return true;
        }
        int processedBlocks = 0;
        while (!this.isFinished && processedBlocks < Config.harvesterThrottle) {
            ICropEntity crop;
            ++processedBlocks;
            this.advanceAxe();
            Vect posBlock = this.posCurrent.add(this.tile.Coords());
            posBlock = posBlock.add(this.posOffset);
            this.tile.k.a(posBlock.x, posBlock.y, posBlock.z);
            ICropProvider provider = this.getCropProvider(posBlock.x, posBlock.y, posBlock.z);
            if (provider == null || (crop = provider.getCrop(this.tile.k, posBlock.x, posBlock.y, posBlock.z)) == null || !crop.isHarvestable()) continue;
            this.hewTree(crop);
            break;
        }
        this.collectWindfall();
        this.dumpStash();
        if (this.isFinished) {
            this.resetAxe();
        }
        return true;
    }

    protected void advanceAxe() {
        if (this.posCurrent.z < this.area.z - 1) {
            ++this.posCurrent.z;
        } else {
            this.posCurrent.z = 0;
            if (this.posCurrent.x < this.area.x - 1) {
                ++this.posCurrent.x;
            } else {
                this.posCurrent.x = 0;
                if (this.posCurrent.y < this.area.y - 1) {
                    ++this.posCurrent.y;
                } else {
                    this.isFinished = true;
                }
            }
        }
    }

    protected void hewTree(ICropEntity entity) {
        ArrayList harvest = entity.doHarvest();
        this.storeProduct(harvest);
        int[] next = entity.getNextPosition();
        if (next == null || next.length <= 0) {
            return;
        }
        this.posNext = new Vect(next[0], next[1], next[2]);
    }

    protected void storeProduct(ArrayList harvest) {
        for (kp stack : harvest) {
            int slot = this.getFreeProductSlot(stack);
            if (slot < 0) {
                return;
            }
            if (this.harvestStacks[slot] == null) {
                this.harvestStacks[slot] = stack;
                continue;
            }
            if (this.harvestStacks[slot].a > this.harvestStacks[slot].b() - stack.a || !this.harvestStacks[slot].a(stack)) continue;
            this.harvestStacks[slot].a += stack.a;
        }
    }

    protected void resetAxe() {
        this.isFinished = false;
        this.posCurrent = new Vect(0, 0, 0);
    }

    protected void collectWindfall() {
        Vect min = new Vect(this.tile.l + this.posOffset.x, this.tile.m + this.posOffset.y, this.tile.n + this.posOffset.z);
        Vect max = new Vect(this.tile.l + this.posOffset.x + this.area.x, this.tile.m + this.posOffset.y + this.area.y, this.tile.n + this.posOffset.z + this.area.z);
        fp harvestBox = fp.b((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = this.tile.k.a(tv.class, harvestBox);
        for (int i = 0; i < list.size(); ++i) {
            kp windfall;
            tv entity = (tv)list.get(i);
            if (!(entity instanceof ja)) continue;
            ja item = (ja)entity;
            if (item.a == null || !this.hasWindfallById(item.a.c) || (windfall = this.getWindfall(item.a)) == null || windfall.h() != item.a.h() || !this.storeWindfall(item.a)) continue;
            item.X();
        }
    }

    private boolean storeWindfall(kp item) {
        int slot = this.getFreeWindfallSlot(item);
        if (slot < 0) {
            return false;
        }
        if (this.harvestStacks[slot] == null) {
            this.harvestStacks[slot] = item.j();
        } else if (this.harvestStacks[slot].a < this.a() && this.harvestStacks[slot].a(item)) {
            ++this.harvestStacks[slot].a;
        }
        return true;
    }

    protected void dumpStash() {
        buildcraft.api.Orientations[] pipes = BlockUtil.getPipeDirections(this.tile.k, this.tile.Coords(), this.tile.getOrientation());
        if (pipes.length > 0) {
            this.dumpToPipe(pipes);
        } else {
            ni[] inventories = BlockUtil.getAdjacentInventories(this.tile.k, this.tile.Coords());
            this.dumpToInventory(inventories);
        }
    }

    private void dumpToPipe(buildcraft.api.Orientations[] pipes) {
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null || this.harvestStacks[i].a <= 0) continue;
            buildcraft.api.Orientations[] filtered = !this.isSideSensitive || !Config.harvesterSideSensitive ? pipes : (this.hasWindfallById(this.harvestStacks[i].c) ? BlockUtil.filterPipeDirections(pipes, new buildcraft.api.Orientations[]{buildcraft.api.Orientations.XNeg, buildcraft.api.Orientations.XPos, buildcraft.api.Orientations.ZNeg, buildcraft.api.Orientations.ZPos}) : BlockUtil.filterPipeDirections(pipes, new buildcraft.api.Orientations[]{buildcraft.api.Orientations.YNeg, buildcraft.api.Orientations.YPos}));
            while (this.harvestStacks[i].a > 0 && filtered.length > 0) {
                BlockUtil.putFromStackIntoPipe(this.tile, filtered, this.harvestStacks[i]);
            }
            if (this.harvestStacks[i].a > 0) continue;
            this.harvestStacks[i] = null;
        }
    }

    private void dumpToInventory(ni[] inventories) {
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null || this.harvestStacks[i].a <= 0) continue;
            for (int j = 0; j < inventories.length; ++j) {
                if (this.harvestStacks[i] == null || inventories[j] instanceof TilePlanter) continue;
                ni inventory = Utils.getChest(inventories[j]);
                StackUtils.stowInInventory(this.harvestStacks[i], inventory, true);
                if (this.harvestStacks[i].a > 0) continue;
                this.harvestStacks[i] = null;
            }
        }
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        tx nbttaglist = nbttagcompound.n("Items");
        this.harvestStacks = new kp[this.c()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ph nbttagcompound1 = (ph)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.harvestStacks.length) continue;
            this.harvestStacks[byte0] = kp.a((ph)nbttagcompound1);
        }
        this.isFinished = nbttagcompound.o("IsFinished");
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        tx nbttaglist = new tx();
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            this.harvestStacks[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Items", (jz)nbttaglist);
        nbttagcompound.a("IsFinished", this.isFinished);
    }

    @Override
    public kp g_(int i) {
        return this.harvestStacks[i];
    }

    @Override
    public int c() {
        return this.harvestStacks.length;
    }

    @Override
    public kp a(int i, int j) {
        if (this.harvestStacks[i] == null) {
            return null;
        }
        if (this.harvestStacks[i].a <= j) {
            kp product = this.harvestStacks[i];
            this.harvestStacks[i] = null;
            return product;
        }
        kp product = this.harvestStacks[i].a(j);
        if (this.harvestStacks[i].a == 0) {
            this.harvestStacks[i] = null;
        }
        return product;
    }

    @Override
    public void a(int i, kp itemstack) {
        this.harvestStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.a()) {
            itemstack.a = this.a();
        }
    }

    @Override
    public kp b(int slot) {
        if (this.harvestStacks[slot] == null) {
            return null;
        }
        kp toReturn = this.harvestStacks[slot];
        this.harvestStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 4;
        }
        return 0;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 4;
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        return false;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null) continue;
            kp product = null;
            if (this.hasWindfallById(this.harvestStacks[i].a().bP)) {
                if (Config.harvesterSideSensitive && this.isSideSensitive && from != Orientations.YNeg && from != Orientations.YPos) continue;
                product = this.getWindfall(this.harvestStacks[i]);
            } else {
                if (Config.harvesterSideSensitive && this.isSideSensitive && (from == Orientations.YNeg || from == Orientations.YPos)) continue;
                product = new kp(this.harvestStacks[i].a().bP, 1, 0);
            }
            if (doRemove && product != null) {
                this.a(i, 1);
            }
            return product;
        }
        return null;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
    }
}

