/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forge.oredict.OreDictionary;
import java.util.ArrayList;

public class StackUtils {
    public static boolean stowInInventory(kp itemstack, ni inventory, boolean doAdd) {
        return StackUtils.stowInInventory(itemstack, inventory, doAdd, 0, inventory.c());
    }

    public static boolean stowInInventory(kp itemstack, ni inventory, boolean doAdd, int slot1, int count) {
        boolean added = false;
        for (int i = slot1; i < slot1 + count; ++i) {
            kp inventoryStack = inventory.g_(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.a(i, itemstack.j());
                    itemstack.a = 0;
                }
                return true;
            }
            if (inventoryStack.a >= inventoryStack.b() || !inventoryStack.a(itemstack)) continue;
            int space = inventoryStack.b() - inventoryStack.a;
            if (space > itemstack.a) {
                if (doAdd) {
                    inventoryStack.a += itemstack.a;
                    itemstack.a = 0;
                }
                return true;
            }
            if (doAdd) {
                inventoryStack.a = inventoryStack.b();
                itemstack.a -= space;
            }
            added = true;
        }
        return added;
    }

    public static void mergeStacks(kp giver, kp receptor) {
        if (receptor.a >= 64) {
            return;
        }
        if (!receptor.a(giver)) {
            return;
        }
        if (giver.a <= receptor.b() - receptor.a) {
            receptor.a += giver.a;
            giver.a = 0;
            return;
        }
        kp temp = giver.a(receptor.b() - receptor.a);
        receptor.a += temp.a;
        temp.a = 0;
    }

    public static boolean freeSpaceInStack(kp stack, int maxSize) {
        if (stack == null) {
            return true;
        }
        return stack.a < maxSize;
    }

    public static boolean canAddToStack(kp stack, kp inventory) {
        if (inventory == null) {
            return true;
        }
        return stack.c == inventory.c;
    }

    public static kp createSplitStack(kp stack, int amount) {
        kp split = new kp(stack.c, amount, stack.h());
        if (stack.o() != null) {
            ph nbttagcompound = (ph)stack.o().b();
            split.d(nbttagcompound);
        }
        return split;
    }

    public static kp[] condenseStacks(kp[] stacks) {
        ArrayList<kp> condensed = new ArrayList<kp>();
        for (kp stack : stacks) {
            if (stack == null) continue;
            boolean matched = false;
            for (kp cached : condensed) {
                if (!cached.a(stack)) continue;
                cached.a += stack.a;
                matched = true;
            }
            if (matched) continue;
            condensed.add(stack.j());
        }
        return condensed.toArray(new kp[0]);
    }

    public static int containsSets(kp[] set, kp[] stock) {
        return StackUtils.containsSets(set, stock, false);
    }

    public static int containsSets(kp[] set, kp[] stock, boolean oreDictionary) {
        int count = 0;
        kp[] condensedRequired = StackUtils.condenseStacks(set);
        kp[] condensedOffered = StackUtils.condenseStacks(stock);
        for (kp req : condensedRequired) {
            boolean matched = false;
            for (kp offer : condensedOffered) {
                boolean isEqual = false;
                isEqual = oreDictionary ? StackUtils.isItemOreEqual(req, offer) : req.a(offer);
                if (!isEqual) continue;
                matched = true;
                int stackCount = (int)Math.floor(offer.a / req.a);
                if (stackCount <= 0) {
                    return 0;
                }
                if (count == 0) {
                    count = stackCount;
                    continue;
                }
                if (count <= stackCount) continue;
                count = stackCount;
            }
            if (matched) continue;
            return 0;
        }
        return count;
    }

    public static boolean isItemOreEqual(kp base, kp comparison) {
        if (base.a(comparison)) {
            return true;
        }
        ArrayList copperIngots = OreDictionary.getOres((String)"ingotCopper");
        for (kp ore : copperIngots) {
            if (!ore.a(base)) continue;
            for (kp ore1 : copperIngots) {
                if (!ore1.a(comparison)) continue;
                return true;
            }
            return false;
        }
        ArrayList tinIngots = OreDictionary.getOres((String)"ingotTin");
        for (kp ore : tinIngots) {
            if (!ore.a(base)) continue;
            for (kp ore1 : tinIngots) {
                if (!ore1.a(comparison)) continue;
                return true;
            }
            return false;
        }
        ArrayList bronzeIngots = OreDictionary.getOres((String)"ingotBronze");
        for (kp ore : bronzeIngots) {
            if (!ore.a(base)) continue;
            for (kp ore1 : bronzeIngots) {
                if (!ore1.a(comparison)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

