/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.core.INBTTagable;
import forestry.api.liquids.LiquidStack;
import forestry.core.Proxy;
import forestry.core.interfaces.IPipette;
import forestry.core.items.ItemForestry;
import forestry.core.unity.IItemIconByDamage;
import forestry.core.unity.IItemNBTSynched;
import forestry.core.unity.IItemTooltipped;
import forestry.core.utils.Orientations;
import forestry.core.utils.TankSlot;
import java.util.List;

public class ItemPipette
extends ItemForestry
implements IPipette,
IItemTooltipped,
IItemNBTSynched,
IItemIconByDamage {
    public ItemPipette(int i) {
        super(i);
        this.e(1);
    }

    public boolean i() {
        return true;
    }

    @Override
    public boolean func_46056_k() {
        return true;
    }

    @Override
    public boolean canPipette(kp itemstack) {
        PipetteContents contained = new PipetteContents(itemstack.o());
        return !contained.isFull(1000);
    }

    @Override
    public int fill(kp itemstack, LiquidStack liquid, boolean doFill) {
        PipetteContents contained = new PipetteContents(itemstack.o());
        int limit = 1000;
        int filled = 0;
        if (contained.contents == null) {
            filled = liquid.liquidAmount > limit ? limit : liquid.liquidAmount;
            contained.contents = new LiquidStack(liquid.itemID, filled, liquid.itemMeta);
            filled = liquid.liquidAmount;
        } else {
            if (contained.contents.liquidAmount >= limit) {
                return 0;
            }
            if (!contained.contents.isLiquidEqual(liquid)) {
                return 0;
            }
            int space = limit - contained.contents.liquidAmount;
            filled = liquid.liquidAmount > space ? space : liquid.liquidAmount;
            contained.contents.liquidAmount += filled;
        }
        if (doFill) {
            ph nbttagcompound = new ph();
            contained.b(nbttagcompound);
            itemstack.d(nbttagcompound);
            itemstack.b(1);
        }
        return filled;
    }

    @Override
    public void addInformation(kp itemstack, List list) {
        PipetteContents contained = new PipetteContents(itemstack.o());
        contained.addTooltip(list);
    }

    @Override
    public int getIconFromDamage(int damage) {
        if (damage > 0) {
            return 21;
        }
        return 20;
    }

    @Override
    public void emptyInto(kp itemstack, TankSlot tank, boolean doEmpty) {
        LiquidStack liquid;
        PipetteContents contained = new PipetteContents(itemstack.o());
        if (contained.contents == null) {
            return;
        }
        if (tank.liquidId > 0 && tank.quantity > 0 && !contained.contents.isLiquidEqual(liquid = new LiquidStack(tank.liquidId, tank.quantity, tank.liquidMeta))) {
            return;
        }
        int filled = tank.fill(Orientations.Unknown, contained.contents, doEmpty);
        contained.contents.liquidAmount -= filled;
        if (doEmpty) {
            if (contained.contents.liquidAmount <= 0) {
                itemstack.d(null);
            } else {
                ph nbttagcompound = new ph();
                contained.b(nbttagcompound);
                itemstack.d(nbttagcompound);
            }
            itemstack.b(0);
        }
    }

    class PipetteContents
    implements INBTTagable {
        LiquidStack contents;

        public PipetteContents(ph nbttagcompound) {
            if (nbttagcompound != null) {
                this.a(nbttagcompound);
            }
        }

        @Override
        public void a(ph nbttagcompound) {
            this.contents = LiquidStack.loadLiquidStackFromNBT(nbttagcompound);
        }

        @Override
        public void b(ph nbttagcompound) {
            if (this.contents != null) {
                this.contents.writeToNBT(nbttagcompound);
            }
        }

        public boolean isFull(int limit) {
            if (this.contents == null) {
                return false;
            }
            return this.contents.itemID > 0 && this.contents.liquidAmount >= limit;
        }

        public void addTooltip(List list) {
            if (this.contents == null) {
                return;
            }
            if (this.contents.itemID <= 0) {
                return;
            }
            String descr = Proxy.getItemDisplayName(id.d[this.contents.itemID]);
            list.add(descr);
        }
    }
}

