/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.core.items.ItemForestry;
import forestry.core.unity.IItemColourOverlayed;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;

public class ItemOverlay
extends ItemForestry
implements IItemColourOverlayed {
    private OverlayInfo[] overlays;
    private int primaryIconIndex = 0;
    private int secondaryIconIndex = 0;

    public ItemOverlay(int i, OverlayInfo[] overlays) {
        super(i);
        this.f(0);
        this.a(true);
        this.overlays = overlays;
    }

    public boolean g() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public ItemOverlay setIcons(int primary, int secondary) {
        this.primaryIconIndex = primary;
        this.secondaryIconIndex = secondary;
        return this;
    }

    public void addCreativeItems(ArrayList itemList) {
        for (int i = 0; i < this.overlays.length; ++i) {
            if (this.overlays[i].isSecret) continue;
            itemList.add(new kp((id)this, 1, i));
        }
    }

    @Override
    public boolean requiresMultipleRenderPasses() {
        if (this.secondaryIconIndex != 0) {
            return true;
        }
        return true;
    }

    @Override
    public String getItemDisplayName(kp itemstack) {
        if (itemstack.h() < 0 || itemstack.h() >= this.overlays.length) {
            return null;
        }
        return StringUtil.localize(this.b() + "." + this.overlays[itemstack.h()].name);
    }

    @Override
    public int getColorFromDamage(int i, int j) {
        if (j == 0 || this.overlays[i].secondaryColor == 0) {
            return this.overlays[i].primaryColor;
        }
        return this.overlays[i].secondaryColor;
    }

    @Override
    public int getIconFromDamageForRenderPass(int i, int j) {
        if (j > 0 && this.overlays[i].secondaryColor != 0) {
            return this.secondaryIconIndex;
        }
        return this.primaryIconIndex;
    }

    public static class OverlayInfo {
        public String name;
        public int primaryColor = 0;
        public int secondaryColor = 0;
        public boolean isSecret = false;

        public OverlayInfo(String name, int primaryColor, int secondaryColor) {
            this.name = name;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
        }

        public OverlayInfo(String name, int primaryColor) {
            this(name, primaryColor, 0);
        }

        public OverlayInfo setIsSecret() {
            this.isSecret = true;
            return this;
        }
    }
}

