/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.IPowerReceptor;
import buildcraft.api.ISpecialInventory;
import buildcraft.api.LiquidSlot;
import buildcraft.api.Orientations;
import buildcraft.api.Position;
import buildcraft.api.PowerFramework;
import buildcraft.api.PowerProvider;
import forestry.core.Proxy;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.EngineFactory;
import forestry.core.gadgets.EnginePackage;
import forestry.core.gadgets.Gadget;
import forestry.core.gadgets.GadgetManager;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.ISocketable;
import forestry.core.interfaces.ITankContainer;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.TankSlot;
import forestry.plugins.PluginBuildCraft;
import forge.ISidedInventory;
import ic2.api.Direction;
import ic2.api.IEnergySink;
import java.util.LinkedList;

public class TileEngine
extends TileForestry
implements IPowerReceptor,
ISidedInventory,
ITankContainer,
ISpecialInventory,
IEnergySink,
ISocketable {
    public Engine engine;
    public boolean isActive = false;
    public int stagePiston = 0;
    public float pistonSpeedServer = 0.0f;
    private PowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public TileEngine() {
        this.powerProvider.configure(0, 10, 200, 10, 100000);
    }

    @Override
    protected void initialize() {
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        if (this.engine == null) {
            this.createEngine();
        }
    }

    private void createEngine() {
        if (this.engine != null) {
            return;
        }
        int meta = this.k.c(this.l, this.m, this.n);
        if (!GadgetManager.hasPlanterPackage(meta)) {
            ModLoader.getLogger().info("Encountered an engine with meta " + meta + ". However no such EnginePackage exists. Reverting to 0.");
            meta = 0;
        }
        this.pack = GadgetManager.getEnginePackage(meta);
        EngineFactory factory = ((EnginePackage)this.pack).factory;
        if (factory == null) {
            throw new RuntimeException("Missing EngineFactory for meta " + meta);
        }
        this.engine = factory.createEngine(this);
        this.k.h(this.l, this.m, this.n, meta);
    }

    @Override
    public void q_() {
        if (Proxy.isMultiplayerWorld()) {
            if (this.stagePiston != 0) {
                this.engine.progress += this.pistonSpeedServer;
                if (this.engine.progress > 1.0f) {
                    this.stagePiston = 0;
                    this.engine.progress = 0.0f;
                }
            } else if (this.isActive) {
                this.stagePiston = 1;
            }
            return;
        }
        super.q_();
        this.engine.updateServerSide();
        Position posTarget = new Position(this.l, this.m, this.n, this.getOrientation());
        posTarget.moveForwards(1.0);
        qj tile = this.k.b((int)posTarget.x, (int)posTarget.y, (int)posTarget.z);
        float newPistonSpeed = this.engine.getPistonSpeed();
        if (newPistonSpeed != this.pistonSpeedServer) {
            this.pistonSpeedServer = newPistonSpeed;
            this.sendNetworkUpdate();
        }
        if (this.stagePiston != 0) {
            this.engine.progress += this.pistonSpeedServer;
            if ((double)this.engine.progress > 0.5 && this.stagePiston == 1) {
                this.stagePiston = 2;
                if (this.isPoweredTile(tile)) {
                    IPowerReceptor receptor = (IPowerReceptor)tile;
                    int extractedEnergy = this.engine.extractEnergy(receptor.getPowerProvider().minEnergyReceived, receptor.getPowerProvider().maxEnergyReceived, true);
                    if (extractedEnergy > 0) {
                        PluginBuildCraft.instance.invokeReceiveEnergyMethod(receptor.getPowerProvider(), extractedEnergy);
                    }
                }
            } else if (this.engine.progress >= 1.0f) {
                this.engine.progress = 0.0f;
                this.stagePiston = 0;
            }
        } else if (this.canPowerTo(tile)) {
            IPowerReceptor receptor = (IPowerReceptor)tile;
            if (this.engine.extractEnergy(receptor.getPowerProvider().minEnergyReceived, receptor.getPowerProvider().maxEnergyReceived, false) > 0) {
                this.stagePiston = 1;
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.engine.dissipateHeat();
        this.engine.generateHeat();
        if (this.engine.mayBurn()) {
            this.engine.burn();
        } else {
            this.engine.extractEnergy(0, 2, true);
        }
    }

    private void setActive(boolean isActive) {
        if (this.isActive == isActive) {
            return;
        }
        this.isActive = isActive;
        this.sendNetworkUpdate();
    }

    private boolean canPowerTo(qj tile) {
        return this.isActivated() && this.isPoweredTile(tile);
    }

    public boolean isBurning() {
        return this.engine.isBurning();
    }

    public int getBurnTimeRemainingScaled(int i) {
        return this.engine.getBurnTimeRemainingScaled(i);
    }

    @Override
    public void a(ph nbttagcompound) {
        super.a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        int kind = nbttagcompound.f("Kind");
        this.pack = GadgetManager.getEnginePackage(kind);
        this.engine = ((EnginePackage)this.pack).factory.createEngine(this);
        this.engine.readFromNBT(nbttagcompound);
        this.stagePiston = nbttagcompound.f("stagePiston");
    }

    @Override
    public void b(ph nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        int kind = this.k.c(this.l, this.m, this.n);
        if (GadgetManager.hasEnginePackage(kind)) {
            nbttagcompound.a("Kind", kind);
        } else {
            nbttagcompound.a("Kind", 0);
        }
        this.engine.writeToNBT(nbttagcompound);
        nbttagcompound.a("stagePiston", this.stagePiston);
    }

    public boolean isPoweredTile(qj tile) {
        if (tile == null) {
            return false;
        }
        if (!(tile instanceof IPowerReceptor)) {
            return false;
        }
        IPowerReceptor receptor = (IPowerReceptor)tile;
        return receptor.getPowerProvider() != null;
    }

    public void rotateEngine() {
        if (this.engine == null) {
            this.initialize();
            this.isInited = true;
        }
        for (int i = this.getOrientation().ordinal() + 1; i <= this.getOrientation().ordinal() + 6; ++i) {
            Orientations orient = Orientations.values()[i % 6];
            Position pos = new Position(this.l, this.m, this.n, orient);
            pos.moveForwards(1.0);
            qj tile = this.k.b((int)pos.x, (int)pos.y, (int)pos.z);
            if (!this.isPoweredTile(tile)) continue;
            if (this.engine != null) {
                this.setOrientation(orient);
            }
            this.k.k(this.l, this.m, this.n);
            break;
        }
    }

    @Override
    public Gadget getMachine() {
        return this.engine;
    }

    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public boolean throwsErrors() {
        return true;
    }

    @Override
    public boolean hasHints() {
        if (this.engine != null) {
            return this.engine.hasHints();
        }
        return false;
    }

    @Override
    public String[] getHints() {
        if (this.engine != null) {
            return this.engine.getHints();
        }
        return null;
    }

    @Override
    public void setPowerProvider(PowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public PowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        this.engine.addEnergy((int)(PluginBuildCraft.instance.invokeUseEnergyMethod(this.powerProvider, 1.0f, this.engine.maxEnergyReceived(), true) * 0.95f));
    }

    @Override
    public int powerRequest() {
        return 0;
    }

    public int c() {
        return this.engine.c();
    }

    public kp g_(int i) {
        return this.engine.g_(i);
    }

    public kp a(int i, int j) {
        return this.engine.a(i, j);
    }

    public void a(int i, kp itemstack) {
        this.engine.a(i, itemstack);
    }

    public String e() {
        return this.engine.e();
    }

    public int a() {
        return this.engine.a();
    }

    public void f() {
    }

    public void g() {
    }

    public kp b(int slot) {
        if (this.engine != null) {
            return this.engine.b(slot);
        }
        return null;
    }

    public int getStartInventorySide(int side) {
        if (this.engine == null) {
            return 0;
        }
        return this.engine.getStartInventorySide(side);
    }

    public int getSizeInventorySide(int side) {
        if (this.engine == null) {
            return 0;
        }
        return this.engine.getSizeInventorySide(side);
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return false;
        }
        if (from == this.getOrientation()) {
            return false;
        }
        if (this.engine != null) {
            return this.engine.addItem(stack, doAdd, PluginBuildCraft.convertBuildCraftOrientation(from));
        }
        return false;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return null;
        }
        if (from == this.getOrientation()) {
            return null;
        }
        if (this.engine != null) {
            return this.engine.extractItem(doRemove, PluginBuildCraft.convertBuildCraftOrientation(from));
        }
        return null;
    }

    @Override
    public int fill(Orientations from, int quantity, int id2, boolean doFill) {
        if (this.engine == null) {
            return 0;
        }
        if (from == this.getOrientation()) {
            return 0;
        }
        int used = this.engine.fill(PluginBuildCraft.convertBuildCraftOrientation(from), quantity, id2, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int empty(int quantityMax, boolean doEmpty) {
        return 0;
    }

    @Override
    public int getLiquidQuantity() {
        return 0;
    }

    @Override
    public int getLiquidId() {
        return 0;
    }

    @Override
    public LiquidSlot[] getLiquidSlots() {
        if (this.engine != null) {
            return PluginBuildCraft.instance.convertToBCLiquidSlots(this.engine.getLiquidContents());
        }
        return new LiquidSlot[0];
    }

    @Override
    public TankSlot[] getLiquidTanks() {
        if (this.engine != null) {
            return this.engine.getLiquidContents();
        }
        return new TankSlot[0];
    }

    public int getCapacity() {
        if (this.engine != null) {
            TankSlot[] slots = this.engine.getLiquidContents();
            if (slots == null) {
                return 0;
            }
            return slots[0].capacity;
        }
        return 0;
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(1, 1, 0);
        payload.intPayload[0] = this.isActive ? 1 : 0;
        payload.floatPayload[0] = this.pistonSpeedServer;
        if (this.engine != null) {
            payload.append(this.engine.getPacketPayload());
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        this.isActive = payload.intPayload[0] > 0;
        this.pistonSpeedServer = payload.floatPayload[0];
        if (this.engine == null) {
            this.createEngine();
        }
        this.engine.fromPacketPayload(payload, new IndexInPayload(1, 1, 0));
    }

    @Override
    public boolean acceptsEnergyFrom(qj emitter, Direction direction) {
        if (this.engine != null) {
            return this.engine.acceptsEnergyFrom(emitter, direction);
        }
        return false;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        if (this.engine != null) {
            return this.engine.isAddedToEnergyNet();
        }
        return false;
    }

    @Override
    public boolean demandsEnergy() {
        if (this.engine != null) {
            return this.engine.demandsEnergy();
        }
        return false;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (this.engine != null) {
            return this.engine.injectEnergy(directionFrom, amount);
        }
        return 0;
    }

    @Override
    public LinkedList getCustomTriggers() {
        if (this.engine != null) {
            return this.engine.getCustomTriggers();
        }
        return null;
    }

    @Override
    public int getSocketCount() {
        if (this.engine != null) {
            return this.engine.getSocketCount();
        }
        return 0;
    }

    @Override
    public kp getSocket(int slot) {
        if (this.engine != null) {
            return this.engine.getSocket(slot);
        }
        return null;
    }

    @Override
    public void setSocket(int slot, kp stack) {
        if (this.engine != null) {
            this.engine.setSocket(slot, stack);
        }
    }
}

