/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ICircuit;
import forestry.core.utils.StringUtil;
import java.util.List;

public abstract class Circuit
implements ICircuit {
    public static ICircuit[] circuitList = new ICircuit[64];
    int id;
    int limit = 1;
    boolean requiresDiscovery;
    String name;
    String usage;
    String[] descriptions;
    public static ICircuit energyElectricChoke1;
    public static ICircuit energyFireDampener1;
    public static ICircuit energyElectricEfficiency1;
    public static ICircuit energyElectricBoost1;
    public static ICircuit energyElectricBoost2;

    public Circuit(int id2, boolean requiresDiscovery, String name, String usage, String[] descriptions) {
        this.id = id2;
        this.requiresDiscovery = requiresDiscovery;
        this.name = name;
        this.usage = usage;
        this.descriptions = descriptions;
        if (circuitList[id2] != null) {
            throw new RuntimeException("Circuit slot " + id2 + " was already occupied by " + circuitList[id2].toString() + " when trying to add " + this.toString());
        }
        Circuit.circuitList[id2] = this;
    }

    protected void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean requiresDiscovery() {
        return this.requiresDiscovery;
    }

    @Override
    public String getName() {
        return "circuit." + this.name;
    }

    @Override
    public void addTooltip(List list) {
        list.add("\u00a76" + StringUtil.localize("circuit.usage." + this.usage) + ":");
        for (String description : this.descriptions) {
            list.add(" - " + StringUtil.localize(description));
        }
    }
}

