/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import buildcraft.api.PowerFramework;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ForestryBlock;
import forestry.api.core.GlobalManager;
import forestry.api.core.IPlugin;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.RecipeManagers;
import forestry.core.PickupHandler;
import forestry.core.WorldGenerator;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.config.OreHandler;
import forestry.core.config.Version;
import forestry.core.gadgets.EntityHandler;
import forestry.core.gadgets.GadgetManager;
import forestry.plugins.PluginManager;
import forge.IOreHandler;
import forge.IPickupHandler;
import forge.MinecraftForge;
import forge.NetworkMod;
import forge.oredict.OreDictionary;

public class ForestryCore {
    public static OreHandler oreHandler;
    public static EntityHandler entityHandler;

    public static void load(NetworkMod basemod) {
        ForestryAPI.instance = basemod;
        MinecraftForge.versionDetect((String)"Forestry", (int)3, (int)3, (int)8);
        Version.versionCheck();
        Config.load();
        PluginManager.loadPlugins();
        for (IPlugin plugin : PluginManager.plugins) {
            if (plugin.isAvailable()) {
                plugin.preInit();
                continue;
            }
            ModLoader.getLogger().fine("Skipped plugin " + plugin.getClass() + " because preconditions were not met.");
        }
        oreHandler = new OreHandler();
        FMLCommonHandler.instance().registerWorldGenerator((IWorldGenerator)new WorldGenerator());
        OreDictionary.registerOreHandler((IOreHandler)oreHandler);
        MinecraftForge.registerPickupHandler((IPickupHandler)new PickupHandler());
        entityHandler = new EntityHandler();
        GadgetManager.registerEntityHandler(entityHandler);
        ForestryAPI.registerWrench(new kp(ForestryItem.wrench));
        FuelManager.fermenterFuel.put(ForestryItem.fertilizerCompound.bP, new FermenterFuel(new kp(ForestryItem.fertilizerCompound), 56, 200));
        FuelManager.fermenterFuel.put(ForestryItem.fertilizerBio.bP, new FermenterFuel(new kp(ForestryItem.fertilizerBio), 48, 250));
        FuelManager.fermenterFuel.put(ForestryItem.mulch.bP, new FermenterFuel(new kp(ForestryItem.mulch), 48, 250));
        FuelManager.moistenerResource.put(id.S.bP, new MoistenerFuel(new kp(id.S), new kp(ForestryItem.mouldyWheat), 0, 300));
        FuelManager.moistenerResource.put(ForestryItem.mouldyWheat.bP, new MoistenerFuel(new kp(ForestryItem.mouldyWheat), new kp(ForestryItem.decayingWheat), 1, 600));
        FuelManager.moistenerResource.put(ForestryItem.decayingWheat.bP, new MoistenerFuel(new kp(ForestryItem.decayingWheat), new kp(ForestryItem.mulch), 2, 900));
        FuelManager.copperEngineFuel.put(ForestryItem.peat.bP, new EngineCopperFuel(new kp(ForestryItem.peat), 1, 5000));
        FuelManager.copperEngineFuel.put(ForestryItem.bituminousPeat.bP, new EngineCopperFuel(new kp(ForestryItem.bituminousPeat), 2, 6000));
        FuelManager.bronzeEngineFuel.put(ForestryItem.liquidBiomass.bP, new EngineBronzeFuel(new kp(ForestryItem.liquidBiomass), 5, 10000, 1));
        FuelManager.bronzeEngineFuel.put(vz.B.bO, new EngineBronzeFuel(new kp(vz.B), 1, 1000, 2));
        FuelManager.bronzeEngineFuel.put(ForestryItem.liquidMilk.bP, new EngineBronzeFuel(new kp(ForestryItem.liquidMilk), 1, 40000, 1));
        FuelManager.bronzeEngineFuel.put(id.aF.bP, new EngineBronzeFuel(new kp(id.aF), 1, 40000, 1));
        FuelManager.bronzeEngineFuel.put(ForestryItem.liquidSeedOil.bP, new EngineBronzeFuel(new kp(ForestryItem.liquidSeedOil), 3, 10000, 1));
        FuelManager.bronzeEngineFuel.put(ForestryItem.liquidHoney.bP, new EngineBronzeFuel(new kp(ForestryItem.liquidHoney), 1, 10000, 1));
        FuelManager.bronzeEngineFuel.put(ForestryItem.liquidJuice.bP, new EngineBronzeFuel(new kp(ForestryItem.liquidJuice), 1, 10000, 1));
        FuelManager.rainSubstrate.put(ForestryItem.iodineCharge.bP, new RainSubstrate(new kp(ForestryItem.iodineCharge), 10000, 0.01f));
        FuelManager.rainSubstrate.put(ForestryItem.craftingMaterial.bP, new RainSubstrate(new kp(ForestryItem.craftingMaterial, 1, 4), 0.02f));
        GlobalManager.holyBlockIds.add(ForestryBlock.soil.bO);
        GlobalManager.holyBlockIds.add(ForestryBlock.planter.bO);
        GlobalManager.holyBlockIds.add(ForestryBlock.harvester.bO);
        GlobalManager.holyBlockIds.add(ForestryBlock.engine.bO);
        GlobalManager.holyBlockIds.add(ForestryBlock.machine.bO);
        GlobalManager.holyBlockIds.add(ForestryBlock.mill.bO);
        GlobalManager.holyBlockIds.add(vz.aQ.bO);
        GlobalManager.holyBlockIds.add(vz.aP.bO);
        GlobalManager.holyBlockIds.add(vz.al.bO);
        GlobalManager.holyBlockIds.add(vz.bm.bO);
        GlobalManager.holyBlockIds.add(vz.aJ.bO);
        GlobalManager.holyBlockIds.add(vz.z.bO);
        GlobalManager.holyBlockIds.add(vz.au.bO);
        GlobalManager.holyBlockIds.add(vz.w.bO);
        GlobalManager.holyBlockIds.add(vz.ao.bO);
        GlobalManager.holyBlockIds.add(vz.bA.bO);
        GlobalManager.holyBlockIds.add(vz.aq.bO);
        GlobalManager.holyBlockIds.add(vz.x.bO);
        GlobalManager.holyBlockIds.add(vz.by.bO);
        FlowerManager.plainFlowers.add(new kp((vz)vz.ae));
        FlowerManager.plainFlowers.add(new kp((vz)vz.ad));
    }

    public static void modsLoaded() {
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.doInit();
        }
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidMilk, 1000), new kp(id.aF), new kp(id.av), true));
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(vz.D, 1000), new kp(id.ax), new kp(id.av), true));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(vz.D, 1000), new kp(ForestryItem.canLava), new kp(ForestryItem.canEmpty), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(vz.D, 1000), new kp(ForestryItem.refractoryLava), new kp(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(vz.B, 1000), new kp((id)id.br, 1, 0), new kp(id.bs), true));
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(vz.B, 1000), new kp(id.aw), new kp(id.av), true));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(vz.B, 1000), new kp(ForestryItem.canWater), new kp(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(vz.B, 1000), new kp(ForestryItem.waxCapsuleWater), new kp(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(vz.B, 1000), new kp(ForestryItem.refractoryWater), new kp(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiomass, 1000), new kp(ForestryItem.bucketBiomass), new kp(id.av), true));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiomass, 1000), new kp(ForestryItem.canBiomass), new kp(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiomass, 1000), new kp(ForestryItem.waxCapsuleBiomass), new kp(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiomass, 1000), new kp(ForestryItem.refractoryBiomass), new kp(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiofuel, 1000), new kp(ForestryItem.bucketBiofuel), new kp(id.av), true));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiofuel, 1000), new kp(ForestryItem.canBiofuel), new kp(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiofuel, 1000), new kp(ForestryItem.waxCapsuleBiofuel), new kp(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiofuel, 1000), new kp(ForestryItem.refractoryBiofuel), new kp(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidSeedOil, 1000), new kp(ForestryItem.canSeedOil), new kp(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidSeedOil, 1000), new kp(ForestryItem.waxCapsuleSeedOil), new kp(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidSeedOil, 1000), new kp(ForestryItem.refractorySeedOil), new kp(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidHoney, 1000), new kp(ForestryItem.canHoney), new kp(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidHoney, 1000), new kp(ForestryItem.waxCapsuleHoney), new kp(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidHoney, 1000), new kp(ForestryItem.refractoryHoney), new kp(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidJuice, 1000), new kp(ForestryItem.canJuice), new kp(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidJuice, 1000), new kp(ForestryItem.waxCapsuleJuice), new kp(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidJuice, 1000), new kp(ForestryItem.refractoryJuice), new kp(ForestryItem.refractoryEmpty), false));
        Config.modsLoaded();
        ModLoader.getLogger().fine("Using " + PowerFramework.currentFramework.getClass().getName() + " as framework.");
        oreHandler.initApatiteOre();
        oreHandler.initOreBlocks();
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.postInit();
        }
        GadgetManager.registerAllPackageNames();
        Config.saveToFile();
    }

    public static int addFuel(int i, int j) {
        if (i == ForestryItem.peat.bP) {
            return 1600;
        }
        return 0;
    }

    public static void takenFromCrafting(ih player, kp itemstack, ni inventory) {
    }

    public static String getPriorities() {
        return "after:mod_IC2;after:mod_BuildCraftCore;after:mod_BuildCraftEnergy;after:mod_BuildCraftFactory;after:mod_BuildCraftSilicon;after:mod_BuildCraftTransport;after:mod_RedPowerWorld";
    }

    public static void injectLiquidContainer(LiquidContainer container) {
        ForestryCore.injectLiquidContainer(container, null, 0);
    }

    public static void injectWaxContainer(LiquidContainer container) {
        ForestryCore.injectLiquidContainer(container, new kp(ForestryItem.beeswax), 10);
    }

    public static void injectRefractoryContainer(LiquidContainer container) {
        ForestryCore.injectLiquidContainer(container, new kp(ForestryItem.refractoryWax), 10);
    }

    public static void injectTinContainer(LiquidContainer container) {
        ForestryCore.injectLiquidContainer(container, ForestryItem.ingotTin, 5);
    }

    public static void injectLiquidContainer(LiquidContainer container, kp remnant, int chance) {
        LiquidManager.registerLiquidContainer(container);
        if (RecipeManagers.squeezerManager != null && !container.isBucket) {
            if (remnant != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new kp[]{container.filled}, container.liquid, remnant, chance);
            } else {
                RecipeManagers.squeezerManager.addRecipe(10, new kp[]{container.filled}, container.liquid);
            }
        }
        if (RecipeManagers.bottlerManager != null) {
            RecipeManagers.bottlerManager.addRecipe(5, container.liquid, container.empty, container.filled);
        }
    }
}

