/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.core.EnumBreedingMode;
import forestry.core.config.Config;
import java.util.ArrayList;

public class Mutation
implements IMutation {
    private int chance;
    boolean requiresDay = false;
    boolean requiresNight = false;
    boolean isSecret = false;
    IAllele allele0;
    IAllele allele1;
    IAllele[] template;
    ArrayList restrictBiomes = new ArrayList();
    private float minTemperature = 0.0f;
    private float maxTemperature = 2.0f;
    private float minRainfall = 0.0f;
    private float maxRainfall = 2.0f;

    public Mutation(IAllele allele0, IAllele allele1, IAllele[] template, int chance) {
        this.allele0 = allele0;
        this.allele1 = allele1;
        this.template = template;
        this.chance = chance;
        BeeManager.beeMutations.add(this);
    }

    public Mutation restrictBiome(int biomeid) {
        this.restrictBiomes.add(biomeid);
        return this;
    }

    public Mutation setTemperature(float minTemperature, float maxTemperature) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
        return this;
    }

    public Mutation setRainfall(float minRainfall, float maxRainfall) {
        this.minRainfall = minRainfall;
        this.maxRainfall = maxRainfall;
        return this;
    }

    public Mutation setTemperatureRainfall(float minTemperature, float maxTemperature, float minRainfall, float maxRainfall) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
        this.minRainfall = minRainfall;
        this.maxRainfall = maxRainfall;
        return this;
    }

    public Mutation setIsSecret() {
        this.isSecret = true;
        return this;
    }

    public Mutation requireDay() {
        this.requiresDay = true;
        this.requiresNight = false;
        return this;
    }

    public Mutation requireNight() {
        this.requiresDay = false;
        this.requiresNight = true;
        return this;
    }

    @Override
    public IAllele getAllele0() {
        return this.allele0;
    }

    @Override
    public IAllele getAllele1() {
        return this.allele1;
    }

    @Override
    public int getChance(ge world, int biomeid, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        if (this.requiresDay && !world.e()) {
            return 0;
        }
        if (this.requiresNight && world.e()) {
            return 0;
        }
        if (this.restrictBiomes.size() > 0 && !this.restrictBiomes.contains(biomeid)) {
            return 0;
        }
        lt biome = world.a().a(x, z);
        if (biome.F < this.minTemperature || biome.F > this.maxTemperature) {
            return 0;
        }
        if (biome.G < this.minRainfall || biome.G > this.maxRainfall) {
            return 0;
        }
        int processedChance = this.chance;
        if (Config.beeBreedingMode == EnumBreedingMode.HARDCORE) {
            processedChance = Math.round(this.chance / 2);
        } else if (Config.beeBreedingMode == EnumBreedingMode.EASY) {
            processedChance *= 2;
        } else if (Config.beeBreedingMode == EnumBreedingMode.FTB) {
            processedChance = 100;
        }
        if (this.allele0.getId() == allele0.getId() && this.allele1.getId() == allele1.getId()) {
            return processedChance;
        }
        if (this.allele1.getId() == allele0.getId() && this.allele0.getId() == allele1.getId()) {
            return processedChance;
        }
        return 0;
    }

    @Override
    public int getBaseChance() {
        return this.chance;
    }

    @Override
    public IAllele[] getTemplate() {
        return this.template;
    }

    @Override
    public boolean isPartner(IAllele allele) {
        return this.allele0.getId() == allele.getId() || this.allele1.getId() == allele.getId();
    }

    @Override
    public IAllele getPartner(IAllele allele) {
        if (this.allele0.getId() == allele.getId()) {
            return this.allele1;
        }
        return this.allele0;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }
}

