/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.ItemArmorApiarist;
import forestry.apiculture.ProxyApiculture;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.core.utils.Vect;
import java.util.List;

public class AlleleEffectMiasmic
extends AlleleEffectThrottled {
    private int infectionChance = 50;

    public AlleleEffectMiasmic(int id2) {
        super(id2, false);
    }

    @Override
    public int getThrottle() {
        return 50;
    }

    @Override
    public boolean isCombinable() {
        return false;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, ge world, int biomeid, int x, int y, int z) {
        if (this.isThrottled(storedData)) {
            return storedData;
        }
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        Vect min = new Vect(x + offset.x, y + offset.y, z + offset.z);
        Vect max = new Vect(x + offset.x + area.x, y + offset.y + area.y, z + offset.z + area.z);
        fp infectionBox = fp.b((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = world.a(ih.class, infectionBox);
        for (Object obj : list) {
            if (world.r.nextInt(1000) >= this.infectionChance) continue;
            ih player = (ih)obj;
            int duration = 800;
            int count = ItemArmorApiarist.wearsItems(player);
            if (count > 3) continue;
            if (count > 2) {
                duration = 200;
            } else if (count > 1) {
                duration = 400;
            } else if (count > 0) {
                duration = 600;
            }
            player.e(new zv(kf.u.H, duration, 0));
        }
        return storedData;
    }

    @Override
    public String getIdentifier() {
        return "apiculture.effect.misasmic";
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, ge world, int biomeid, int x, int y, int z) {
        if (world.r.nextBoolean()) {
            ProxyApiculture.addBeeHiveFX("/gfx/forestry/particles/swarm_bee.png", world, x, y, z, genome.getPrimaryAsBee().getPrimaryColor());
        } else {
            ProxyApiculture.addBeeHiveFX("/gfx/forestry/particles/poison.png", world, x, y, z, 0xFFFFFF);
        }
        return storedData;
    }
}

