/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.ItemArmorApiarist;
import forestry.apiculture.ProxyApiculture;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.core.utils.Vect;
import java.util.List;

public class AlleleEffectIgnition
extends AlleleEffectThrottled {
    int ignitionChance = 50;
    int fireDuration = 500;

    public AlleleEffectIgnition(int id2) {
        super(id2, false);
    }

    @Override
    public int getThrottle() {
        return 20;
    }

    @Override
    public boolean isCombinable() {
        return true;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, ge world, int biomeid, int x, int y, int z) {
        if (this.isThrottled(storedData)) {
            return storedData;
        }
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        Vect min = new Vect(x + offset.x, y + offset.y, z + offset.z);
        Vect max = new Vect(x + offset.x + area.x, y + offset.y + area.y, z + offset.z + area.z);
        fp hurtBox = fp.b((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = world.a(ne.class, hurtBox);
        for (Object obj : list) {
            ne entity = (ne)obj;
            int chance = this.ignitionChance;
            int duration = this.fireDuration;
            if (entity instanceof ih) {
                int count = ItemArmorApiarist.wearsItems((ih)entity);
                if (count > 3) continue;
                if (count > 2) {
                    chance = 5;
                    duration = 50;
                } else if (count > 1) {
                    chance = 20;
                    duration = 200;
                } else if (count > 0) {
                    chance = 35;
                    duration = 350;
                }
            }
            if (world.r.nextInt(1000) >= chance) continue;
            entity.i(duration);
        }
        return storedData;
    }

    @Override
    public String getIdentifier() {
        return "apiculture.effect.ignition";
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, ge world, int biomeid, int x, int y, int z) {
        if (world.r.nextBoolean()) {
            ProxyApiculture.addBeeHiveFX("/gfx/forestry/particles/swarm_bee.png", world, x, y, z, genome.getPrimaryAsBee().getPrimaryColor());
        } else {
            ProxyApiculture.addBeeHiveFX("/gfx/forestry/particles/ember.png", world, x, y, z, 0xFFFFFF);
        }
        return storedData;
    }
}

