/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.IApiaristTracker;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.ItemBee;
import forestry.core.EnumErrorCode;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.GuiId;
import forestry.core.network.NetProxy;
import forestry.core.network.PacketInventoryStack;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.Orientations;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import java.util.LinkedList;
import java.util.Stack;

public class MachineApiary
extends Machine {
    public static final int SLOT_QUEEN = 0;
    private kp[] inventoryStacks = new kp[11];
    private int droneSlot = 1;
    private int productSlot1 = 2;
    private int productSlots = 7;
    private int breedingTime;
    private int totalBreedingTime = 100;
    private Stack spawn = new Stack();
    private int throttle;
    private IEffectData[] effectData = new IEffectData[2];
    private int biomeId;
    private float temperature;
    private float humidity;
    protected boolean isAlveary = false;

    public MachineApiary(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("apiary"));
        if (tile.k != null) {
            lt biome = tile.k.a(tile.l, tile.n);
            this.biomeId = biome.M;
            this.temperature = biome.F;
            this.humidity = biome.G;
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.7");
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.ApiaryGUI.ordinal(), this.tile.k, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("BreedingTime", this.breedingTime);
        nbttagcompound.a("TotalTime", this.totalBreedingTime);
        nbttagcompound.a("Throttle", this.throttle);
        nbttagcompound.a("Temp", this.temperature);
        nbttagcompound.a("Humidity", this.humidity);
        nbttagcompound.a("BiomeId", this.biomeId);
        new ph();
        tx nbttaglist = new tx();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Items", (jz)nbttaglist);
        nbttaglist = new tx();
        kp[] offspring = this.spawn.toArray(new kp[this.spawn.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            offspring[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Offspring", (jz)nbttaglist);
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        ph nbttagcompound1;
        int i;
        super.readFromNBT(nbttagcompound);
        this.breedingTime = nbttagcompound.f("BreedingTime");
        this.totalBreedingTime = nbttagcompound.f("TotalTime");
        this.throttle = nbttagcompound.f("Throttle");
        this.temperature = nbttagcompound.h("Temp");
        this.humidity = nbttagcompound.h("Humidity");
        this.biomeId = nbttagcompound.f("BiomeId");
        tx nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new kp[this.c()];
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ph)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = kp.a((ph)nbttagcompound1);
        }
        nbttaglist = nbttagcompound.n("Offspring");
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ph)nbttaglist.a(i);
            this.spawn.add(kp.a((ph)nbttagcompound1));
        }
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public float getHumidity() {
        return this.humidity;
    }

    @Override
    public void updateClientSide() {
        if (BeeManager.beeInterface.isMated(this.inventoryStacks[0]) && this.getErrorState() == EnumErrorCode.OK && this.throttle % 2 % 2 == 0) {
            IBee displayQueen = BeeManager.beeInterface.getBee(this.inventoryStacks[0]);
            displayQueen.doFX(this.effectData, this.tile.k, this.biomeId, this.tile.l, this.tile.m, this.tile.n);
        }
    }

    @Override
    public void updateServerSide() {
        kp[] products;
        if (!this.spawn.isEmpty()) {
            kp next = (kp)this.spawn.peek();
            if (this.addProduct(next, true)) {
                this.spawn.pop();
                this.setErrorState(EnumErrorCode.OK);
            } else {
                this.setErrorState(EnumErrorCode.NOSPACE);
            }
            return;
        }
        if (this.inventoryStacks[0] != null && (this.inventoryStacks[0].c == ForestryItem.beeQueen.bP || this.inventoryStacks[0].c == ForestryItem.beePrincess.bP || this.inventoryStacks[0].c == ForestryItem.beeDrone.bP)) {
            this.legacyConversion(this.inventoryStacks[0]);
            if (this.inventoryStacks[0].a <= 0) {
                this.inventoryStacks[0] = null;
            }
            return;
        }
        if (this.inventoryStacks[this.droneSlot] != null && (this.inventoryStacks[this.droneSlot].c == ForestryItem.beeQueen.bP || this.inventoryStacks[this.droneSlot].c == ForestryItem.beePrincess.bP || this.inventoryStacks[this.droneSlot].c == ForestryItem.beeDrone.bP)) {
            this.legacyConversion(this.inventoryStacks[this.droneSlot]);
            if (this.inventoryStacks[this.droneSlot].a <= 0) {
                this.inventoryStacks[this.droneSlot] = null;
            }
            return;
        }
        if (this.inventoryStacks[0] == null) {
            this.setErrorState(EnumErrorCode.NOQUEEN);
            return;
        }
        if (this.inventoryStacks[0].c == ForestryItem.beePrincessGE.bP) {
            if (this.inventoryStacks[this.droneSlot] == null || this.inventoryStacks[this.droneSlot].c != ForestryItem.beeDroneGE.bP) {
                this.setErrorState(EnumErrorCode.NODRONE);
            } else {
                this.setErrorState(EnumErrorCode.OK);
            }
            this.tickBreed();
            return;
        }
        if (this.inventoryStacks[0].c != ForestryItem.beeQueenGE.bP) {
            this.setErrorState(EnumErrorCode.NOQUEEN);
            return;
        }
        IBee queen = BeeManager.beeInterface.getBee(this.inventoryStacks[0]);
        if (!queen.isAlive()) {
            this.killQueen(queen);
            this.setErrorState(EnumErrorCode.OK);
            return;
        }
        EnumErrorCode state = EnumErrorCode.values()[queen.isWorking(this.tile.k, this.isAlveary, this.biomeId, this.temperature, this.humidity, this.tile.l, this.tile.m, this.tile.n)];
        if (state != EnumErrorCode.OK) {
            this.setErrorState(state);
            return;
        }
        if (this.getErrorState() != EnumErrorCode.NOFLOWER) {
            this.setErrorState(EnumErrorCode.OK);
        }
        this.effectData = queen.doEffect(this.effectData, this.tile.k, this.biomeId, this.tile.l, this.tile.m, this.tile.n);
        ++this.throttle;
        if (this.tile.k.o() % 200L * 10L == 0L) {
            this.synchQueen(this.inventoryStacks[0]);
        }
        if (this.getErrorState() == EnumErrorCode.OK && this.throttle % 2 % 2 == 0) {
            queen.doFX(this.effectData, this.tile.k, this.biomeId, this.tile.l, this.tile.m, this.tile.n);
        }
        if (this.throttle == 100 || this.throttle == 200 || this.throttle == 300 || this.throttle == 400 || this.throttle == 500) {
            float f = (float)this.tile.l + 0.5f;
            float f1 = (float)this.tile.m + 0.0f + this.tile.k.r.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.tile.n + 0.5f;
            float f3 = 0.52f;
            float f4 = this.tile.k.r.nextFloat() * 0.6f - 0.3f;
            Proxy.addEntitySwarmFX(this.tile.k, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxy.addEntitySwarmFX(this.tile.k, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxy.addEntitySwarmFX(this.tile.k, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
            Proxy.addEntitySwarmFX(this.tile.k, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        }
        if (this.throttle < Config.beeCycleTicks) {
            return;
        }
        this.throttle = 0;
        if (!queen.hasFlower(this.tile.k, this.biomeId, this.tile.l, this.tile.m, this.tile.n)) {
            this.setErrorState(EnumErrorCode.NOFLOWER);
            return;
        }
        this.setErrorState(EnumErrorCode.OK);
        for (kp stack : products = queen.produceStacks(this.tile.k, this.biomeId, this.tile.l, this.tile.m, this.tile.n)) {
            this.addProduct(stack, false);
        }
        queen.plantFlowerRandom(this.tile.k, this.biomeId, this.tile.l, this.tile.m, this.tile.n);
        queen.age();
        ph nbttagcompound = new ph();
        queen.b(nbttagcompound);
        this.inventoryStacks[0].d(nbttagcompound);
    }

    private void legacyConversion(kp stack) {
        kp newBee = ItemBee.toBeeGE(stack);
        this.spawn.add(newBee);
        --stack.a;
    }

    private void tickBreed() {
        if (!this.tryBreed()) {
            this.breedingTime = 0;
            return;
        }
        if (this.breedingTime < this.totalBreedingTime) {
            ++this.breedingTime;
        }
        if (this.breedingTime < this.totalBreedingTime) {
            return;
        }
        if (this.inventoryStacks[0] == null || this.inventoryStacks[0].c != ForestryItem.beePrincessGE.bP) {
            return;
        }
        IBee princess = BeeManager.beeInterface.getBee(this.inventoryStacks[0]);
        IBee drone = BeeManager.beeInterface.getBee(this.inventoryStacks[this.droneSlot]);
        princess.mate(drone);
        ph nbttagcompound = new ph();
        princess.b(nbttagcompound);
        kp queen = new kp(ForestryItem.beeQueenGE, 1, princess.getMeta());
        queen.d(nbttagcompound);
        this.inventoryStacks[0] = queen;
        this.synchQueen(this.inventoryStacks[0]);
        BeeManager.breedingManager.getApiaristTracker(this.tile.k).registerQueen(this.tile.getOwnerEntity(), princess);
        --this.inventoryStacks[this.droneSlot].a;
        if (this.inventoryStacks[this.droneSlot].a <= 0) {
            this.inventoryStacks[this.droneSlot] = null;
        }
        this.breedingTime = 0;
    }

    private boolean tryBreed() {
        if (this.inventoryStacks[this.droneSlot] == null || this.inventoryStacks[0] == null) {
            return false;
        }
        return this.inventoryStacks[this.droneSlot].c == ForestryItem.beeDroneGE.bP && this.inventoryStacks[0].c == ForestryItem.beePrincessGE.bP;
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.getErrorState() == EnumErrorCode.OK;
    }

    private boolean addProduct(kp product, boolean all) {
        for (int i = this.productSlot1; i < this.productSlot1 + this.productSlots; ++i) {
            int space;
            if (this.inventoryStacks[i] == null) {
                this.inventoryStacks[i] = product;
                return true;
            }
            if (!this.inventoryStacks[i].a(product) || (space = this.inventoryStacks[i].b() - this.inventoryStacks[i].a) <= 0) continue;
            if (space >= product.a) {
                this.inventoryStacks[i].a += product.a;
                product.a = 0;
                return true;
            }
            if (all) continue;
            this.inventoryStacks[i].a = this.inventoryStacks[i].b();
            product.a -= space;
            return true;
        }
        return false;
    }

    private void killQueen(IBee queen) {
        if (queen.canSpawn()) {
            this.spawnOffspring(queen);
            this.inventoryStacks[0].a = 0;
            this.inventoryStacks[0] = null;
        } else {
            ModLoader.getLogger().warning("Tried to spawn offspring off an unmated queen. Devolving her to a princess.");
            kp convert = new kp(ForestryItem.beePrincessGE, 1, queen.getMeta());
            ph nbttagcompound = new ph();
            queen.b(nbttagcompound);
            convert.d(nbttagcompound);
            this.spawn.add(convert);
            this.inventoryStacks[0] = null;
        }
        this.synchQueen(this.inventoryStacks[0]);
    }

    private void spawnOffspring(IBee queen) {
        IBee[] larvae;
        Stack<kp> offspring = new Stack<kp>();
        IApiaristTracker breedingTracker = BeeManager.breedingManager.getApiaristTracker(this.tile.k);
        IBee heiress = queen.spawnPrincess(this.tile.k, this.biomeId, this.tile.l, this.tile.m, this.tile.n);
        ph nbttagcompound = new ph();
        kp princess = new kp(ForestryItem.beePrincessGE, 1, heiress.getMeta());
        heiress.b(nbttagcompound);
        princess.d(nbttagcompound);
        breedingTracker.registerPrincess(this.tile.getOwnerEntity(), heiress);
        offspring.push(princess);
        for (IBee larva : larvae = queen.spawnDrones(this.tile.k, this.biomeId, this.tile.l, this.tile.m, this.tile.n)) {
            nbttagcompound = new ph();
            kp drone = new kp(ForestryItem.beeDroneGE, 1, larva.getMeta());
            larva.b(nbttagcompound);
            drone.d(nbttagcompound);
            breedingTracker.registerDrone(this.tile.getOwnerEntity(), larva);
            offspring.push(drone);
        }
        while (!offspring.isEmpty()) {
            kp spawned = (kp)offspring.pop();
            if (this.addProduct(spawned, true)) continue;
            this.spawn.add(spawned);
        }
    }

    private void synchQueen(kp queenStack) {
        if (Proxy.isClient()) {
            return;
        }
        NetProxy.sendNetworkPacket(new PacketInventoryStack(2, this.tile.l, this.tile.m, this.tile.n, 0, queenStack), this.tile.l, this.tile.m, this.tile.n);
    }

    private int getHealthDisplay() {
        if (this.inventoryStacks[0] == null) {
            return 0;
        }
        if (this.inventoryStacks[0].c == ForestryItem.beeQueenGE.bP) {
            return BeeManager.beeInterface.getBee(this.inventoryStacks[0]).getHealth();
        }
        if (this.inventoryStacks[0].c == ForestryItem.beePrincessGE.bP) {
            return this.breedingTime;
        }
        return 0;
    }

    private int getMaxHealthDisplay() {
        if (this.inventoryStacks[0] == null) {
            return 0;
        }
        if (this.inventoryStacks[0].c == ForestryItem.beeQueenGE.bP) {
            return BeeManager.beeInterface.getBee(this.inventoryStacks[0]).getMaxHealth();
        }
        if (this.inventoryStacks[0].c == ForestryItem.beePrincessGE.bP) {
            return this.totalBreedingTime;
        }
        return 0;
    }

    public int getHealthScaled(int i) {
        if (this.getMaxHealthDisplay() == 0) {
            return 0;
        }
        return this.getHealthDisplay() * i / this.getMaxHealthDisplay();
    }

    public int getTemperatureScaled(int i) {
        return Math.round((float)i * (this.temperature / 2.0f));
    }

    public int getHumidityScaled(int i) {
        return Math.round((float)i * this.humidity);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.breedingTime = j;
                break;
            }
            case 1: {
                this.totalBreedingTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
        iCrafting.a(container, 0, this.breedingTime);
        iCrafting.a(container, 1, this.totalBreedingTime);
    }

    @Override
    public int c() {
        return this.inventoryStacks.length;
    }

    @Override
    public kp g_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public kp a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            kp product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        kp product = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    @Override
    public void a(int i, kp itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.a()) {
            itemstack.a = this.a();
        }
    }

    @Override
    public kp b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        kp toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return this.droneSlot;
        }
        if (side == 1) {
            return 0;
        }
        return this.productSlot1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0) {
            return 1;
        }
        if (side == 1) {
            return 1;
        }
        return 9;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        kp product = null;
        for (int i = this.productSlot1; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            if (this.inventoryStacks[i].c == ForestryItem.beePrincessGE.bP) {
                if (Config.apiarySideSensitive && from != Orientations.YPos) continue;
                product = this.inventoryStacks[i].j();
                if (!doRemove) break;
                this.inventoryStacks[i].a = 0;
                this.inventoryStacks[i] = null;
                break;
            }
            if (this.inventoryStacks[i].c == ForestryItem.beeDroneGE.bP) {
                if (Config.apiarySideSensitive && from != Orientations.YNeg) continue;
                product = this.inventoryStacks[i].j();
                if (!doRemove) break;
                --this.inventoryStacks[i].a;
                if (this.inventoryStacks[i].a > 0) break;
                this.inventoryStacks[i] = null;
                break;
            }
            if (Config.apiarySideSensitive && (from == Orientations.YPos || from == Orientations.YNeg)) continue;
            product = StackUtils.createSplitStack(this.inventoryStacks[i], 1);
            if (!doRemove) break;
            --this.inventoryStacks[i].a;
            if (this.inventoryStacks[i].a > 0) break;
            this.inventoryStacks[i] = null;
            break;
        }
        return product;
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        if ((stack.c == ForestryItem.beePrincessGE.bP || stack.c == ForestryItem.beeQueenGE.bP) && this.inventoryStacks[0] == null) {
            if (doAdd) {
                this.inventoryStacks[0] = stack.j();
                stack.a = 0;
            }
            return true;
        }
        if (stack.c == ForestryItem.beeDroneGE.bP && this.inventoryStacks[this.droneSlot] == null) {
            if (doAdd) {
                this.inventoryStacks[this.droneSlot] = stack.j();
                stack.a = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.missingQueen);
        res.add(ForestryTrigger.missingDrone);
        return res;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachineApiary((TileMachine)tile);
        }
    }
}

