/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.core.ForestryBlock;
import forestry.apiculture.MachineApiary;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.utils.DelayTimer;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Vect;

public class MachineAlveary
extends MachineApiary {
    DelayTimer alvearyValidationTimer = new DelayTimer();
    private Machine temperatureController = null;
    private Machine humidityController = null;
    private Machine swarmController = null;

    public MachineAlveary(TileMachine tile) {
        super(tile);
    }

    @Override
    public String getName() {
        return StringUtil.localize("apiculture.machine.alveary");
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.alvearyValidationTimer.delayPassed(this.tile.k, 80L)) {
            this.validateAlveary();
        }
    }

    private void validateAlveary() {
        Vect[] targets;
        if (this.tile.k.g(this.tile.l + 1, this.tile.m, this.tile.n) && this.isValidAlvearyBlock(this.tile.l + 1, this.tile.m, this.tile.n + 1) && this.isValidAlvearyBlock(this.tile.l + 1, this.tile.m, this.tile.n - 1) && this.validateCoordinates(targets = new Vect[]{new Vect(this.tile.l, this.tile.m, this.tile.n), new Vect(this.tile.l, this.tile.m, this.tile.n + 1), new Vect(this.tile.l, this.tile.m, this.tile.n - 1), new Vect(this.tile.l + 1, this.tile.m, this.tile.n + 1), new Vect(this.tile.l + 1, this.tile.m, this.tile.n - 1), new Vect(this.tile.l + 2, this.tile.m, this.tile.n), new Vect(this.tile.l + 2, this.tile.m, this.tile.n + 1), new Vect(this.tile.l + 2, this.tile.m, this.tile.n - 1)})) {
            this.setIsAlveary(targets);
            return;
        }
        if (this.tile.k.g(this.tile.l - 1, this.tile.m, this.tile.n) && this.isValidAlvearyBlock(this.tile.l - 1, this.tile.m, this.tile.n + 1) && this.isValidAlvearyBlock(this.tile.l - 1, this.tile.m, this.tile.n - 1) && this.validateCoordinates(targets = new Vect[]{new Vect(this.tile.l, this.tile.m, this.tile.n), new Vect(this.tile.l, this.tile.m, this.tile.n + 1), new Vect(this.tile.l, this.tile.m, this.tile.n - 1), new Vect(this.tile.l - 1, this.tile.m, this.tile.n + 1), new Vect(this.tile.l - 1, this.tile.m, this.tile.n - 1), new Vect(this.tile.l - 2, this.tile.m, this.tile.n), new Vect(this.tile.l - 2, this.tile.m, this.tile.n + 1), new Vect(this.tile.l - 2, this.tile.m, this.tile.n - 1)})) {
            this.setIsAlveary(targets);
            return;
        }
        if (this.tile.k.g(this.tile.l, this.tile.m, this.tile.n + 1) && this.isValidAlvearyBlock(this.tile.l + 1, this.tile.m, this.tile.n + 1) && this.isValidAlvearyBlock(this.tile.l - 1, this.tile.m, this.tile.n + 1) && this.validateCoordinates(targets = new Vect[]{new Vect(this.tile.l, this.tile.m, this.tile.n), new Vect(this.tile.l + 1, this.tile.m, this.tile.n), new Vect(this.tile.l - 1, this.tile.m, this.tile.n), new Vect(this.tile.l + 1, this.tile.m, this.tile.n + 1), new Vect(this.tile.l - 1, this.tile.m, this.tile.n + 1), new Vect(this.tile.l, this.tile.m, this.tile.n + 2), new Vect(this.tile.l + 1, this.tile.m, this.tile.n + 2), new Vect(this.tile.l - 1, this.tile.m, this.tile.n + 2)})) {
            this.setIsAlveary(targets);
            return;
        }
        if (this.tile.k.g(this.tile.l, this.tile.m, this.tile.n - 1) && this.isValidAlvearyBlock(this.tile.l + 1, this.tile.m, this.tile.n - 1) && this.isValidAlvearyBlock(this.tile.l - 1, this.tile.m, this.tile.n - 1) && this.validateCoordinates(targets = new Vect[]{new Vect(this.tile.l, this.tile.m, this.tile.n), new Vect(this.tile.l + 1, this.tile.m, this.tile.n), new Vect(this.tile.l - 1, this.tile.m, this.tile.n), new Vect(this.tile.l + 1, this.tile.m, this.tile.n - 1), new Vect(this.tile.l - 1, this.tile.m, this.tile.n - 1), new Vect(this.tile.l, this.tile.m, this.tile.n - 2), new Vect(this.tile.l + 1, this.tile.m, this.tile.n - 2), new Vect(this.tile.l - 1, this.tile.m, this.tile.n - 2)})) {
            this.setIsAlveary(targets);
            return;
        }
        this.invalidateAlveary();
    }

    private void setIsAlveary(Vect[] blocks) {
        this.isAlveary = true;
        if (this.temperatureController != null && this.humidityController != null && this.swarmController != null) {
            return;
        }
        if (this.temperatureController == null) {
            // empty if block
        }
        if (this.humidityController == null) {
            // empty if block
        }
        if (this.swarmController == null) {
            // empty if block
        }
    }

    private void invalidateAlveary() {
        if (!this.isAlveary) {
            return;
        }
        this.isAlveary = false;
        this.temperatureController = null;
        this.humidityController = null;
        this.swarmController = null;
    }

    private boolean validateCoordinates(Vect[] targets) {
        for (Vect vect : targets) {
            if (!this.isValidAlvearyBlock(vect.x, vect.y, vect.z)) {
                return false;
            }
            if (!this.isValidAlvearyBlock(vect.x, vect.y - 1, vect.z) && !this.isValidAlvearyBlock(vect.x, vect.y + 2, vect.z)) {
                return false;
            }
            if (this.isValidAlvearyBlock(vect.x, vect.y + 1, vect.z)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidAlvearyBlock(int x, int y, int z) {
        int meta;
        int id2 = this.tile.k.a(x, y, z);
        return id2 == ForestryBlock.beehives.bO ? (meta = this.tile.k.c(x, y, z)) == 7 : id2 == ForestryBlock.machine.bO && (meta = this.tile.k.c(x, y, z)) == 10;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachineAlveary((TileMachine)tile);
        }
    }
}

