/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.IBee;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.apiculture.genetics.EnumBeeType;
import forestry.core.genetics.ItemGE;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ItemBeeGE
extends ItemGE {
    EnumBeeType type;

    public ItemBeeGE(int i, EnumBeeType type) {
        super(i);
        this.bQ = 1;
        this.type = type;
        this.setTextureFile("/gfx/forestry/items/bees.png");
    }

    @Override
    public boolean hasEffect(kp itemstack) {
        Bee individual = new Bee(itemstack.o());
        return individual.hasEffect();
    }

    @Override
    public String getItemDisplayName(kp itemstack) {
        Bee individual = new Bee(itemstack.o());
        return individual.getDisplayName() + StringUtil.localize(this.type.getName() + ".adj.add") + " " + StringUtil.localize(this.type.getName());
    }

    public void addCreativeItems(ArrayList itemList) {
        if (this.type == EnumBeeType.QUEEN) {
            return;
        }
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(ArrayList itemList, boolean hideSecrets) {
        for (IBee individual : BeeTemplates.beeTemplates) {
            if (hideSecrets && individual.isSecret()) continue;
            ph nbttagcompound = new ph();
            kp someStack = new kp((id)this, 1, individual.getMeta());
            individual.b(nbttagcompound);
            someStack.d(nbttagcompound);
            itemList.add(someStack);
        }
    }

    @Override
    public void addInformation(kp itemstack, List list) {
        Bee individual = new Bee(itemstack.o());
        individual.addTooltip(list);
    }

    @Override
    public int getIconFromDamageForRenderPass(int i, int j) {
        IAlleleSpecies species = (IAlleleSpecies)AlleleManager.alleleList[Integer.valueOf(i)];
        if (species == null) {
            return 3 + this.type.ordinal();
        }
        if (j > 0) {
            if (species.getSecondaryColor() == 0xFFFFFF) {
                return 3 + this.type.ordinal();
            }
            if (species.getSecondaryColor() == 3092213) {
                return this.type.ordinal();
            }
            if (species.getSecondaryColor() == 10832103) {
                return 16 + this.type.ordinal();
            }
            if (species.getSecondaryColor() == 3987287) {
                return 32 + this.type.ordinal();
            }
            if (species.getSecondaryColor() == 0xDE4D4D) {
                return 48 + this.type.ordinal();
            }
            if (species.getSecondaryColor() == 15965244) {
                return 64 + this.type.ordinal();
            }
            if (species.getSecondaryColor() == 431972) {
                return 80 + this.type.ordinal();
            }
            if (species.getSecondaryColor() == 10101539) {
                return 96 + this.type.ordinal();
            }
            if (species.getSecondaryColor() == 0x999999) {
                return 112 + this.type.ordinal();
            }
            if (species.getSecondaryColor() == 2494249) {
                return 128 + this.type.ordinal();
            }
            return 3 + this.type.ordinal();
        }
        return 19;
    }
}

