/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.apiculture.EnumBeeAttributes;
import forestry.core.config.Config;
import java.util.Set;

public enum EnumBeeSpecies {
    FOREST(0, "Forest", true, 20 * Config.beeAgeModifier, null, 0.3f, 20),
    MEADOWS(1, "Meadows", true, 20 * Config.beeAgeModifier, null, 0.3f, 20),
    COMMON(2, "Common", true, 20 * Config.beeAgeModifier, null, 1.0f, 10),
    CULTIVATED(3, "Cultivated", true, 10 * Config.beeAgeModifier, null, 1.2f, 10),
    NOBLE(4, "Noble", false, 30 * Config.beeAgeModifier, null, 0.8f, 30),
    MAJESTIC(5, "Majestic", true, 35 * Config.beeAgeModifier, null, 1.2f, 10),
    IMPERIAL(6, "Imperial", false, 40 * Config.beeAgeModifier, null, 0.6f, 10, true),
    DILIGENT(7, "Diligent", false, 30 * Config.beeAgeModifier, null, 0.8f, 30),
    UNWEARY(8, "Unweary", true, 35 * Config.beeAgeModifier, null, 1.2f, 10),
    INDUSTRIOUS(9, "Industrious", false, 40 * Config.beeAgeModifier, null, 0.6f, 10, true),
    STEADFAST(10, "Steadfast", false, 40 * Config.beeAgeModifier, null, null, 0.6f, 10, true, EnumBeeAttributes.heroicAttributes),
    VALIANT(11, "Valiant", true, 50 * Config.beeAgeModifier, null, null, 0.8f, 10, false, EnumBeeAttributes.heroicAttributes),
    HEROIC(12, "Heroic", false, 60 * Config.beeAgeModifier, null, null, 0.6f, 10, true, EnumBeeAttributes.heroicAttributes),
    SINISTER(13, "Sinister", false, 40 * Config.beeAgeModifier, null, null, 0.6f, 99, false, EnumBeeAttributes.infernalAttributes),
    FIENDISH(14, "Fiendish", true, 50 * Config.beeAgeModifier, null, null, 1.0f, 99, false, EnumBeeAttributes.infernalAttributes),
    DEMONIC(15, "Demonic", false, 60 * Config.beeAgeModifier, null, null, 0.4f, 99, true, EnumBeeAttributes.infernalAttributes);

    private final int meta;
    private final String name;
    private final boolean dominant;
    private final int health;
    private final kp product;
    private final kp specialty;
    private final float speed;
    private final int flowering;
    private final boolean hasEffect;
    private final Set attributes;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumBeeSpecies(boolean meta, int name, kp dominant, float health, int product) {
        this((String)var1_-1, (int)var2_-1, meta ? 1 : 0, (String)name, (boolean)dominant, (int)health, (kp)product, null, (float)speed, (int)flowering, false);
        void flowering;
        void speed;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumBeeSpecies(boolean meta, int name, kp dominant, float health, int product, boolean speed) {
        this((String)var1_-1, (int)var2_-1, meta ? 1 : 0, (String)name, (boolean)dominant, (int)health, (kp)product, null, (float)speed, (int)flowering, (boolean)hasEffect);
        void hasEffect;
        void flowering;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumBeeSpecies(boolean meta, int name, kp dominant, kp health, float product, int specialty) {
        this((String)var1_-1, (int)var2_-1, meta ? 1 : 0, (String)name, (boolean)dominant, (int)health, (kp)product, (kp)specialty, (float)speed, (int)flowering, false);
        void flowering;
        void speed;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumBeeSpecies(boolean meta, int name, kp dominant, kp health, float product, int specialty, boolean speed) {
        this((String)var1_-1, (int)var2_-1, meta ? 1 : 0, (String)name, (boolean)dominant, (int)health, (kp)product, (kp)specialty, (float)speed, (int)flowering, (boolean)hasEffect, null);
        void hasEffect;
        void flowering;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumBeeSpecies(boolean meta, int name, kp dominant, kp health, float product, int specialty, boolean speed, Set flowering) {
        void attributes;
        void hasEffect;
        this.meta = meta ? 1 : 0;
        this.name = (String)name;
        this.dominant = dominant;
        this.health = (int)health;
        this.product = (kp)product;
        this.specialty = (kp)specialty;
        this.speed = (float)speed;
        this.flowering = (int)flowering;
        this.hasEffect = hasEffect;
        this.attributes = attributes;
    }

    public int getMeta() {
        return this.meta;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public int getHealth() {
        return this.health;
    }

    public kp getProduct() {
        return this.product;
    }

    public kp getSpecialty() {
        return this.specialty;
    }

    public float getSpeed() {
        return this.speed;
    }

    public int getFlowering() {
        return this.flowering;
    }

    public boolean hasEffect() {
        return this.hasEffect;
    }

    public boolean heatResistant() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.contains((Object)EnumBeeAttributes.HEATRESISTANT);
    }

    public boolean coldResistant() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.contains((Object)EnumBeeAttributes.COLDRESISTANT);
    }

    public boolean isNocturnal() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.contains((Object)EnumBeeAttributes.NOCTURNAL);
    }

    public boolean isAquatic() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.contains((Object)EnumBeeAttributes.AQUATIC);
    }

    public boolean isCaveDweller() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.contains((Object)EnumBeeAttributes.CAVEDWELLER);
    }

    public boolean isEasterEgg() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.contains((Object)EnumBeeAttributes.EASTEREGG);
    }

    public boolean isAutochtonous() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.contains((Object)EnumBeeAttributes.AUTOCHTHONOUS);
    }

    public Set getAttributes() {
        return this.attributes;
    }
}

