/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.apiculture.EnumBeeSpecies;
import forestry.core.EnumErrorCode;
import java.util.EnumSet;
import java.util.Set;

public enum EnumBeeAttributes {
    ARID("Droughts", true),
    AQUATIC("Rain", true),
    AUTOCHTHONOUS,
    HEATRESISTANT("Heat", true),
    COLDRESISTANT("Cold", true),
    CAVEDWELLER("Cave Dweller"),
    EASTEREGG,
    NOCTURNAL("Nocturnal");

    private final String description;
    private final boolean isResistance;
    public static Set cultivatedAttributes;
    public static Set infernalAttributes;
    public static Set heroicAttributes;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumBeeAttributes() {
        this((String)var1_-1, (int)var2_-1, "");
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumBeeAttributes() {
        this((String)var1_-1, (int)var2_-1, (String)description, false);
        void description;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - void declaration
     */
    private EnumBeeAttributes() {
        void isResistance;
        void description;
        this.description = description;
        this.isResistance = isResistance;
    }

    public boolean isPublic() {
        return this.description.length() > 0;
    }

    public boolean isResistance() {
        return this.isResistance;
    }

    public String getDescription() {
        return this.description;
    }

    public static EnumErrorCode mayProduce(EnumBeeSpecies primary, EnumBeeSpecies secondary, ge world, int biomeid, int x, int y, int z) {
        if (world.x() && !primary.isAquatic() && !secondary.isAquatic()) {
            return EnumErrorCode.ISRAINING;
        }
        if (!(world.e() || primary.isNocturnal() || secondary.isNocturnal())) {
            return EnumErrorCode.NOTDAY;
        }
        if (!(world.l(x, y, z) || primary.isCaveDweller() || secondary.isCaveDweller())) {
            return EnumErrorCode.NOSKY;
        }
        if (world.n(x, y + 1, z) <= 11 && !primary.isNocturnal() && !secondary.isNocturnal()) {
            return EnumErrorCode.NOTLUCID;
        }
        if (biomeid == lt.j.M && !primary.heatResistant() && !secondary.heatResistant()) {
            return EnumErrorCode.INVALIDBIOME;
        }
        if (!(biomeid != lt.l.M && biomeid != lt.m.M && biomeid != lt.n.M && biomeid != lt.o.M || primary.coldResistant() || secondary.coldResistant())) {
            return EnumErrorCode.INVALIDBIOME;
        }
        return EnumErrorCode.OK;
    }

    public static boolean isJubilant(EnumBeeSpecies primary, EnumBeeSpecies secondary, ge world, int biomeid, int x, int y, int z) {
        return EnumBeeAttributes.isJubilantAllele(primary, world, biomeid, x, y, z) && EnumBeeAttributes.isJubilantAllele(secondary, world, biomeid, x, y, z);
    }

    private static boolean isJubilantAllele(EnumBeeSpecies species, ge world, int biomeid, int x, int y, int z) {
        if (!species.isAutochtonous()) {
            return true;
        }
        if (species.coldResistant() && biomeid != lt.l.M && biomeid != lt.m.M && biomeid != lt.o.M && biomeid != lt.n.M) {
            return false;
        }
        return !species.heatResistant() || biomeid == lt.j.M;
    }

    static {
        cultivatedAttributes = EnumSet.of(AQUATIC, AUTOCHTHONOUS, COLDRESISTANT);
        infernalAttributes = EnumSet.of(HEATRESISTANT, NOCTURNAL);
        heroicAttributes = EnumSet.of(NOCTURNAL, CAVEDWELLER, EASTEREGG);
    }
}

