/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.bptblocks;

import buildcraft.api.BlockSignature;
import buildcraft.api.BptBlock;
import buildcraft.api.BptSlotInfo;
import buildcraft.api.IBptContext;
import buildcraft.api.Orientations;
import java.util.LinkedList;

public class BptBlockSign
extends BptBlock {
    boolean isWall;

    public BptBlockSign(int blockId, boolean isWall) {
        super(blockId);
        this.isWall = isWall;
    }

    @Override
    public void addRequirements(BptSlotInfo slot, IBptContext context, LinkedList requirements) {
        requirements.add(new kp(id.at));
    }

    @Override
    public void rotateLeft(BptSlotInfo slot, IBptContext context) {
        if (!this.isWall) {
            double angle = (double)slot.meta * 360.0 / 16.0;
            if ((angle += 90.0) >= 360.0) {
                angle -= 360.0;
            }
            slot.meta = (int)(angle / 360.0 * 16.0);
        } else {
            slot.meta = Orientations.values()[slot.meta].rotateLeft().ordinal();
        }
    }

    @Override
    public BlockSignature getSignature(vz block) {
        BlockSignature sig = super.getSignature(block);
        sig.customField = this.isWall ? "wall" : "floor";
        return sig;
    }
}

