/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api;

import buildcraft.api.APIProxy;
import buildcraft.api.Action;
import buildcraft.api.BlockSignature;
import buildcraft.api.BptBlock;
import buildcraft.api.IActionProvider;
import buildcraft.api.IPipe;
import buildcraft.api.ITriggerProvider;
import buildcraft.api.ItemSignature;
import buildcraft.api.RefineryRecipe;
import buildcraft.api.Trigger;
import java.util.HashMap;
import java.util.LinkedList;

public class BuildCraftAPI {
    public static final int BUCKET_VOLUME = 1000;
    public static final int LAST_ORIGINAL_BLOCK = 122;
    public static final int LAST_ORIGINAL_ITEM = 126;
    public static boolean[] softBlocks;
    public static BptBlock[] blockBptProps;
    @Deprecated
    public static LinkedList liquids;
    @Deprecated
    public static HashMap ironEngineFuel;
    public static Trigger[] triggers;
    public static Action[] actions;
    private static ih buildCraftPlayer;
    @Deprecated
    private static LinkedList refineryRecipe;
    private static LinkedList triggerProviders;
    private static LinkedList actionProviders;

    public static boolean softBlock(int blockId) {
        return blockId == 0 || softBlocks[blockId] || vz.m[blockId] == null;
    }

    public static boolean unbreakableBlock(int blockId) {
        return blockId == vz.z.bO || blockId == vz.D.bO || blockId == vz.C.bO;
    }

    @Deprecated
    public static void breakBlock(ge world, int x, int y, int z) {
        int blockId = world.a(x, y, z);
        if (blockId != 0) {
            vz.m[blockId].b(world, x, y, z, world.c(x, y, z), 0);
        }
        world.e(x, y, z, 0);
    }

    public static ih getBuildCraftPlayer(ge world) {
        if (buildCraftPlayer == null) {
            buildCraftPlayer = APIProxy.createNewPlayer(world);
        }
        return buildCraftPlayer;
    }

    @Deprecated
    public static void registerRefineryRecipe(RefineryRecipe recipe) {
        if (!refineryRecipe.contains(recipe)) {
            refineryRecipe.add(recipe);
        }
    }

    public static BlockSignature getBlockSignature(vz block) {
        return blockBptProps[0].getSignature(block);
    }

    public static ItemSignature getItemSignature(id item) {
        ItemSignature sig = new ItemSignature();
        if (item.bP >= vz.m.length + 126) {
            sig.itemClassName = item.getClass().getSimpleName();
        }
        sig.itemName = item.a(new kp(item));
        return sig;
    }

    public static void registerTriggerProvider(ITriggerProvider provider) {
        if (provider != null && !triggerProviders.contains(provider)) {
            triggerProviders.add(provider);
        }
    }

    public static LinkedList getNeighborTriggers(vz block, qj entity) {
        LinkedList<Trigger> triggers = new LinkedList<Trigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList toAdd = provider.getNeighborTriggers(block, entity);
            if (toAdd == null) continue;
            for (Trigger t : toAdd) {
                if (triggers.contains(t)) continue;
                triggers.add(t);
            }
        }
        return triggers;
    }

    public static void registerActionProvider(IActionProvider provider) {
        if (provider != null && !actionProviders.contains(provider)) {
            actionProviders.add(provider);
        }
    }

    public static LinkedList getNeighborActions(vz block, qj entity) {
        LinkedList<Action> actions = new LinkedList<Action>();
        for (IActionProvider provider : actionProviders) {
            LinkedList toAdd = provider.getNeighborActions(block, entity);
            if (toAdd == null) continue;
            for (Action t : toAdd) {
                if (actions.contains(t)) continue;
                actions.add(t);
            }
        }
        return actions;
    }

    public static LinkedList getPipeTriggers(IPipe pipe) {
        LinkedList<Trigger> triggers = new LinkedList<Trigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList toAdd = provider.getPipeTriggers(pipe);
            if (toAdd == null) continue;
            for (Trigger t : toAdd) {
                if (triggers.contains(t)) continue;
                triggers.add(t);
            }
        }
        return triggers;
    }

    static {
        int i;
        softBlocks = new boolean[vz.m.length];
        blockBptProps = new BptBlock[vz.m.length];
        liquids = new LinkedList();
        ironEngineFuel = new HashMap();
        triggers = new Trigger[1024];
        actions = new Action[1024];
        refineryRecipe = new LinkedList();
        triggerProviders = new LinkedList();
        actionProviders = new LinkedList();
        for (i = 0; i < softBlocks.length; ++i) {
            BuildCraftAPI.softBlocks[i] = false;
        }
        for (i = 0; i < blockBptProps.length; ++i) {
            new BptBlock(i);
        }
    }
}

