/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.core.config.ForestryItem;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.StackUtils;
import forestry.mail.EnumAddressee;
import forestry.mail.EnumDeliveryState;
import forestry.mail.EnumPostage;
import forestry.mail.EnumStationState;
import forestry.mail.ILetter;
import forestry.mail.ILetterHandler;
import forestry.mail.IPostalState;
import forestry.mail.IStamps;
import forestry.mail.ItemLetter;
import forestry.mail.Letter;
import forestry.mail.MailAddress;
import forestry.mail.PostOffice;
import forestry.mail.TradeStationInfo;
import java.util.ArrayList;

public class TradeStation
extends zk
implements ILetterHandler,
io {
    public static final String SAVE_NAME = "TradePO_";
    public static final short SLOT_SIZE = 39;
    public static final short SLOT_TRADEGOOD = 0;
    public static final short SLOT_EXCHANGE_1 = 1;
    public static final short SLOT_EXCHANGE_COUNT = 4;
    public static final short SLOT_LETTERS_1 = 5;
    public static final short SLOT_LETTERS_COUNT = 6;
    public static final short SLOT_STAMPS_1 = 11;
    public static final short SLOT_STAMPS_COUNT = 4;
    public static final short SLOT_INPUTBUF_1 = 15;
    public static final short SLOT_OUTPUTBUF_1 = 27;
    public static final short SLOT_BUFFER_COUNT = 12;
    private String owner;
    private String moniker;
    private boolean isInvalid = false;
    private GenericInventoryAdapter inventory = new GenericInventoryAdapter(39, "INV");

    public TradeStation(String owner, String moniker, boolean isMoniker) {
        super(SAVE_NAME + moniker);
        this.owner = owner;
        this.moniker = moniker;
    }

    public TradeStation(String savename) {
        super(savename);
    }

    public void a(ady nbttagcompound) {
        this.owner = nbttagcompound.j("OWN");
        this.moniker = nbttagcompound.j("MNK");
        this.isInvalid = nbttagcompound.o("IVL");
        this.inventory.a(nbttagcompound);
    }

    public void b(ady nbttagcompound) {
        if (this.owner != null && !this.owner.isEmpty()) {
            nbttagcompound.a("OWN", this.owner);
        }
        nbttagcompound.a("MNK", this.moniker);
        nbttagcompound.a("IVL", this.isInvalid);
        this.inventory.b(nbttagcompound);
    }

    public boolean isValid() {
        return !this.isInvalid;
    }

    public void invalidate() {
        this.isInvalid = true;
    }

    public TradeStationInfo getTradeInfo() {
        aan[] condensedRequired = StackUtils.condenseStacks(this.inventory.getStacks(1, 4));
        EnumStationState state = EnumStationState.OK;
        if (!this.hasPaper()) {
            state = EnumStationState.INSUFFICIENT_PAPER;
        }
        if (!this.canPayPostage(2)) {
            state = EnumStationState.INSUFFICIENT_STAMPS;
        }
        if (this.countFillableOrders(1, this.inventory.k_(0)) <= 0) {
            state = EnumStationState.INSUFFICIENT_TRADE_GOOD;
        }
        return new TradeStationInfo(this.moniker, this.inventory.k_(0), condensedRequired, state);
    }

    @Override
    public IPostalState handleLetter(xd world, MailAddress address, aan letterstack, boolean doLodge) {
        int storable;
        ILetter letter = ItemLetter.getLetter(letterstack);
        if (!this.hasPaper()) {
            return EnumStationState.INSUFFICIENT_PAPER;
        }
        int ordersToFill = StackUtils.containsSets(this.inventory.getStacks(1, 4), letter.getAttachments());
        if (ordersToFill <= 0) {
            return EnumStationState.INSUFFICIENT_OFFER;
        }
        int fillable = this.countFillableOrders(ordersToFill, this.inventory.k_(0));
        if (fillable <= 0) {
            return EnumStationState.INSUFFICIENT_TRADE_GOOD;
        }
        if (fillable < ordersToFill) {
            ordersToFill = fillable;
        }
        if ((storable = this.countStorablePayment(ordersToFill, this.inventory.getStacks(1, 4))) <= 0) {
            return EnumStationState.INSUFFICIENT_BUFFER;
        }
        if (storable < ordersToFill) {
            ordersToFill = storable;
        }
        Letter mail = new Letter(new MailAddress(this.moniker, EnumAddressee.TRADER), letter.getSender());
        mail.setText("Please find your order attached.");
        for (int i = 0; i < ordersToFill; ++i) {
            mail.addAttachment(this.inventory.k_(0).k());
        }
        mail.addAttachments(this.getSurplusAttachments(ordersToFill, letter.getAttachments()));
        int requiredPostage = mail.requiredPostage();
        if (!this.canPayPostage(requiredPostage)) {
            return EnumStationState.INSUFFICIENT_STAMPS;
        }
        int[] stampCount = this.getPostage(requiredPostage);
        for (int i = 0; i < stampCount.length; ++i) {
            if (stampCount[i] <= 0) continue;
            mail.addStamps(new aan(ForestryItem.stamps, stampCount[i], EnumPostage.values()[i].ordinal()));
        }
        ady nbttagcompound = new ady();
        mail.b(nbttagcompound);
        aan mailstack = new aan(ForestryItem.letters, 1, ItemLetter.encodeMeta(1, ItemLetter.getType(mail)));
        mailstack.d(nbttagcompound);
        IPostalState responseState = PostOffice.getPostOffice(world).lodgeLetter(world, mailstack, doLodge);
        if (!responseState.isOk()) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        for (int i = 0; i < ordersToFill; ++i) {
            for (aan stack : this.inventory.getStacks(1, 4)) {
                if (stack == null) continue;
                this.inventory.tryAddStack(stack.k(), 27, 12, false);
            }
        }
        this.removePaper();
        this.removeStamps(stampCount);
        this.removeTradegood(ordersToFill);
        this.a();
        if (doLodge && this.owner != null && !this.owner.isEmpty()) {
            Letter confirm = new Letter(new MailAddress(this.moniker, EnumAddressee.TRADER), new MailAddress(this.owner));
            confirm.setText("We have filled " + ordersToFill + " orders from " + letter.getSender().getIdentifier());
            confirm.addStamps(new aan(ForestryItem.stamps, 1, EnumPostage.P_1.ordinal()));
            nbttagcompound = new ady();
            confirm.b(nbttagcompound);
            aan confirmstack = new aan(ForestryItem.letters, 1, ItemLetter.encodeMeta(1, ItemLetter.getType(confirm)));
            confirmstack.d(nbttagcompound);
            PostOffice.getPostOffice(world).lodgeLetter(world, confirmstack, doLodge);
        }
        return EnumDeliveryState.OK;
    }

    private int countFillableOrders(int max, aan tradegood) {
        if (tradegood == null) {
            return 0;
        }
        int itemCount = 0;
        for (aan stack : this.inventory.getStacks(15, 12)) {
            if (stack == null || !stack.a(tradegood)) continue;
            itemCount += stack.a;
        }
        return (int)Math.floor(itemCount / tradegood.a);
    }

    private int countStorablePayment(int max, aan[] exchange) {
        GenericInventoryAdapter test = this.inventory.copy();
        int count = 0;
        for (int i = 0; i < max && test.tryAddStacksCopy(exchange, true); ++i) {
            ++count;
        }
        return count;
    }

    private void removeTradegood(int filled) {
        block0: for (int j = 0; j < filled; ++j) {
            int toRemove = this.inventory.k_((int)0).a;
            for (int i = 15; i < 27; ++i) {
                aan buffer = this.inventory.k_(i);
                if (buffer == null || !buffer.a(this.inventory.k_(0))) continue;
                aan decrease = this.inventory.a(i, toRemove);
                if ((toRemove -= decrease.a) <= 0) continue block0;
            }
        }
    }

    private boolean hasPaper() {
        for (aan stack : this.inventory.getStacks(5, 6)) {
            if (stack == null || stack.a <= 0) continue;
            return true;
        }
        return false;
    }

    private void removePaper() {
        for (int i = 5; i < 11; ++i) {
            aan stack = this.inventory.k_(i);
            if (stack == null || stack.c != yr.aK.bQ || stack.a <= 0) continue;
            this.inventory.a(i, 1);
            break;
        }
    }

    private boolean canPayPostage(int postage) {
        int posted = 0;
        for (aan stamp : this.inventory.getStacks(11, 4)) {
            if (stamp == null || !(stamp.a() instanceof IStamps) || (posted += ((IStamps)stamp.a()).getPostage(stamp).getValue() * stamp.a) < postage) continue;
            return true;
        }
        return false;
    }

    private int[] getPostage(int postage) {
        int[] stamps = new int[EnumPostage.values().length];
        for (int i = EnumPostage.values().length - 1; i > 0 && postage > 0; --i) {
            EnumPostage postValue = EnumPostage.values()[i];
            if (postValue.getValue() > postage) continue;
            int num = this.getNumStamps(postValue);
            int max = (int)Math.floor(postage / postValue.getValue());
            if (max < num) {
                num = max;
            }
            stamps[i] = num;
            postage -= num * postValue.getValue();
        }
        return stamps;
    }

    private int getNumStamps(EnumPostage postage) {
        int count = 0;
        for (aan stamp : this.inventory.getStacks(11, 4)) {
            if (stamp == null || !(stamp.a() instanceof IStamps) || ((IStamps)stamp.a()).getPostage(stamp) != postage) continue;
            count += stamp.a;
        }
        return count;
    }

    private void removeStamps(int[] stampCount) {
        for (int i = 1; i < stampCount.length; ++i) {
            if (stampCount[i] <= 0) continue;
            for (int j = 11; j < 15; ++j) {
                aan stamp;
                if (stampCount[i] <= 0 || (stamp = this.inventory.k_(j)) == null || !(stamp.a() instanceof IStamps) || ((IStamps)stamp.a()).getPostage(stamp) != EnumPostage.values()[i]) continue;
                aan decrease = this.inventory.a(j, stampCount[i]);
                int n = i;
                stampCount[n] = stampCount[n] - decrease.a;
            }
        }
    }

    private aan[] getSurplusAttachments(int filled, aan[] attachments) {
        int i;
        ArrayList<aan> surplus = new ArrayList<aan>();
        aan[] pool = new aan[attachments.length];
        for (i = 0; i < attachments.length; ++i) {
            if (attachments[i] == null) continue;
            pool[i] = attachments[i].k();
        }
        for (i = 0; i < filled; ++i) {
            aan[] condensedRequired;
            for (aan req : condensedRequired = StackUtils.condenseStacks(this.inventory.getStacks(1, 4))) {
                for (int j = 0; j < pool.length; ++j) {
                    aan pol = pool[j];
                    if (pol == null || !pol.a(req)) continue;
                    if (req.a >= pol.a) {
                        req.a -= pol.a;
                        pool[j] = null;
                        continue;
                    }
                    pol.a -= req.a;
                    req.a = 0;
                }
            }
        }
        for (aan stack : pool) {
            if (stack == null) continue;
            surplus.add(stack);
        }
        return surplus.toArray(new aan[0]);
    }

    public void j() {
        this.a();
        this.inventory.j();
    }

    public void a(int var1, aan var2) {
        this.a();
        this.inventory.a(var1, var2);
    }

    public int a() {
        return this.inventory.a();
    }

    public aan k_(int var1) {
        return this.inventory.k_(var1);
    }

    public aan a(int var1, int var2) {
        return this.inventory.a(var1, var2);
    }

    public aan b(int var1) {
        return this.inventory.b(var1);
    }

    public String c() {
        return this.inventory.c();
    }

    public int d() {
        return this.inventory.d();
    }

    public boolean a_(yw var1) {
        return this.inventory.a_(var1);
    }

    public void e() {
    }

    public void f() {
    }
}

