/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleFlowers;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IApiaristTracker;
import forestry.api.genetics.IMutation;
import forestry.apiculture.ContainerBeealyzer;
import forestry.apiculture.ItemBeeGE;
import forestry.apiculture.ItemBeealyzer;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.AlleleArea;
import forestry.core.genetics.AlleleBoolean;
import forestry.core.genetics.AlleleFloat;
import forestry.core.genetics.AlleleInteger;
import forestry.core.genetics.AlleleTolerance;
import forestry.core.genetics.ClimateHelper;
import forestry.core.genetics.EnumMutateChance;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Vect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lwjgl.opengl.GL11;

public class GuiBeealyzer
extends GuiForestry {
    private io inventory;
    private int startX;
    private int startY;
    private aan[] iconStacks = new aan[256];
    private aan[] tempProductList;
    private IApiaristTracker breedingTracker;

    public GuiBeealyzer(yw player, ItemBeealyzer.BeealyzerInventory inventory) {
        super("/gfx/forestry/gui/beealyzer.png", new ContainerBeealyzer(player.ap, inventory), inventory, 1, inventory.a());
        this.inventory = inventory;
        this.xSize = 196;
        this.ySize = 238;
        ArrayList beeList = new ArrayList();
        ((ItemBeeGE)ForestryItem.beeDroneGE).addCreativeItems(beeList, false);
        Iterator i$ = beeList.iterator();
        while (i$.hasNext()) {
            aan beeStack;
            this.iconStacks[BeeManager.beeInterface.getBee((aan)beeStack).getMeta()] = beeStack = (aan)i$.next();
        }
        this.breedingTracker = BeeManager.breedingManager.getApiaristTracker(player.k);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        this.drawBackground();
        int page = 0;
        IBee bee = null;
        for (int k = 1; k < 5; ++k) {
            if (this.inventory.k_(k) == null || (bee = BeeManager.beeInterface.getBee(this.inventory.k_(k))) == null || !bee.isAnalyzed()) continue;
            page = k;
            break;
        }
        switch (page) {
            case 1: {
                this.drawAnalyticsPage1(bee);
                break;
            }
            case 2: {
                this.drawAnalyticsPage2(bee);
                break;
            }
            case 3: {
                this.drawAnalyticsPage3(bee);
                break;
            }
            case 4: {
                this.drawAnalyticsPage4(bee);
                break;
            }
            default: {
                this.drawAnalyticsOverview();
            }
        }
    }

    private void drawAnalyticsOverview() {
        String title = StringUtil.localize("gui.beealyzer").toUpperCase();
        this.u.b(title, this.startX + 8 + this.getCenteredOffset(title, 158), this.startY + 18, this.fontColor.get("gui.screen"));
        this.u.a(StringUtil.localize("gui.beealyzer.help"), this.startX + 10, this.startY + 42, 158, this.fontColor.get("gui.screen"));
        this.u.b(StringUtil.localize("gui.beealyzer.overview") + ":", this.startX + 10, this.startY + 78, this.fontColor.get("gui.screen"));
        this.u.b("I  : " + StringUtil.localize("gui.general"), this.startX + 10, this.startY + 90, this.fontColor.get("gui.screen"));
        this.u.b("II : " + StringUtil.localize("gui.environment"), this.startX + 10, this.startY + 102, this.fontColor.get("gui.screen"));
        this.u.b("III: " + StringUtil.localize("gui.produce"), this.startX + 10, this.startY + 114, this.fontColor.get("gui.screen"));
        this.u.b("IV : " + StringUtil.localize("gui.evolution"), this.startX + 10, this.startY + 126, this.fontColor.get("gui.screen"));
    }

    private void drawAnalyticsPage1(IBee bee) {
        this.u.b(StringUtil.localize("gui.active"), this.startX + 60, this.startY + 18, this.fontColor.get("gui.table.header"));
        this.u.b(StringUtil.localize("gui.inactive"), this.startX + 113, this.startY + 18, this.fontColor.get("gui.table.header"));
        this.u.b(StringUtil.localize("gui.species"), this.startX + 10, this.startY + 30, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.lifespan"), this.startX + 10, this.startY + 42, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.speed"), this.startX + 10, this.startY + 54, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.flowers"), this.startX + 10, this.startY + 66, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.fertility"), this.startX + 10, this.startY + 78, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.area"), this.startX + 10, this.startY + 90, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.effect"), this.startX + 10, this.startY + 102, this.fontColor.get("gui.table.row"));
        this.u.b(bee.getGenome().getPrimaryAsBee().getName(), this.startX + 60, this.startY + 30, this.getColorCoding(bee.getGenome().getPrimaryAsBee().isDominant()));
        this.u.b(bee.getGenome().getSecondaryAsBee().getName(), this.startX + 113, this.startY + 30, this.getColorCoding(bee.getGenome().getSecondaryAsBee().isDominant()));
        this.u.b(Bee.rateLifespan(bee.getGenome().getLifespan()), this.startX + 60, this.startY + 42, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.LIFESPAN.ordinal()).isDominant()));
        this.u.b(Bee.rateLifespan(((AlleleInteger)bee.getGenome().getInactiveAllele(EnumBeeChromosome.LIFESPAN.ordinal())).getValue()), this.startX + 113, this.startY + 42, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.LIFESPAN.ordinal()).isDominant()));
        this.u.b(Bee.rateSpeed(bee.getGenome().getSpeed()), this.startX + 60, this.startY + 54, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.SPEED.ordinal()).isDominant()));
        this.u.b(Bee.rateSpeed(((AlleleFloat)bee.getGenome().getInactiveAllele(EnumBeeChromosome.SPEED.ordinal())).getValue()), this.startX + 113, this.startY + 54, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.SPEED.ordinal()).isDominant()));
        this.u.b(StringUtil.localize(bee.getGenome().getFlowerProvider().getDescription()), this.startX + 60, this.startY + 66, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.FLOWER_PROVIDER.ordinal()).isDominant()));
        this.u.b(StringUtil.localize(((IAlleleFlowers)bee.getGenome().getInactiveAllele(EnumBeeChromosome.FLOWER_PROVIDER.ordinal())).getProvider().getDescription()), this.startX + 113, this.startY + 66, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.FLOWER_PROVIDER.ordinal()).isDominant()));
        this.drawFertilityInfo(bee.getGenome().getFertility(), this.startX + 60, this.startY + 78, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.FERTILITY.ordinal()).isDominant()));
        this.drawFertilityInfo(((AlleleInteger)bee.getGenome().getInactiveAllele(EnumBeeChromosome.FERTILITY.ordinal())).getValue(), this.startX + 113, this.startY + 78, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.FERTILITY.ordinal()).isDominant()));
        int[] areaAr = bee.getGenome().getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        this.u.b(area.ToString(), this.startX + 60, this.startY + 90, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.TERRITORY.ordinal()).isDominant()));
        this.u.b(((AlleleArea)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TERRITORY.ordinal())).getArea().ToString(), this.startX + 113, this.startY + 90, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.TERRITORY.ordinal()).isDominant()));
        this.u.b(StringUtil.localize(bee.getGenome().getEffect().getIdentifier()), this.startX + 60, this.startY + 102, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.EFFECT.ordinal()).isDominant()));
        this.u.b(StringUtil.localize(((IAlleleBeeEffect)bee.getGenome().getInactiveAllele(EnumBeeChromosome.EFFECT.ordinal())).getIdentifier()), this.startX + 113, this.startY + 102, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.EFFECT.ordinal()).isDominant()));
        String binomial = bee.getGenome().getPrimaryAsBee().getBinomial();
        if (binomial != null && binomial.length() > 0) {
            binomial = "\"Apis " + binomial + "\"";
            int offset = (158 - this.u.a(binomial)) / 2;
            this.u.b(binomial, this.startX + 8 + offset, this.startY + 126, this.fontColor.get("gui.beealyzer.binomial"));
        }
    }

    private void drawAnalyticsPage2(IBee bee) {
        this.u.b(StringUtil.localize("gui.active"), this.startX + 60, this.startY + 18, this.fontColor.get("gui.table.header"));
        this.u.b(StringUtil.localize("gui.inactive"), this.startX + 113, this.startY + 18, this.fontColor.get("gui.table.header"));
        this.u.b(StringUtil.localize("gui.climate"), this.startX + 10, this.startY + 30, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.temptol"), this.startX + 10, this.startY + 42, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.humidity"), this.startX + 10, this.startY + 54, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.humidtol"), this.startX + 10, this.startY + 66, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.nocturnal"), this.startX + 10, this.startY + 78, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.flyer"), this.startX + 10, this.startY + 90, this.fontColor.get("gui.table.row"));
        this.u.b(StringUtil.localize("gui.cave"), this.startX + 10, this.startY + 102, this.fontColor.get("gui.table.row"));
        this.u.b(ClimateHelper.toDisplay(bee.getGenome().getPrimaryAsBee().getTemperature()), this.startX + 60, this.startY + 30, this.getColorCoding(bee.getGenome().getPrimaryAsBee().isDominant()));
        this.u.b(ClimateHelper.toDisplay(bee.getGenome().getSecondaryAsBee().getTemperature()), this.startX + 113, this.startY + 30, this.getColorCoding(bee.getGenome().getSecondaryAsBee().isDominant()));
        this.drawToleranceInfo(bee.getGenome().getToleranceTemp(), this.startX + 60, this.startY + 42, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()).isDominant()));
        this.drawToleranceInfo(((AlleleTolerance)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal())).getValue(), this.startX + 113, this.startY + 42, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()).isDominant()));
        this.u.b(ClimateHelper.toDisplay(bee.getGenome().getPrimaryAsBee().getHumidity()), this.startX + 60, this.startY + 54, this.getColorCoding(bee.getGenome().getPrimaryAsBee().isDominant()));
        this.u.b(ClimateHelper.toDisplay(bee.getGenome().getSecondaryAsBee().getHumidity()), this.startX + 113, this.startY + 54, this.getColorCoding(bee.getGenome().getSecondaryAsBee().isDominant()));
        this.drawToleranceInfo(bee.getGenome().getToleranceHumid(), this.startX + 60, this.startY + 66, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()).isDominant()));
        this.drawToleranceInfo(((AlleleTolerance)bee.getGenome().getInactiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal())).getValue(), this.startX + 113, this.startY + 66, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()).isDominant()));
        String yes = StringUtil.localize("yes");
        String no = StringUtil.localize("no");
        String primary = StringUtil.readableBoolean(bee.getGenome().getNocturnal(), yes, no);
        String secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.NOCTURNAL.ordinal())).getValue(), yes, no);
        this.u.b(primary, this.startX + 60, this.startY + 78, this.getColorCoding(false));
        this.u.b(secondary, this.startX + 113, this.startY + 78, this.getColorCoding(false));
        primary = StringUtil.readableBoolean(bee.getGenome().getTolerantFlyer(), yes, no);
        secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TOLERANT_FLYER.ordinal())).getValue(), yes, no);
        this.u.b(primary, this.startX + 60, this.startY + 90, this.getColorCoding(false));
        this.u.b(secondary, this.startX + 113, this.startY + 90, this.getColorCoding(false));
        primary = StringUtil.readableBoolean(bee.getGenome().getCaveDwelling(), yes, no);
        secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.CAVE_DWELLING.ordinal())).getValue(), yes, no);
        this.u.b(primary, this.startX + 60, this.startY + 102, this.getColorCoding(false));
        this.u.b(secondary, this.startX + 113, this.startY + 102, this.getColorCoding(false));
    }

    private void drawAnalyticsPage3(IBee bee) {
        this.u.b(StringUtil.localize("gui.beealyzer.produce") + ":", this.startX + 10, this.startY + 18, this.fontColor.get("gui.table.header"));
        this.u.b(StringUtil.localize("gui.beealyzer.specialty") + ":", this.startX + 10, this.startY + 78, this.fontColor.get("gui.table.header"));
        if (this.tempProductList == null) {
            this.tempProductList = bee.getProduceList();
        }
        int x = 10;
        int y = 30;
        for (aan stack : this.tempProductList) {
            itemRenderer.a(this.u, this.p.p, stack, this.startX + x, this.startY + y);
            if ((x += 18) <= 148) continue;
            x = 10;
            y += 18;
        }
        x = 10;
        y = 94;
        for (aan stack : bee.getSpecialtyList()) {
            itemRenderer.a(this.u, this.p.p, stack, this.startX + x, this.startY + y);
            if ((x += 18) <= 148) continue;
            x = 10;
            y += 18;
        }
    }

    private void drawAnalyticsPage4(IBee bee) {
        this.u.b(StringUtil.localize("gui.beealyzer.mutations") + ":", this.startX + 10, this.startY + 10, this.fontColor.get("gui.table.header"));
        tf.c();
        HashMap<IMutation, IAlleleBeeSpecies> combinations = new HashMap<IMutation, IAlleleBeeSpecies>();
        for (IMutation mutation : BeeTemplates.getCombinations(bee.getGenome().getPrimaryAsBee())) {
            combinations.put(mutation, bee.getGenome().getPrimaryAsBee());
        }
        for (IMutation mutation : BeeTemplates.getCombinations(bee.getGenome().getSecondaryAsBee())) {
            combinations.put(mutation, bee.getGenome().getSecondaryAsBee());
        }
        int columnWidth = 53;
        int lineHeight = 18;
        int column = 0;
        int line = 0;
        for (Map.Entry mutation : combinations.entrySet()) {
            if (this.breedingTracker.isDiscovered((IMutation)mutation.getKey())) {
                this.drawMutationInfo((IMutation)mutation.getKey(), (IAllele)mutation.getValue(), this.startX + 8 + column * columnWidth, this.startY + 20 + line * lineHeight);
            } else {
                if (((IMutation)mutation.getKey()).isSecret()) continue;
                this.drawUnknownMutation((IMutation)mutation.getKey(), (IAllele)mutation.getValue(), this.startX + 8 + column * columnWidth, this.startY + 20 + line * lineHeight);
            }
            if (++line <= 6) continue;
            line = 0;
            ++column;
        }
    }

    private void drawFertilityInfo(int fertility, int x, int y, int textColor) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.p.p.b(this.p.p.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x + 19, y, 196, 43, 12, 9);
        this.u.b(Integer.toString(fertility) + " x", x, y, textColor);
    }

    private void drawToleranceInfo(EnumTolerance tolerance, int x, int y, int textColor) {
        int length = tolerance.toString().length();
        String text = "(" + tolerance.toString().substring(length - 1) + ")";
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                this.drawBothSymbol(x, y - 1);
                this.u.b(text, x + 20, y, textColor);
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                this.drawDownSymbol(x, y - 1);
                this.u.b(text, x + 20, y, textColor);
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                this.drawUpSymbol(x, y - 1);
                this.u.b(text, x + 20, y, textColor);
                break;
            }
            default: {
                this.drawNoneSymbol(x, y - 1);
                this.u.b("(0)", x + 20, y, textColor);
            }
        }
    }

    private void drawDownSymbol(int x, int y) {
        this.p.p.b(this.p.p.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x, y, 196, 34, 15, 9);
    }

    private void drawUpSymbol(int x, int y) {
        this.p.p.b(this.p.p.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x, y, 211, 34, 15, 9);
    }

    private void drawBothSymbol(int x, int y) {
        this.p.p.b(this.p.p.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x, y, 226, 34, 15, 9);
    }

    private void drawNoneSymbol(int x, int y) {
        this.p.p.b(this.p.p.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x, y, 241, 34, 15, 9);
    }

    private void drawMutationInfo(IMutation combination, IAllele species, int x, int y) {
        itemRenderer.a(this.u, this.p.p, this.iconStacks[combination.getPartner(species).getId()], x, y);
        itemRenderer.b(this.u, this.p.p, this.iconStacks[combination.getPartner(species).getId()], x, y);
        IAllele result = combination.getTemplate()[EnumBeeChromosome.SPECIES.ordinal()];
        itemRenderer.a(this.u, this.p.p, this.iconStacks[result.getId()], x + 33, y);
        itemRenderer.b(this.u, this.p.p, this.iconStacks[result.getId()], x + 33, y);
        int line = 0;
        int column = 196;
        switch (EnumMutateChance.rateChance(combination.getBaseChance())) {
            case HIGHEST: {
                column = 226;
                line = 9;
                break;
            }
            case HIGHER: {
                column = 211;
                line = 9;
                break;
            }
            case HIGH: {
                line = 9;
                break;
            }
            case NORMAL: {
                column = 226;
                break;
            }
            case LOW: {
                column = 211;
                break;
            }
        }
        this.p.p.b(this.p.p.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x + 18, y + 4, column, line, 15, 9);
    }

    private void drawUnknownMutation(IMutation combination, IAllele species, int x, int y) {
        this.p.p.b(this.p.p.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x, y, 196, 18, 16, 16);
        this.p.p.b(this.p.p.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x + 32, y, 196, 18, 16, 16);
        int line = 0;
        int column = 196;
        switch (EnumMutateChance.rateChance(combination.getBaseChance())) {
            case HIGHEST: {
                column = 226;
                line = 9;
                break;
            }
            case HIGHER: {
                column = 211;
                line = 9;
                break;
            }
            case HIGH: {
                line = 9;
                break;
            }
            case NORMAL: {
                column = 226;
                break;
            }
            case LOW: {
                column = 211;
                break;
            }
        }
        this.p.p.b(this.p.p.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x + 18, y + 4, column, line, 15, 9);
    }

    private int getColorCoding(boolean dominant) {
        if (dominant) {
            return this.fontColor.get("gui.beealyzer.dominant");
        }
        return this.fontColor.get("gui.beealyzer.recessive");
    }

    @Override
    public void c() {
        super.c();
        this.startX = (this.q - this.xSize) / 2;
        this.startY = (this.r - this.ySize) / 2;
    }
}

