/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import buildcraft.api.Orientations;
import forestry.core.ForestryClient;
import forestry.core.TemperatureState;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileEngine;
import forestry.core.interfaces.IBlockRenderer;
import forge.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderEngine
implements IBlockRenderer {
    private ho model = new ho(){};
    private String gfxBase;
    private qp boiler = new qp(this.model, 0, 0);
    private qp trunk;
    private qp piston;
    private qp extension;

    public RenderEngine() {
        this.boiler.a(-8.0f, -8.0f, -8.0f, 16, 6, 16);
        this.boiler.c = 8.0f;
        this.boiler.d = 8.0f;
        this.boiler.e = 8.0f;
        this.trunk = new qp(this.model, 0, 0);
        this.trunk.a(-4.0f, -4.0f, -4.0f, 8, 12, 8);
        this.trunk.c = 8.0f;
        this.trunk.d = 8.0f;
        this.trunk.e = 8.0f;
        this.piston = new qp(this.model, 0, 0);
        this.piston.a(-6.0f, -2.0f, -6.0f, 12, 4, 12);
        this.piston.c = 8.0f;
        this.piston.d = 8.0f;
        this.piston.e = 8.0f;
        this.extension = new qp(this.model, 0, 0);
        this.extension.a(-5.0f, -3.0f, -5.0f, 10, 2, 10);
        this.extension.c = 8.0f;
        this.extension.d = 8.0f;
        this.extension.e = 8.0f;
    }

    public RenderEngine(String baseTexture) {
        this();
        this.gfxBase = baseTexture;
    }

    @Override
    public void preloadTextures() {
        ForestryClient.preloadTexture(this.gfxBase + "base.png");
        ForestryClient.preloadTexture(this.gfxBase + "extension.png");
        ForestryClient.preloadTexture(this.gfxBase + "piston.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/engine_trunk_low.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/engine_trunk_medium.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/engine_trunk_high.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/engine_trunk_higher.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/engine_trunk_highest.png");
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(TemperatureState.COOL, 0.25f, Orientations.YPos, x, y, z);
    }

    @Override
    public void renderTileEntityAt(kw tileentity, double d, double d1, double d2, float f) {
        TileEngine engineTile = (TileEngine)tileentity;
        Engine engine = engineTile.getEngine();
        if (engine != null) {
            this.render(engine.getTemperatureState(), engine.progress, engineTile.getOrientation(), d, d1, d2);
        }
    }

    private void render(TemperatureState state, float progress, Orientations orientation, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float step = (double)progress > 0.5 ? 5.99f - (progress - 0.5f) * 2.0f * 5.99f : progress * 2.0f * 5.99f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        float tfactor = step / 16.0f;
        switch (orientation) {
            case XPos: {
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case XNeg: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case YPos: {
                translate[1] = 1.0f;
                break;
            }
            case YNeg: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case ZPos: {
                angle[0] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            case ZNeg: {
                angle[0] = -1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.boiler.f = angle[0];
        this.boiler.g = angle[1];
        this.boiler.h = angle[2];
        this.trunk.f = angle[0];
        this.trunk.g = angle[1];
        this.trunk.h = angle[2];
        this.piston.f = angle[0];
        this.piston.g = angle[1];
        this.piston.h = angle[2];
        this.extension.f = angle[0];
        this.extension.g = angle[1];
        this.extension.h = angle[2];
        float factor = 0.0625f;
        MinecraftForgeClient.bindTexture((String)(this.gfxBase + "base.png"));
        this.boiler.a(factor);
        MinecraftForgeClient.bindTexture((String)(this.gfxBase + "piston.png"));
        GL11.glTranslatef((float)(translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(translate[2] * tfactor));
        this.piston.a(factor);
        GL11.glTranslatef((float)(-translate[0] * tfactor), (float)(-translate[1] * tfactor), (float)(-translate[2] * tfactor));
        MinecraftForgeClient.bindTexture((String)(this.gfxBase + "extension.png"));
        float chamberf = 0.125f;
        int i = 0;
        while ((float)i <= step + 2.0f) {
            this.extension.a(factor);
            GL11.glTranslatef((float)(translate[0] * chamberf), (float)(translate[1] * chamberf), (float)(translate[2] * chamberf));
            i += 2;
        }
        i = 0;
        while ((float)i <= step + 2.0f) {
            GL11.glTranslatef((float)(-translate[0] * chamberf), (float)(-translate[1] * chamberf), (float)(-translate[2] * chamberf));
            i += 2;
        }
        String texture = "";
        switch (state) {
            case OVERHEATING: {
                texture = "/gfx/forestry/blocks/engine_trunk_highest.png";
                break;
            }
            case RUNNING_HOT: {
                texture = "/gfx/forestry/blocks/engine_trunk_higher.png";
                break;
            }
            case OPERATING_TEMPERATURE: {
                texture = "/gfx/forestry/blocks/engine_trunk_high.png";
                break;
            }
            case WARMED_UP: {
                texture = "/gfx/forestry/blocks/engine_trunk_medium.png";
                break;
            }
            default: {
                texture = "/gfx/forestry/blocks/engine_trunk_low.png";
            }
        }
        MinecraftForgeClient.bindTexture((String)texture);
        this.trunk.a(factor);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

