/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.utils.Vect;
import java.util.HashMap;

public class StructureBlueprint {
    public String id;
    private int[][][] pattern;
    public static final HashMap index = new HashMap();
    public static final StructureBlueprint defaultArboretum = new StructureBlueprint("defaultArboretum", new Vect(15, 10, 15));
    public static final StructureBlueprint defaultFarm = new StructureBlueprint("defaultFarm", new Vect(15, 6, 15));

    public StructureBlueprint(String id, Vect area) {
        this.id = id;
        this.pattern = new int[area.y][area.x][area.z];
    }

    public void setPlane(int y, int[][] plane) {
        this.pattern[y] = plane;
    }

    public int getBlockId(Vect pos) {
        if (pos.y >= this.pattern.length) {
            return -1;
        }
        if (pos.x >= this.pattern[pos.y].length) {
            return -1;
        }
        if (pos.z >= this.pattern[pos.y][pos.x].length) {
            return -1;
        }
        return this.pattern[pos.y][pos.x][pos.z];
    }

    public int getYLength() {
        return this.pattern.length;
    }

    public int getXLength() {
        return this.pattern[0].length;
    }

    public int getZLength() {
        return this.pattern[0][0].length;
    }

    public static StructureBlueprint getBlueprint(String id) {
        if (index.containsKey(id)) {
            return (StructureBlueprint)index.get(id);
        }
        ModLoader.getLogger().severe("Tried to retrieve unknown StructureBlueprint identified by " + id);
        return null;
    }

    static {
        int[][] arboretum0 = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        defaultArboretum.setPlane(0, arboretum0);
        int[][] arboretum1 = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        defaultArboretum.setPlane(1, arboretum1);
        defaultArboretum.setPlane(2, arboretum1);
        defaultArboretum.setPlane(3, arboretum1);
        defaultArboretum.setPlane(4, arboretum1);
        defaultArboretum.setPlane(5, arboretum1);
        defaultArboretum.setPlane(6, arboretum1);
        defaultArboretum.setPlane(7, arboretum1);
        defaultArboretum.setPlane(8, arboretum1);
        defaultArboretum.setPlane(9, arboretum1);
        int[][] farm0 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0}, {0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0}, {0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0}, {0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0}, {0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0}, {0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0}, {0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        defaultFarm.setPlane(0, farm0);
        defaultFarm.setPlane(1, farm0);
        defaultFarm.setPlane(2, farm0);
        defaultFarm.setPlane(3, farm0);
        defaultFarm.setPlane(4, farm0);
        defaultFarm.setPlane(5, farm0);
    }
}

