/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.LiquidSlot;
import buildcraft.api.Orientations;
import buildcraft.api.PowerFramework;
import buildcraft.api.PowerProvider;
import forestry.core.Proxy;
import forestry.core.gadgets.Gadget;
import forestry.core.gadgets.GadgetManager;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.MachinePackage;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IEnergyConsumer;
import forestry.core.interfaces.ILinkedEntity;
import forestry.core.interfaces.ISecuredInventory;
import forestry.core.interfaces.ITankContainer;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.TankSlot;
import forestry.plugins.PluginBuildCraft;
import forge.ISidedInventory;
import ic2.api.Direction;
import ic2.api.IEnergySource;
import java.util.LinkedList;

public class TileMachine
extends TileForestry
implements ITankContainer,
ISidedInventory,
ISecuredInventory,
IEnergyConsumer,
IEnergySource,
ILinkedEntity,
IClimatised {
    public Machine machine;
    private PowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public TileMachine() {
        this.powerProvider.configure(1000, 5, 40, 75, 500);
    }

    protected MachinePackage getPackage(int meta) {
        return GadgetManager.getMachinePackage(meta);
    }

    @Override
    public Gadget getMachine() {
        return this.machine;
    }

    @Override
    public boolean throwsErrors() {
        if (this.machine != null) {
            return this.machine.throwsErrors();
        }
        return false;
    }

    @Override
    public boolean hasHints() {
        if (this.machine != null) {
            return this.machine.hasHints();
        }
        return false;
    }

    @Override
    public String[] getHints() {
        if (this.machine != null) {
            return this.machine.getHints();
        }
        return null;
    }

    @Override
    public boolean isClimatized() {
        if (this.machine != null) {
            return this.machine.isClimatized();
        }
        return false;
    }

    @Override
    public float getTemperature() {
        if (this.machine != null) {
            return this.machine.getTemperature();
        }
        return 0.0f;
    }

    @Override
    public float getHumidity() {
        if (this.machine != null) {
            return this.machine.getHumidity();
        }
        return 0.0f;
    }

    @Override
    public boolean isOwnable() {
        return true;
    }

    protected boolean hasPackage(int meta) {
        return GadgetManager.hasMachinePackage(meta);
    }

    protected void createMachine() {
        int meta = this.i.e(this.j, this.k, this.l);
        if (!this.hasPackage(meta)) {
            ModLoader.getLogger().info("Encountered a " + this.getClass() + " with meta " + meta + ". However no such MachinePackage exists. Falling back to meta=0.");
            meta = 0;
        }
        this.pack = this.getPackage(meta);
        MachinePackage packMachine = (MachinePackage)this.pack;
        PluginBuildCraft.instance.configurePowerProvider(this.powerProvider, packMachine.energyConfig);
        MachineFactory factory = packMachine.factory;
        if (factory == null) {
            throw new RuntimeException("Missing MachineFactory for " + this.getClass() + " and meta " + meta);
        }
        this.machine = factory.createMachine(this);
        this.i.j(this.j, this.k, this.l, meta);
    }

    @Override
    protected void initialize() {
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        if (this.machine == null) {
            this.createMachine();
        }
    }

    @Override
    public void n_() {
        super.n_();
        if (this.machine != null) {
            if (Proxy.isMultiplayerWorld()) {
                this.machine.updateClientSide();
            } else {
                this.machine.updateServerSide();
            }
        }
    }

    @Override
    public void onRemoval() {
        if (this.machine != null) {
            this.machine.onRemoval();
        }
    }

    @Override
    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        int kind = nbttagcompound.f("Kind");
        this.pack = this.getPackage(kind);
        if (this.pack == null) {
            this.pack = this.getPackage(0);
        }
        this.machine = ((MachinePackage)this.pack).factory.createMachine(this);
        if (nbttagcompound.c("Machine")) {
            this.machine.readFromNBT(nbttagcompound.m("Machine"));
        }
        if (nbttagcompound.c("Boiler")) {
            this.machine.readFromNBT(nbttagcompound.m("Boiler"));
        }
    }

    @Override
    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        int kind = this.i.e(this.j, this.k, this.l);
        if (this.hasPackage(kind)) {
            nbttagcompound.a("Kind", kind);
        } else {
            nbttagcompound.a("Kind", 0);
        }
        if (this.machine != null) {
            ady NBTmachine = new ady();
            this.machine.writeToNBT(NBTmachine);
            nbttagcompound.a("Machine", (gh)NBTmachine);
        } else {
            ModLoader.getLogger().warning("Saved a " + this.getClass() + " without machine.");
        }
    }

    public boolean isWorking() {
        return this.machine.isWorking();
    }

    public int getChargeReceivedScaled(int i) {
        return this.energyReceived * i / this.powerProvider.maxEnergyReceived;
    }

    public static EnumTankLevel rateTankLevel(int scaled) {
        if (scaled < 5) {
            return EnumTankLevel.EMPTY;
        }
        if (scaled < 30) {
            return EnumTankLevel.LOW;
        }
        if (scaled < 60) {
            return EnumTankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return EnumTankLevel.HIGH;
        }
        return EnumTankLevel.MAXIMUM;
    }

    public boolean isIndirectlyPoweringTo(xd world, int i, int j, int k, int l) {
        if (this.machine != null) {
            return this.machine.isIndirectlyPoweringTo(world, i, j, k, l);
        }
        return false;
    }

    public boolean isPoweringTo(ali iblockaccess, int i, int j, int k, int l) {
        if (this.machine != null) {
            return this.machine.isPoweringTo(iblockaccess, i, j, k, l);
        }
        return false;
    }

    @Override
    public void doWork() {
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        if (this.i.w() % 5L * 10L != 0L) {
            return;
        }
        PluginBuildCraft.instance.invokeUseEnergyMethod(this.powerProvider, this.powerProvider.minActivationEnergy, this.powerProvider.minActivationEnergy, false);
        if (!this.machine.doWork()) {
            return;
        }
        PluginBuildCraft.instance.invokeUseEnergyMethod(this.powerProvider, this.powerProvider.minActivationEnergy, this.powerProvider.minActivationEnergy, true);
    }

    @Override
    public void setPowerProvider(PowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public PowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().maxEnergyReceived;
    }

    public int a() {
        if (this.machine != null) {
            return this.machine.a();
        }
        return 0;
    }

    public aan k_(int i) {
        if (this.machine != null) {
            return this.machine.k_(i);
        }
        return null;
    }

    public aan a(int i, int j) {
        if (this.machine != null) {
            return this.machine.a(i, j);
        }
        return null;
    }

    public void a(int i, aan itemstack) {
        if (this.machine != null) {
            this.machine.a(i, itemstack);
        }
    }

    public String c() {
        if (this.machine != null) {
            return this.machine.getName();
        }
        return "[Unknown]";
    }

    public int d() {
        if (this.machine != null) {
            return this.machine.d();
        }
        return 64;
    }

    public void e() {
    }

    public void f() {
    }

    public aan b(int slot) {
        if (this.machine != null) {
            return this.machine.b(slot);
        }
        return null;
    }

    public int getStartInventorySide(int side) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return 0;
        }
        if (this.machine != null) {
            return this.machine.getStartInventorySide(side);
        }
        return 0;
    }

    public int getSizeInventorySide(int side) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return 0;
        }
        if (this.machine != null) {
            return this.machine.getSizeInventorySide(side);
        }
        return 0;
    }

    @Override
    public int fill(Orientations from, int quantity, int id, boolean doFill) {
        if (this.machine != null) {
            return this.machine.fill(PluginBuildCraft.convertBuildCraftOrientation(from), quantity, id, doFill);
        }
        return 0;
    }

    @Override
    public int empty(int quantityMax, boolean doEmpty) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return 0;
        }
        if (this.machine != null) {
            return this.machine.empty(quantityMax, doEmpty);
        }
        return 0;
    }

    @Override
    public int getLiquidQuantity() {
        if (this.machine != null) {
            return this.machine.getLiquidQuantity();
        }
        return 0;
    }

    @Override
    public LiquidSlot[] getLiquidSlots() {
        if (this.machine != null) {
            return PluginBuildCraft.instance.convertToBCLiquidSlots(this.machine.getLiquidContents());
        }
        return new LiquidSlot[0];
    }

    @Override
    public TankSlot[] getLiquidTanks() {
        if (this.machine != null) {
            return this.machine.getLiquidContents();
        }
        return new TankSlot[0];
    }

    @Override
    public int getLiquidId() {
        if (this.machine != null) {
            return this.machine.getLiquidId();
        }
        return 0;
    }

    @Override
    public int getCapacity() {
        if (this.machine != null) {
            TankSlot[] slots = this.machine.getLiquidContents();
            if (slots == null) {
                return 0;
            }
            return slots[0].capacity;
        }
        return 0;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return false;
        }
        if (this.machine != null) {
            return this.machine.addItem(stack, doAdd, PluginBuildCraft.convertBuildCraftOrientation(from));
        }
        return false;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from, String owner) {
        return this.addItem(stack, doAdd, from);
    }

    @Override
    public boolean allowsInteraction(String username) {
        return this.isOwned() && this.getOwnerName().equals(username);
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return null;
        }
        if (this.machine != null) {
            return this.machine.extractItem(doRemove, PluginBuildCraft.convertBuildCraftOrientation(from));
        }
        return null;
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from, String owner) {
        return this.extractItem(doRemove, from);
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = null;
        if (this.machine != null) {
            payload = this.machine.getPacketPayload();
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        if (this.machine == null) {
            this.createMachine();
        }
        this.machine.fromPacketPayload(payload, new IndexInPayload(0, 0, 0));
    }

    public void onNeighborBlockChange() {
        if (this.machine == null) {
            return;
        }
        this.machine.onNeighborBlockChange();
    }

    @Override
    public boolean emitsEnergyTo(kw receiver, Direction direction) {
        if (this.machine != null) {
            return this.machine.emitsEnergyTo(receiver, direction);
        }
        return false;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        if (this.machine != null) {
            return this.machine.isAddedToEnergyNet();
        }
        return false;
    }

    @Override
    public int getMaxEnergyOutput() {
        if (this.machine != null) {
            return this.machine.getMaxEnergyOutput();
        }
        return 0;
    }

    @Override
    public LinkedList getCustomTriggers() {
        if (this.machine != null) {
            return this.machine.getCustomTriggers();
        }
        return null;
    }

    @Override
    public void performAction(kw entity) {
        if (this.machine != null) {
            this.machine.performAction(entity);
        }
    }

    @Override
    public boolean consumesEnergy() {
        return this.powerProvider.maxEnergyReceived > 0;
    }

    @Override
    public float getMaxEnergyStored() {
        return this.powerProvider.maxEnergyStored;
    }

    @Override
    public float getEnergyStored() {
        return this.powerProvider.energyStored;
    }

    @Override
    public float getMaxEnergyReceived() {
        return this.powerProvider.maxEnergyReceived;
    }
}

