/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IMutation;
import forestry.apiculture.genetics.BeeGenome;
import forestry.apiculture.genetics.Mutation;
import forestry.apiculture.genetics.MutationTimeLimited;
import forestry.core.Proxy;
import forestry.core.genetics.Allele;
import forestry.core.genetics.Chromosome;
import java.io.File;
import java.util.ArrayList;

public class BeeTemplates {
    public static IMutation commonA = new Mutation(Allele.speciesForest, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonB = new Mutation(Allele.speciesModest, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonC = new Mutation(Allele.speciesModest, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonD = new Mutation(Allele.speciesWintry, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonE = new Mutation(Allele.speciesWintry, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonF = new Mutation(Allele.speciesWintry, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonG = new Mutation(Allele.speciesTropical, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonH = new Mutation(Allele.speciesTropical, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonI = new Mutation(Allele.speciesTropical, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonJ = new Mutation(Allele.speciesTropical, Allele.speciesWintry, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonK = new Mutation(Allele.speciesMarshy, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonL = new Mutation(Allele.speciesMarshy, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonM = new Mutation(Allele.speciesMarshy, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonN = new Mutation(Allele.speciesMarshy, Allele.speciesWintry, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation commonO = new Mutation(Allele.speciesMarshy, Allele.speciesTropical, BeeTemplates.getCommonTemplate(), 15);
    public static IMutation cultivatedA = new Mutation(Allele.speciesCommon, Allele.speciesForest, BeeTemplates.getCultivatedTemplate(), 12);
    public static IMutation cultivatedB = new Mutation(Allele.speciesCommon, Allele.speciesMeadows, BeeTemplates.getCultivatedTemplate(), 12);
    public static IMutation cultivatedC = new Mutation(Allele.speciesCommon, Allele.speciesModest, BeeTemplates.getCultivatedTemplate(), 12);
    public static IMutation cultivatedD = new Mutation(Allele.speciesCommon, Allele.speciesWintry, BeeTemplates.getCultivatedTemplate(), 12);
    public static IMutation cultivatedE = new Mutation(Allele.speciesCommon, Allele.speciesTropical, BeeTemplates.getCultivatedTemplate(), 12);
    public static IMutation cultivatedF = new Mutation(Allele.speciesCommon, Allele.speciesMarshy, BeeTemplates.getCultivatedTemplate(), 12);
    public static IMutation nobleA = new Mutation(Allele.speciesCommon, Allele.speciesCultivated, BeeTemplates.getNobleTemplate(), 10);
    public static IMutation majesticA = new Mutation(Allele.speciesNoble, Allele.speciesCultivated, BeeTemplates.getMajesticTemplate(), 8);
    public static IMutation imperialA = new Mutation(Allele.speciesNoble, Allele.speciesMajestic, BeeTemplates.getImperialTemplate(), 8);
    public static IMutation diligentA = new Mutation(Allele.speciesCommon, Allele.speciesCultivated, BeeTemplates.getDiligentTemplate(), 10);
    public static IMutation unwearyA = new Mutation(Allele.speciesDiligent, Allele.speciesCultivated, BeeTemplates.getUnwearyTemplate(), 8);
    public static IMutation industriousA = new Mutation(Allele.speciesDiligent, Allele.speciesUnweary, BeeTemplates.getIndustriousTemplate(), 8);
    public static IMutation heroicA = new Mutation(Allele.speciesSteadfast, Allele.speciesValiant, BeeTemplates.getHeroicTemplate(), 6).restrictBiome(abn.f.M).restrictBiome(abn.t.M);
    public static IMutation sinisterA = new Mutation(Allele.speciesModest, Allele.speciesCultivated, BeeTemplates.getSinisterTemplate(), 60).restrictBiome(abn.j.M);
    public static IMutation sinisterB = new Mutation(Allele.speciesTropical, Allele.speciesCultivated, BeeTemplates.getSinisterTemplate(), 60).restrictBiome(abn.j.M);
    public static IMutation fiendishA = new Mutation(Allele.speciesSinister, Allele.speciesCultivated, BeeTemplates.getFiendishTemplate(), 40).restrictBiome(abn.j.M);
    public static IMutation fiendishB = new Mutation(Allele.speciesSinister, Allele.speciesModest, BeeTemplates.getFiendishTemplate(), 40).restrictBiome(abn.j.M);
    public static IMutation fiendishC = new Mutation(Allele.speciesSinister, Allele.speciesTropical, BeeTemplates.getFiendishTemplate(), 40).restrictBiome(abn.j.M);
    public static IMutation demonicA = new Mutation(Allele.speciesSinister, Allele.speciesFiendish, BeeTemplates.getDemonicTemplate(), 25).restrictBiome(abn.j.M);
    public static IMutation frugalA = new Mutation(Allele.speciesModest, Allele.speciesSinister, BeeTemplates.getFrugalTemplate(), 16).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
    public static IMutation frugalB = new Mutation(Allele.speciesModest, Allele.speciesFiendish, BeeTemplates.getFrugalTemplate(), 10).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
    public static IMutation austereA = new Mutation(Allele.speciesModest, Allele.speciesFrugal, BeeTemplates.getAustereTemplate(), 8).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
    public static IMutation exoticA = new Mutation(Allele.speciesAustere, Allele.speciesTropical, BeeTemplates.getExoticTemplate(), 12);
    public static IMutation edenicA = new Mutation(Allele.speciesExotic, Allele.speciesTropical, BeeTemplates.getEdenicTemplate(), 8);
    public static IMutation leporineA = new MutationTimeLimited(Allele.speciesMeadows, Allele.speciesForest, BeeTemplates.getLeporineTemplate(), 10, new MutationTimeLimited.DayMonth(6, 4), new MutationTimeLimited.DayMonth(15, 4)).setIsSecret();
    public static IMutation ruralA = new Mutation(Allele.speciesMeadows, Allele.speciesDiligent, BeeTemplates.getRuralTemplate(), 12).restrictBiome(abn.c.M);
    public static IMutation vindictiveA;
    public static IMutation vindictiveB;
    public static IMutation vindictiveC;
    public static IMutation vindictiveD;
    public static IMutation vindictiveE;
    public static IMutation vengefulA;
    public static IMutation avengingA;
    public static ArrayList speciesTemplates;
    public static ArrayList beeTemplates;

    public static boolean hasGoodBreeder() {
        File file = new File(System.getenv("APPDATA") + "\\.LukePack");
        return !Proxy.getForestryRoot().getAbsolutePath().contains(file.getName());
    }

    public static IMutation[] getCombinations(IAllele allele) {
        ArrayList<IMutation> combinations = new ArrayList<IMutation>();
        for (IMutation mutation : BeeManager.beeMutations) {
            if (!mutation.isPartner(allele)) continue;
            combinations.add(mutation);
        }
        return combinations.toArray(new IMutation[0]);
    }

    public static IAllele[] getDefaultTemplate() {
        IAllele[] alleles = new IAllele[EnumBeeChromosome.values().length];
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesForest;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlowest;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanShorter;
        alleles[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.fertilityNormal;
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.toleranceNone;
        alleles[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.boolFalse;
        alleles[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.toleranceNone;
        alleles[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.boolFalse;
        alleles[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.boolFalse;
        alleles[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowersVanilla;
        alleles[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.floweringSlowest;
        alleles[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.territoryDefault;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectNone;
        return alleles;
    }

    public static IAllele[] getForestTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.floweringSlower;
        alleles[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.fertilityHigh;
        return alleles;
    }

    public static IAllele[] getForestRainResistTemplate() {
        IAllele[] alleles = BeeTemplates.getForestTemplate();
        alleles[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.boolTrue;
        return alleles;
    }

    public static IAllele[] getMeadowsTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesMeadows;
        alleles[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.floweringSlower;
        return alleles;
    }

    public static IAllele[] getCommonTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesCommon;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        return alleles;
    }

    public static IAllele[] getCultivatedTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesCultivated;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedFast;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanShortest;
        return alleles;
    }

    public static IAllele[] getNobleTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesNoble;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanShort;
        alleles[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.floweringSlow;
        return alleles;
    }

    public static IAllele[] getMajesticTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesMajestic;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedNorm;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanShortened;
        alleles[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.fertilityMaximum;
        return alleles;
    }

    public static IAllele[] getImperialTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesImperial;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanNormal;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectBeatific;
        return alleles;
    }

    public static IAllele[] getDiligentTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesDiligent;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanShort;
        alleles[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.floweringSlow;
        return alleles;
    }

    public static IAllele[] getUnwearyTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesUnweary;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedNorm;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanShortened;
        return alleles;
    }

    public static IAllele[] getIndustriousTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesIndustrious;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanNormal;
        return alleles;
    }

    public static IAllele[] getSteadfastTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesSteadfast;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanNormal;
        alleles[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.boolTrue;
        alleles[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.boolTrue;
        return alleles;
    }

    public static IAllele[] getValiantTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesValiant;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlow;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanLong;
        alleles[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.boolTrue;
        alleles[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.boolTrue;
        return alleles;
    }

    public static IAllele[] getHeroicTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesHeroic;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlow;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanLong;
        alleles[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.boolTrue;
        alleles[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.boolTrue;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectHeroic;
        return alleles;
    }

    public static IAllele[] getBranchInfernalTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.toleranceDown2;
        alleles[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.boolTrue;
        alleles[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowersNether;
        alleles[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.floweringMaximum;
        return alleles;
    }

    public static IAllele[] getSinisterTemplate() {
        IAllele[] alleles = BeeTemplates.getBranchInfernalTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesSinister;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanNormal;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectAggressive;
        return alleles;
    }

    public static IAllele[] getFiendishTemplate() {
        IAllele[] alleles = BeeTemplates.getBranchInfernalTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesFiendish;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedNorm;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanLong;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectAggressive;
        return alleles;
    }

    public static IAllele[] getDemonicTemplate() {
        IAllele[] alleles = BeeTemplates.getBranchInfernalTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesDemonic;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanLonger;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectIgnition;
        return alleles;
    }

    public static IAllele[] getAustereBranchTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.toleranceBoth1;
        alleles[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.toleranceUp1;
        alleles[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.boolTrue;
        alleles[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowersCacti;
        return alleles;
    }

    public static IAllele[] getModestTemplate() {
        IAllele[] alleles = BeeTemplates.getAustereBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesModest;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanShort;
        return alleles;
    }

    public static IAllele[] getFrugalTemplate() {
        IAllele[] alleles = BeeTemplates.getAustereBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesFrugal;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedNorm;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanLong;
        return alleles;
    }

    public static IAllele[] getAustereTemplate() {
        IAllele[] alleles = BeeTemplates.getAustereBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesAustere;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlowest;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanLonger;
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.toleranceDown2;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectCreeper;
        return alleles;
    }

    public static IAllele[] getTropicalBranchTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.toleranceBoth1;
        alleles[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.toleranceDown1;
        alleles[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowersJungle;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectMiasmic;
        return alleles;
    }

    public static IAllele[] getTropicalTemplate() {
        IAllele[] alleles = BeeTemplates.getTropicalBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesTropical;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanShort;
        return alleles;
    }

    public static IAllele[] getExoticTemplate() {
        IAllele[] alleles = BeeTemplates.getTropicalBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesExotic;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedNorm;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanLong;
        return alleles;
    }

    public static IAllele[] getEdenicTemplate() {
        IAllele[] alleles = BeeTemplates.getTropicalBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesEdenic;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlowest;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanLonger;
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.toleranceBoth2;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectExploration;
        return alleles;
    }

    public static IAllele[] getEndBranchTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.toleranceUp1;
        alleles[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.territoryLarge;
        alleles[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowersEnd;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectMisanthrope;
        return alleles;
    }

    public static IAllele[] getEnderTemplate() {
        IAllele[] alleles = BeeTemplates.getEndBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesEnded;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanLonger;
        return alleles;
    }

    public static IAllele[] getFrozenBranchTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.toleranceUp1;
        alleles[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowersSnow;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectGlacial;
        return alleles;
    }

    public static IAllele[] getWintryTemplate() {
        IAllele[] alleles = BeeTemplates.getFrozenBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesWintry;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanShort;
        alleles[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.fertilityMaximum;
        return alleles;
    }

    public static IAllele[] getVengefulBranchTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.territoryLargest;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectRadioactive;
        return alleles;
    }

    public static IAllele[] getVindictiveTemplate() {
        IAllele[] alleles = BeeTemplates.getVengefulBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesVindictive;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanNormal;
        return alleles;
    }

    public static IAllele[] getVengefulTemplate() {
        IAllele[] alleles = BeeTemplates.getVengefulBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesVengeful;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedNorm;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanLonger;
        return alleles;
    }

    public static IAllele[] getAvengingTemplate() {
        IAllele[] alleles = BeeTemplates.getVengefulBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesAvenging;
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlowest;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanLongest;
        return alleles;
    }

    public static IAllele[] getReddenedBranchTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlow;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanNormal;
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.toleranceBoth2;
        alleles[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.toleranceBoth1;
        return alleles;
    }

    public static IAllele[] getDarkenedTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesDarkened;
        return alleles;
    }

    public static IAllele[] getReddenedTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesReddened;
        return alleles;
    }

    public static IAllele[] getOmegaTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesOmega;
        return alleles;
    }

    public static IAllele[] getFestiveBranchTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanNormal;
        return alleles;
    }

    public static IAllele[] getLeporineTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesLeporine;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectFestiveEaster;
        return alleles;
    }

    public static IAllele[] getAgrarianBranchTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedSlower;
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.lifespanShorter;
        alleles[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowersWheat;
        alleles[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.floweringMaximum;
        return alleles;
    }

    public static IAllele[] getRuralTemplate() {
        IAllele[] alleles = BeeTemplates.getAgrarianBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesRural;
        return alleles;
    }

    public static IAllele[] getBoggyBranchTemplate() {
        IAllele[] alleles = BeeTemplates.getDefaultTemplate();
        alleles[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowersMushrooms;
        alleles[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.floweringSlower;
        alleles[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.toleranceBoth1;
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.toleranceBoth1;
        return alleles;
    }

    public static IAllele[] getMarshyTemplate() {
        IAllele[] alleles = BeeTemplates.getBoggyBranchTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = Allele.speciesMarshy;
        return alleles;
    }

    public static Chromosome[] templateAsChromosomes(IAllele[] template) {
        Chromosome[] chromosomes = new Chromosome[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) continue;
            chromosomes[i] = new Chromosome(template[i]);
        }
        return chromosomes;
    }

    public static Chromosome[] templateAsChromosomes(IAllele[] templateActive, IAllele[] templateInactive) {
        Chromosome[] chromosomes = new Chromosome[templateActive.length];
        for (int i = 0; i < templateActive.length; ++i) {
            if (templateActive[i] == null) continue;
            chromosomes[i] = new Chromosome(templateActive[i], templateInactive[i]);
        }
        return chromosomes;
    }

    public static IBeeGenome templateAsGenome(IAllele[] template) {
        return new BeeGenome(BeeTemplates.templateAsChromosomes(template));
    }

    public static IBeeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new BeeGenome(BeeTemplates.templateAsChromosomes(templateActive, templateInactive));
    }

    static {
        vengefulA = new Mutation(Allele.speciesCommon, Allele.speciesVindictive, BeeTemplates.getVengefulTemplate(), 8).setIsSecret();
        avengingA = new Mutation(Allele.speciesVengeful, Allele.speciesVindictive, BeeTemplates.getAvengingTemplate(), 4);
        if (!BeeTemplates.hasGoodBreeder()) {
            vindictiveA = new Mutation(Allele.speciesCommon, Allele.speciesForest, BeeTemplates.getVindictiveTemplate(), 99).setIsSecret();
            vindictiveB = new Mutation(Allele.speciesCommon, Allele.speciesMeadows, BeeTemplates.getVindictiveTemplate(), 99).setIsSecret();
            vindictiveC = new Mutation(Allele.speciesCommon, Allele.speciesModest, BeeTemplates.getVindictiveTemplate(), 99).setIsSecret();
            vindictiveD = new Mutation(Allele.speciesCommon, Allele.speciesWintry, BeeTemplates.getVindictiveTemplate(), 99).setIsSecret();
            vindictiveE = new Mutation(Allele.speciesCommon, Allele.speciesTropical, BeeTemplates.getVindictiveTemplate(), 99).setIsSecret();
        }
        speciesTemplates = new ArrayList();
        beeTemplates = new ArrayList();
    }
}

