/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api;

import buildcraft.api.IPowerReceptor;
import buildcraft.api.SafeTimeTracker;
import buildcraft.api.TileNetworkData;

public abstract class PowerProvider {
    public int latency;
    public int minEnergyReceived;
    public int maxEnergyReceived;
    public int maxEnergyStored;
    public int minActivationEnergy;
    @TileNetworkData
    public int energyStored = 0;
    protected int powerLoss = 1;
    protected int powerLossRegularity = 100;
    public SafeTimeTracker timeTracker = new SafeTimeTracker();
    public SafeTimeTracker energyLossTracker = new SafeTimeTracker();

    public void configure(int latency, int minEnergyReceived, int maxEnergyReceived, int minActivationEnergy, int maxStoredEnergy) {
        this.latency = latency;
        this.minEnergyReceived = minEnergyReceived;
        this.maxEnergyReceived = maxEnergyReceived;
        this.maxEnergyStored = maxStoredEnergy;
        this.minActivationEnergy = minActivationEnergy;
    }

    public void configurePowerPerdition(int powerLoss, int powerLossRegularity) {
        this.powerLoss = powerLoss;
        this.powerLossRegularity = powerLossRegularity;
    }

    public final boolean update(IPowerReceptor receptor) {
        if (!this.preConditions(receptor)) {
            return false;
        }
        kw tile = (kw)receptor;
        boolean result = false;
        if (this.energyStored >= this.minActivationEnergy) {
            if (this.latency == 0) {
                receptor.doWork();
                result = true;
            } else if (this.timeTracker.markTimeIfDelay(tile.i, this.latency)) {
                receptor.doWork();
                result = true;
            }
        }
        if (this.powerLoss > 0 && this.energyLossTracker.markTimeIfDelay(tile.i, this.powerLossRegularity)) {
            this.energyStored -= this.powerLoss;
            if (this.energyStored < 0) {
                this.energyStored = 0;
            }
        }
        return result;
    }

    public boolean preConditions(IPowerReceptor receptor) {
        return true;
    }

    public int useEnergy(int min, int max, boolean doUse) {
        int result = 0;
        if (this.energyStored >= min) {
            if (this.energyStored <= max) {
                result = this.energyStored;
                if (doUse) {
                    this.energyStored = 0;
                }
            } else {
                result = max;
                if (doUse) {
                    this.energyStored -= max;
                }
            }
        }
        return result;
    }

    public void readFromNBT(ady nbttagcompound) {
        this.latency = nbttagcompound.f("latency");
        this.minEnergyReceived = nbttagcompound.f("minEnergyReceived");
        this.maxEnergyReceived = nbttagcompound.f("maxEnergyReceived");
        this.maxEnergyStored = nbttagcompound.f("maxStoreEnergy");
        this.minActivationEnergy = nbttagcompound.f("minActivationEnergy");
        this.energyStored = nbttagcompound.f("storedEnergy");
    }

    public void writeToNBT(ady nbttagcompound) {
        nbttagcompound.a("latency", this.latency);
        nbttagcompound.a("minEnergyReceived", this.minEnergyReceived);
        nbttagcompound.a("maxEnergyReceived", this.maxEnergyReceived);
        nbttagcompound.a("maxStoreEnergy", this.maxEnergyStored);
        nbttagcompound.a("minActivationEnergy", this.minActivationEnergy);
        nbttagcompound.a("storedEnergy", this.energyStored);
    }

    public void receiveEnergy(int quantity) {
        this.energyStored += quantity;
        if (this.energyStored > this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }
}

