/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation;

import buildcraft.api.Orientations;
import forestry.core.ForestryClient;
import forestry.core.interfaces.IBlockRenderer;
import forestry.cultivation.TilePlanter;
import forge.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderPlanter
implements IBlockRenderer {
    private ho model = new ho(){};
    private String gfxBase;
    private qp base = new qp(this.model, 0, 0);
    private qp ceiling;
    private qp terrarium;
    private qp showcase;

    public RenderPlanter() {
        this.base.a(-8.0f, 4.0f, -8.0f, 16, 4, 16);
        this.base.c = 8.0f;
        this.base.d = 8.0f;
        this.base.e = 8.0f;
        this.ceiling = new qp(this.model, 0, 0);
        this.ceiling.a(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.ceiling.c = 8.0f;
        this.ceiling.d = 8.0f;
        this.ceiling.e = 8.0f;
        this.terrarium = new qp(this.model, 0, 0);
        this.terrarium.a(-6.0f, -7.0f, -6.0f, 12, 12, 12);
        this.terrarium.c = 8.0f;
        this.terrarium.d = 8.0f;
        this.terrarium.e = 8.0f;
        this.showcase = new qp(this.model, 0, 0);
        this.showcase.a(-4.0f, -4.0f, -4.0f, 8, 8, 8);
        this.showcase.c = 8.0f;
        this.showcase.d = 8.0f;
        this.showcase.e = 8.0f;
    }

    public RenderPlanter(String baseTexture) {
        this();
        this.gfxBase = baseTexture;
    }

    @Override
    public void preloadTextures() {
        ForestryClient.preloadTexture(this.gfxBase + "base.png");
        ForestryClient.preloadTexture(this.gfxBase + "ceiling.png");
        ForestryClient.preloadTexture(this.gfxBase + "terrarium.png");
        ForestryClient.preloadTexture(this.gfxBase + "showcase.png");
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(Orientations.YPos, this.gfxBase, x, y, z);
    }

    @Override
    public void renderTileEntityAt(kw tileentity, double d, double d1, double d2, float f) {
        TilePlanter planter = (TilePlanter)tileentity;
        if (planter.machine != null) {
            this.render(planter.getOrientation(), this.gfxBase, d, d1, d2);
        }
    }

    private void render(Orientations orientation, String gfxBase, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        switch (orientation) {
            case XPos: {
                translate[1] = 1.0f;
                break;
            }
            case XNeg: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case YPos: {
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case YNeg: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case ZPos: {
                angle[0] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            case ZNeg: {
                angle[0] = -1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.base.f = angle[0];
        this.base.g = angle[1];
        this.base.h = angle[2];
        this.ceiling.f = angle[0];
        this.ceiling.g = angle[1];
        this.ceiling.h = angle[2];
        this.terrarium.f = angle[0];
        this.terrarium.g = angle[1];
        this.terrarium.h = angle[2];
        this.showcase.f = angle[0];
        this.showcase.g = angle[1];
        this.showcase.h = angle[2];
        float factor = 0.0625f;
        MinecraftForgeClient.bindTexture((String)(gfxBase + "base.png"));
        this.base.a(factor);
        MinecraftForgeClient.bindTexture((String)(gfxBase + "ceiling.png"));
        this.ceiling.a(factor);
        MinecraftForgeClient.bindTexture((String)(gfxBase + "terrarium.png"));
        this.terrarium.a(factor);
        MinecraftForgeClient.bindTexture((String)(gfxBase + "showcase.png"));
        this.showcase.a(factor);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

