/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.utils.StructureBlueprint;
import forestry.core.utils.Vect;

public class StructureConstruction {
    private StructureBlueprint blueprint;
    private Vect position;
    private Vect shift;
    private Vect current = new Vect(0, 0, 0);
    public boolean isFinished = false;

    public StructureConstruction() {
    }

    public StructureConstruction(StructureBlueprint bp, Vect p, Vect s) {
        this.blueprint = bp;
        this.position = p;
        this.shift = s;
    }

    public int getCurrentBlockId() {
        return this.blueprint.getBlockId(this.current);
    }

    public int getCurrentY() {
        return this.position.y + this.current.y + this.shift.y;
    }

    public int getCurrentX() {
        return this.position.x + this.current.x + this.shift.x;
    }

    public int getCurrentZ() {
        return this.position.z + this.current.z + this.shift.z;
    }

    public Vect getCurrentPos() {
        return new Vect(this.getCurrentX(), this.getCurrentY(), this.getCurrentZ());
    }

    public void advanceStep() {
        if (this.current.z < this.blueprint.getZLength() - 1) {
            ++this.current.z;
        } else {
            this.current.z = 0;
            if (this.current.x < this.blueprint.getXLength() - 1) {
                ++this.current.x;
            } else {
                this.current.x = 0;
                if (this.current.y < this.blueprint.getYLength() - 1) {
                    ++this.current.y;
                } else {
                    this.isFinished = true;
                }
            }
        }
    }

    public void reset() {
        this.current = new Vect(0, 0, 0);
        this.isFinished = false;
    }

    public void readFromNBT(ady nbttagcompound) {
        String ident;
        this.isFinished = nbttagcompound.o("IsFinished");
        if (nbttagcompound.c("BlueprintIdent")) {
            ident = nbttagcompound.j("BlueprintIdent");
        } else {
            int id = nbttagcompound.f("BlueprintId");
            switch (id) {
                case 0: {
                    ident = "defaultArboretum";
                    break;
                }
                case 1: {
                    ident = "saplingSoil";
                    break;
                }
                case 2: {
                    ident = "saplingPlantation";
                    break;
                }
                case 3: {
                    ident = "wheatSoil";
                    break;
                }
                case 4: {
                    ident = "wheatPlantation";
                    break;
                }
                default: {
                    ident = "defaultArboretum";
                }
            }
        }
        if (StructureBlueprint.index.containsKey(ident)) {
            this.blueprint = (StructureBlueprint)StructureBlueprint.index.get(ident);
        } else {
            ModLoader.getLogger().severe("Tried to load non-existing structure blueprint identified by " + ident);
        }
        this.position = new Vect(nbttagcompound.f("XPosition"), nbttagcompound.f("YPosition"), nbttagcompound.f("ZPosition"));
        this.shift = new Vect(nbttagcompound.f("XShift"), nbttagcompound.f("YShift"), nbttagcompound.f("ZShift"));
        this.current = new Vect(nbttagcompound.f("XCurrent"), nbttagcompound.f("YCurrent"), nbttagcompound.f("ZCurrent"));
    }

    public void writeToNBT(ady nbttagcompound) {
        nbttagcompound.a("IsFinished", this.isFinished);
        nbttagcompound.a("BlueprintIdent", this.blueprint.id);
        nbttagcompound.a("XPosition", this.position.x);
        nbttagcompound.a("YPosition", this.position.y);
        nbttagcompound.a("ZPosition", this.position.z);
        nbttagcompound.a("XShift", this.shift.x);
        nbttagcompound.a("YShift", this.shift.y);
        nbttagcompound.a("ZShift", this.shift.z);
        nbttagcompound.a("XCurrent", this.current.x);
        nbttagcompound.a("YCurrent", this.current.y);
        nbttagcompound.a("ZCurrent", this.current.z);
    }
}

