/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IResupplyHandler;
import forestry.core.ForestryCore;
import forestry.core.GuiHandler;
import forestry.core.RenderForestryTile;
import forestry.core.TextureBiofuelFX;
import forestry.core.TextureBiomassFX;
import forestry.core.TextureGlassFX;
import forestry.core.TextureHabitatLocatorFX;
import forestry.core.TextureHoneyFX;
import forestry.core.TextureJuiceFX;
import forestry.core.TextureMeadFX;
import forestry.core.TileRendererIndex;
import forestry.core.gadgets.TileEngine;
import forestry.core.gadgets.TileMachine;
import forestry.core.gadgets.TileMill;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.network.ConnectionHandler;
import forestry.factory.TextureMilkFX;
import forestry.factory.TextureSeedOilFX;
import forestry.plugins.PluginManager;
import forge.IConnectionHandler;
import forge.IGuiHandler;
import forge.MinecraftForge;
import forge.MinecraftForgeClient;
import forge.NetworkMod;
import java.util.HashMap;
import net.minecraft.client.Minecraft;

public class ForestryClient {
    public static int byBlockModelId;
    public static int blockModelIdEngine;
    public static int blockModelIdMelange;
    public static HashMap byBlockRenderer;

    public static void load(NetworkMod basemod) {
        ForestryCore.load(basemod);
        byBlockModelId = ModLoader.getUniqueBlockModelID((BaseMod)basemod, (boolean)true);
        blockModelIdEngine = ModLoader.getUniqueBlockModelID((BaseMod)basemod, (boolean)true);
        blockModelIdMelange = ModLoader.getUniqueBlockModelID((BaseMod)basemod, (boolean)true);
        MinecraftForge.setGuiHandler((BaseMod)basemod, (IGuiHandler)new GuiHandler());
        MinecraftForge.registerConnectionHandler((IConnectionHandler)new ConnectionHandler());
        ForestryClient.preloadTexture("/gfx/forestry/blocks/blocks.png");
        ForestryClient.preloadTexture("/gfx/forestry/items/items.png");
        ForestryClient.preloadTexture("/gfx/forestry/items/crated.png");
        ForestryClient.preloadTexture("/gfx/forestry/items/bees.png");
        ForestryClient.preloadTexture("/gfx/forestry/gui/errors.png");
        ForestryClient.preloadTexture("/gfx/forestry/gui/triggers.png");
        ModLoader.registerTileEntity(TileMill.class, (String)"forestry.Grower");
        ModLoader.registerTileEntity(TileEngine.class, (String)"forestry.Engine", (aar)new RenderForestryTile());
        ModLoader.registerTileEntity(TileMachine.class, (String)"forestry.Machine", (aar)new RenderForestryTile());
    }

    public static void modsLoaded() {
        ForestryCore.modsLoaded();
        ModLoader.getMinecraftInstance().p.a((tt)new TextureBiomassFX());
        ModLoader.getMinecraftInstance().p.a((tt)new TextureBiofuelFX());
        ModLoader.getMinecraftInstance().p.a((tt)new TextureMilkFX());
        ModLoader.getMinecraftInstance().p.a((tt)new TextureHoneyFX());
        ModLoader.getMinecraftInstance().p.a((tt)new TextureSeedOilFX());
        ModLoader.getMinecraftInstance().p.a((tt)new TextureJuiceFX());
        ModLoader.getMinecraftInstance().p.a((tt)new TextureMeadFX());
        ModLoader.getMinecraftInstance().p.a((tt)new TextureGlassFX());
        ModLoader.getMinecraftInstance().p.a((tt)new TextureHabitatLocatorFX(ModLoader.getMinecraftInstance()));
        ModLoader.setInGameHook((BaseMod)ForestryAPI.instance, (boolean)true, (boolean)true);
    }

    public static boolean onTickInGame(float tick, Minecraft minecraft) {
        for (IResupplyHandler handler : PluginManager.resupplyHandlers) {
            handler.resupply((yw)minecraft.h);
        }
        return true;
    }

    public static void renderInvBlock(vl renderblocks, pb block, int i, int j) {
        if (block.d() == byBlockModelId) {
            TileRendererIndex index = new TileRendererIndex(block, i);
            if (byBlockRenderer.containsKey(index)) {
                ((IBlockRenderer)byBlockRenderer.get(index)).inventoryRender(-0.5, -0.5, -0.5, 0.0f, 0.0f);
            } else {
                ((IBlockRenderer)byBlockRenderer.get(new TileRendererIndex(block, 0))).inventoryRender(-0.5, -0.5, -0.5, 0.0f, 0.0f);
            }
        }
    }

    public static void preloadTexture(String filename) {
        MinecraftForgeClient.preloadTexture((String)filename);
    }

    static {
        byBlockRenderer = new HashMap();
    }
}

