/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.core.utils.Vect;

public class AlleleEffectGlacial
extends AlleleEffectThrottled {
    public AlleleEffectGlacial(int id) {
        super(id, false);
    }

    @Override
    public int getThrottle() {
        return 200;
    }

    @Override
    public boolean isCombinable() {
        return false;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, xd world, int biomeid, int x, int y, int z) {
        if (this.isThrottled(storedData)) {
            return storedData;
        }
        if (EnumTemperature.hellishBiomeIds.contains(biomeid)) {
            return storedData;
        }
        if (EnumTemperature.hotBiomeIds.contains(biomeid)) {
            return storedData;
        }
        if (EnumTemperature.warmBiomeIds.contains(biomeid)) {
            return storedData;
        }
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        for (int i = 0; i < 10; ++i) {
            Vect randomPos = new Vect(world.r.nextInt(area.x), world.r.nextInt(area.y), world.r.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(x, y, z));
            posBlock = posBlock.add(offset);
            int blockid = world.a(posBlock.x, posBlock.y, posBlock.z);
            if (blockid != pb.B.bO || !world.i(posBlock.x, posBlock.y + 1, posBlock.z)) continue;
            world.g(posBlock.x, posBlock.y, posBlock.z, pb.aT.bO);
        }
        return storedData;
    }

    @Override
    public String getIdentifier() {
        return "apiculture.effect.glacial";
    }
}

