/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ReflectionCache {
    private HashMap classes = new HashMap();
    private HashMap methods = new HashMap();
    private HashMap fields = new HashMap();

    public boolean isInstance(Object obj, String name) {
        Class clazz = (Class)this.classes.get(name);
        return clazz.isInstance(obj);
    }

    public Object invokeMethod(Object obj, String name, Object ... args) throws InvocationTargetException {
        Method method = (Method)this.methods.get(name);
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            ModLoader.throwException((String)"Invoking method in MouseTweaks' reflection", (Throwable)e);
            return null;
        }
    }

    public Object getFieldValue(Object obj, String name) {
        Field field = (Field)this.fields.get(name);
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            ModLoader.throwException((String)"Getting field value in MouseTweaks' reflection", (Throwable)e);
            return null;
        }
    }

    public void setFieldValue(Object obj, String name, Object value) {
        Field field = (Field)this.fields.get(name);
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            ModLoader.throwException((String)"Setting field value in MouseTweaks' reflection", (Throwable)e);
        }
    }

    void storeClass(String name, Class clazz) {
        this.classes.put(name, clazz);
    }

    void storeMethod(String name, Method method) {
        this.methods.put(name, method);
    }

    void storeField(String name, Field field) {
        this.fields.put(name, field);
    }
}

