/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import yalter.mousetweaks.Constants;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.ObfuscatedName;
import yalter.mousetweaks.Obfuscation;
import yalter.mousetweaks.ReflectionCache;

public class Reflection {
    private static Obfuscation obfuscation;
    private static boolean checkObfuscation;
    private static HashMap HMCCache;
    public static ReflectionCache guiContainerClass;

    static void reflectGuiContainer() {
        Logger.Log("Reflecting GuiContainer...");
        guiContainerClass = new ReflectionCache();
        try {
            Method m = Reflection.getMethod(gb.class, Reflection.getObfuscatedName(Constants.GETSLOTATPOSITION_NAME), Integer.TYPE, Integer.TYPE);
            guiContainerClass.storeMethod(Constants.GETSLOTATPOSITION_NAME.forgeName, m);
        }
        catch (NoSuchMethodException e) {
            Logger.Log("Could not retrieve GuiContainer.getSlotAtPosition().");
            guiContainerClass = null;
            return;
        }
        Logger.Log("Success.");
    }

    public static Method getHMCMethod(gb object) {
        if (HMCCache.containsKey(object.getClass())) {
            return (Method)HMCCache.get(object.getClass());
        }
        try {
            Method method = Reflection.searchMethod(object.getClass(), Reflection.getObfuscatedName(Constants.HANDLEMOUSECLICK_NAME), yu.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            Logger.DebugLog("Found handleMouseClick() for " + object.getClass().getSimpleName() + ", caching.");
            HMCCache.put(object.getClass(), method);
            return method;
        }
        catch (NoSuchMethodException e) {
            ModLoader.throwException((String)"MouseTweaks could not find handleMouseClick() in a GuiContainer.", (Throwable)e);
            return null;
        }
    }

    static boolean doesClassExist(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Field getField(Class clazz, String name) throws NoSuchFieldException {
        Field field;
        try {
            field = clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            field = clazz.getDeclaredField(name);
        }
        field.setAccessible(true);
        return field;
    }

    private static Method getMethod(Class clazz, String name, Class ... args) throws NoSuchMethodException {
        Method method;
        try {
            method = clazz.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            method = clazz.getDeclaredMethod(name, args);
        }
        method.setAccessible(true);
        return method;
    }

    private static Method searchMethod(Class clazz, String name, Class ... args) throws NoSuchMethodException {
        while (true) {
            try {
                Method method = clazz.getDeclaredMethod(name, args);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new NoSuchMethodException();
            }
            break;
        }
    }

    private static String getObfuscatedName(ObfuscatedName obfuscatedName) {
        if (checkObfuscation) {
            Reflection.checkObfuscation();
        }
        return obfuscatedName.get(obfuscation);
    }

    private static void checkObfuscation() {
        checkObfuscation = false;
        try {
            Reflection.getMethod(gb.class, Constants.GETSLOTATPOSITION_NAME.mcpName, Integer.TYPE, Integer.TYPE);
            obfuscation = Obfuscation.MCP;
        }
        catch (NoSuchMethodException e) {
            try {
                Reflection.getMethod(gb.class, Constants.GETSLOTATPOSITION_NAME.forgeName, Integer.TYPE, Integer.TYPE);
                obfuscation = Obfuscation.FORGE;
            }
            catch (NoSuchMethodException ex) {
                obfuscation = Obfuscation.VANILLA;
            }
        }
        Logger.Log("Detected obfuscation: " + (Object)((Object)obfuscation) + ".");
    }

    static {
        checkObfuscation = true;
        HMCCache = new HashMap();
    }
}

