/*
 * Decompiled with CFR 0.152.
 */
package krapht;

import java.util.LinkedList;
import krapht.ItemIdentifierProxy;
import krapht.ItemIdentifierStack;

public final class ItemIdentifier {
    private static final LinkedList _itemIdentifierCache = new LinkedList();
    public final int itemID;
    public final int itemDamage;
    public final ph tag;
    public static boolean allowNullsForTesting;

    private ItemIdentifier(int itemID, int itemDamage, ph tag) {
        this.itemID = itemID;
        this.itemDamage = itemDamage;
        this.tag = tag;
    }

    public static ItemIdentifier get(int itemID, int itemUndamagableDamage, ph tag) {
        for (ItemIdentifier item : _itemIdentifierCache) {
            if (item.itemID != itemID || item.itemDamage != itemUndamagableDamage || !ItemIdentifier.tagsequal(item.tag, tag)) continue;
            return item;
        }
        ItemIdentifier unknownItem = new ItemIdentifier(itemID, itemUndamagableDamage, tag);
        _itemIdentifierCache.add(unknownItem);
        return unknownItem;
    }

    public static ItemIdentifier get(kp itemStack) {
        if (itemStack == null && allowNullsForTesting) {
            return null;
        }
        int itemDamage = 0;
        if (!id.d[itemStack.c].g()) {
            itemDamage = itemStack.h();
        }
        return ItemIdentifier.get(itemStack.c, itemDamage, itemStack.d);
    }

    private static boolean tagsequal(ph tag1, ph tag2) {
        if (tag1 == null && tag2 == null) {
            return true;
        }
        if (tag1 == null) {
            return false;
        }
        if (tag2 == null) {
            return false;
        }
        return tag1.equals((Object)tag2);
    }

    public String getDebugName() {
        if (id.d[this.itemID] != null) {
            return id.d[this.itemID].b() + "(ID: " + this.itemID + ", Damage: " + this.itemDamage + ")";
        }
        return "<item not found>";
    }

    public String getFriendlyName() {
        if (id.d[this.itemID] != null) {
            return ItemIdentifierProxy.getName(this.itemID, this.makeNormalStack(1));
        }
        return "<Item name not found>";
    }

    public ItemIdentifierStack makeStack(int stackSize) {
        return new ItemIdentifierStack(this, stackSize);
    }

    public kp makeNormalStack(int stackSize) {
        kp stack = new kp(this.itemID, stackSize, this.itemDamage);
        stack.d(this.tag);
        return stack;
    }
}

