/*
 * Decompiled with CFR 0.152.
 */
package krapht;

import java.util.HashMap;
import krapht.ItemIdentifier;

public class InventoryUtil {
    private final ni _inventory;
    private final boolean _hideOne;

    public InventoryUtil(ni inventory, boolean hideOne) {
        this._inventory = inventory;
        this._hideOne = hideOne;
    }

    public int itemCount(ItemIdentifier item) {
        int count = 0;
        for (int i = 0; i < this._inventory.c(); ++i) {
            kp stack = this._inventory.g_(i);
            if (stack == null || ItemIdentifier.get(stack) != item) continue;
            count += stack.a - (this._hideOne ? 1 : 0);
        }
        return count;
    }

    public HashMap getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> items = new HashMap<ItemIdentifier, Integer>();
        for (int i = 0; i < this._inventory.c(); ++i) {
            kp stack = this._inventory.g_(i);
            if (stack == null) continue;
            ItemIdentifier itemId = ItemIdentifier.get(stack);
            int stackSize = stack.a - (this._hideOne ? 1 : 0);
            if (!items.containsKey(itemId)) {
                items.put(itemId, stackSize);
                continue;
            }
            items.put(itemId, (Integer)items.get(itemId) + stackSize);
        }
        return items;
    }

    public int getItemCount(ItemIdentifier item) {
        HashMap itemsAndCount = this.getItemsAndCount();
        if (!itemsAndCount.containsKey(item)) {
            return 0;
        }
        return (Integer)itemsAndCount.get(item);
    }

    public kp getSingleItem(ItemIdentifier item) {
        for (int i = 0; i < this._inventory.c(); ++i) {
            kp stack = this._inventory.g_(i);
            if (stack == null || this._hideOne && stack.a == 1 || ItemIdentifier.get(stack) != item) continue;
            kp removed = stack.a(1);
            if (stack.a == 0) {
                this._inventory.a(i, null);
            }
            return removed;
        }
        return null;
    }

    public kp getMultipleItems(ItemIdentifier item, int count) {
        if (this.itemCount(item) < count) {
            return null;
        }
        kp stack = null;
        for (int i = 0; i < count; ++i) {
            if (stack == null) {
                stack = this.getSingleItem(item);
                continue;
            }
            stack.a += this.getSingleItem((ItemIdentifier)item).a;
        }
        return stack;
    }

    public boolean containsItem(ItemIdentifier item) {
        for (int i = 0; i < this._inventory.c(); ++i) {
            kp stack = this._inventory.g_(i);
            if (stack == null || ItemIdentifier.get(stack) != item) continue;
            return true;
        }
        return false;
    }

    public int roomForItem(ItemIdentifier item) {
        int totalRoom = 0;
        for (int i = 0; i < this._inventory.c(); ++i) {
            kp stack = this._inventory.g_(i);
            if (stack == null) {
                totalRoom += Math.min(this._inventory.a(), item.makeNormalStack(1).b());
                continue;
            }
            if (ItemIdentifier.get(stack) != item) continue;
            totalRoom += Math.min(this._inventory.a(), item.makeNormalStack(1).b()) - stack.a;
        }
        return totalRoom;
    }

    public boolean hasRoomForItem(ItemIdentifier item) {
        return this.roomForItem(item) > 0;
    }
}

