/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes.modules;

import buildcraft.krapht.IProvideItems;
import buildcraft.krapht.IRequestItems;
import buildcraft.krapht.LogisticsOrderManager;
import buildcraft.krapht.LogisticsPromise;
import buildcraft.krapht.LogisticsRequest;
import buildcraft.krapht.LogisticsTransaction;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.routing.IRouter;
import buildcraft.logisticspipes.ExtractionMode;
import buildcraft.logisticspipes.IInventoryProvider;
import buildcraft.logisticspipes.modules.IClientInformationProvider;
import buildcraft.logisticspipes.modules.ILegacyActiveModule;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.ISendRoutedItem;
import buildcraft.logisticspipes.modules.IWorldProvider;
import buildcraft.logisticspipes.modules.SinkReply;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import krapht.CroppedInventory;
import krapht.InventoryUtil;
import krapht.ItemIdentifier;
import krapht.SimpleInventory;

public class ModuleProvider
implements ILogisticsModule,
ILegacyActiveModule,
IClientInformationProvider {
    private IInventoryProvider _invProvider;
    private ISendRoutedItem _itemSender;
    private LogisticsOrderManager _orderManager = new LogisticsOrderManager();
    private final SimpleInventory _filterInventory = new SimpleInventory(9, "Items to provide (or empty for all)", 1);
    private final InventoryUtil _filterUtil = new InventoryUtil(this._filterInventory, false);
    private final int ticksToAction = 6;
    private int currentTick = 0;
    private boolean isExcludeFilter = false;
    private ExtractionMode _extractionMode = ExtractionMode.Normal;

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
    }

    @Override
    public void readFromNBT(ph nbttagcompound, String prefix) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
        this.isExcludeFilter = nbttagcompound.o("filterisexclude");
        this._extractionMode = ExtractionMode.values()[nbttagcompound.f("extractionMode")];
    }

    @Override
    public void writeToNBT(ph nbttagcompound, String prefix) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.a("filterisexclude", this.isExcludeFilter);
        nbttagcompound.a("extractionMode", this._extractionMode.ordinal());
    }

    @Override
    public int getGuiHandlerID() {
        return 24;
    }

    @Override
    public SinkReply sinksItem(kp item) {
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        if (++this.currentTick < 6) {
            return;
        }
        this.currentTick = 0;
        if (!this._orderManager.hasOrders()) {
            return;
        }
        LogisticsRequest order = this._orderManager.getNextRequest();
        int sent = this.sendItem(order.getItem(), order.numberLeft(), order.getDestination().getRouter().getId());
        if (sent > 0) {
            this._orderManager.sendSuccessfull(sent);
        } else {
            this._orderManager.sendFailed();
        }
    }

    @Override
    public void canProvide(LogisticsTransaction transaction) {
        HashMap commited = transaction.getTotalPromised((IProvideItems)((Object)this._itemSender));
        for (LogisticsRequest request : transaction.getRemainingRequests()) {
            int canProvide = this.getAvailableItemCount(request.getItem());
            if (commited.containsKey(request.getItem())) {
                canProvide -= ((Integer)commited.get(request.getItem())).intValue();
            }
            if (canProvide < 1) continue;
            LogisticsPromise promise = new LogisticsPromise();
            promise.item = request.getItem();
            promise.numberOfItems = Math.min(canProvide, request.notYetAllocated());
            promise.sender = (IProvideItems)((Object)this._itemSender);
            request.addPromise(promise);
            commited = transaction.getTotalPromised((IProvideItems)((Object)this._itemSender));
        }
    }

    @Override
    public void fullFill(LogisticsPromise promise, IRequestItems destination) {
        this._orderManager.addOrder(new LogisticsRequest(promise.item, promise.numberOfItems, destination));
    }

    @Override
    public int getAvailableItemCount(ItemIdentifier item) {
        return this.getTotalItemCount(item) - this._orderManager.totalItemsCountInOrders(item);
    }

    @Override
    public HashMap getAllItems() {
        HashMap allItems = new HashMap();
        if (this._invProvider.getInventory() == null) {
            return allItems;
        }
        InventoryUtil inv = this.getAdaptedUtil(this._invProvider.getInventory());
        HashMap currentInv = inv.getItemsAndCount();
        for (ItemIdentifier currItem : currentInv.keySet()) {
            if (this.hasFilter() && (this.isExcludeFilter && this.itemIsFiltered(currItem) || !this.isExcludeFilter && !this.itemIsFiltered(currItem))) continue;
            if (!allItems.containsKey(currItem)) {
                allItems.put(currItem, currentInv.get(currItem));
                continue;
            }
            allItems.put(currItem, (Integer)allItems.get(currItem) + (Integer)currentInv.get(currItem));
        }
        Iterator iterator = allItems.keySet().iterator();
        while (iterator.hasNext()) {
            ItemIdentifier item = (ItemIdentifier)iterator.next();
            int remaining = (Integer)allItems.get(item) - this._orderManager.totalItemsCountInOrders(item);
            if (remaining < 1) {
                iterator.remove();
                continue;
            }
            allItems.put(item, remaining);
        }
        return allItems;
    }

    @Override
    public IRouter getRouter() {
        return null;
    }

    private int sendItem(ItemIdentifier item, int maxCount, UUID destination) {
        int sent = 0;
        if (this._invProvider.getInventory() == null) {
            return 0;
        }
        InventoryUtil inv = this.getAdaptedUtil(this._invProvider.getInventory());
        if (inv.itemCount(item) > 0) {
            kp removed = inv.getSingleItem(item);
            this._itemSender.sendStack(removed, destination);
            ++sent;
            --maxCount;
        }
        return sent;
    }

    public int getTotalItemCount(ItemIdentifier item) {
        if (this._invProvider.getInventory() == null) {
            return 0;
        }
        if (this._filterUtil.getItemsAndCount().size() > 0 && (this.isExcludeFilter && this._filterUtil.getItemsAndCount().containsKey(item) || !this.isExcludeFilter && !this._filterUtil.getItemsAndCount().containsKey(item))) {
            return 0;
        }
        InventoryUtil inv = this.getAdaptedUtil(this._invProvider.getInventory());
        return inv.itemCount(item);
    }

    private boolean hasFilter() {
        return this._filterUtil.getItemsAndCount().size() > 0;
    }

    public boolean itemIsFiltered(ItemIdentifier item) {
        return this._filterUtil.getItemsAndCount().containsKey(item);
    }

    public InventoryUtil getAdaptedUtil(ni base) {
        switch (this._extractionMode) {
            case LeaveFirst: {
                base = new CroppedInventory(base, 1, 0);
                break;
            }
            case LeaveLast: {
                base = new CroppedInventory(base, 0, 1);
                break;
            }
            case LeaveFirstAndLast: {
                base = new CroppedInventory(base, 1, 1);
                break;
            }
            case Leave1PerStack: {
                return SimpleServiceLocator.inventoryUtilFactory.getOneHiddenInventoryUtil(base);
            }
        }
        return SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(base);
    }

    public ni getFilterInventory() {
        return this._filterInventory;
    }

    public boolean isExcludeFilter() {
        return this.isExcludeFilter;
    }

    public void setFilterExcluded(boolean isExcludeFilter) {
        this.isExcludeFilter = isExcludeFilter;
    }

    public ExtractionMode getExtractionMode() {
        return this._extractionMode;
    }

    public void nextExtractionMode() {
        this._extractionMode = this._extractionMode.next();
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(!this.isExcludeFilter ? "Included" : "Excluded");
        list.add("Mode: " + this._extractionMode.getExtractionModeString());
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }
}

