/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes.modules;

import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.logisticspipes.IInventoryProvider;
import buildcraft.logisticspipes.modules.IClientInformationProvider;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.ISendRoutedItem;
import buildcraft.logisticspipes.modules.IWorldProvider;
import buildcraft.logisticspipes.modules.SinkReply;
import java.util.ArrayList;
import java.util.List;
import krapht.InventoryUtil;
import krapht.ItemIdentifier;
import krapht.SimpleInventory;

public class ModuleItemSink
implements ILogisticsModule,
IClientInformationProvider {
    private final SimpleInventory _filterInventory = new SimpleInventory(9, "Requested items", 1);
    private boolean _isDefaultRoute;

    public ni getFilterInventory() {
        return this._filterInventory;
    }

    public boolean isDefaultRoute() {
        return this._isDefaultRoute;
    }

    public void setDefaultRoute(boolean isDefaultRoute) {
        this._isDefaultRoute = isDefaultRoute;
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world) {
    }

    @Override
    public SinkReply sinksItem(kp item) {
        InventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(this._filterInventory);
        if (invUtil.containsItem(ItemIdentifier.get(item))) {
            SinkReply reply = new SinkReply();
            reply.fixedPriority = SinkReply.FixedPriority.ItemSink;
            reply.isPassive = true;
            return reply;
        }
        if (this._isDefaultRoute) {
            SinkReply reply = new SinkReply();
            reply.fixedPriority = SinkReply.FixedPriority.DefaultRoute;
            reply.isPassive = true;
            reply.isDefault = true;
            return reply;
        }
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 21;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(ph nbttagcompound, String prefix) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
        this.setDefaultRoute(nbttagcompound.o("defaultdestination"));
    }

    @Override
    public void writeToNBT(ph nbttagcompound, String prefix) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.a("defaultdestination", this.isDefaultRoute());
    }

    @Override
    public void tick() {
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Default: " + (this.isDefaultRoute() ? "Yes" : "No"));
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }
}

