/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes.modules;

import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.logisticspipes.IInventoryProvider;
import buildcraft.logisticspipes.modules.IClientInformationProvider;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.ISendRoutedItem;
import buildcraft.logisticspipes.modules.IWorldProvider;
import buildcraft.logisticspipes.modules.SinkReply;
import java.util.ArrayList;
import java.util.List;
import krapht.SimpleInventory;

public class ModuleElectricManager
implements ILogisticsModule,
IClientInformationProvider {
    private final SimpleInventory _filterInventory = new SimpleInventory(9, "Electric Items", 1);
    private boolean _dischargeMode;
    protected IInventoryProvider _invProvider;
    protected ISendRoutedItem _itemSender;
    private int ticksToAction = 100;
    private int currentTick = 0;

    public ni getFilterInventory() {
        return this._filterInventory;
    }

    public boolean isDischargeMode() {
        return this._dischargeMode;
    }

    public void setDischargeMode(boolean isDischargeMode) {
        this._dischargeMode = isDischargeMode;
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
    }

    public static int getCharge(kp item) {
        if (SimpleServiceLocator.electricItemProxy.isElectricItem(item) && item.n()) {
            return item.o().f("charge");
        }
        return 0;
    }

    public boolean findElectricItem(kp item, boolean discharged, boolean partial) {
        if (!SimpleServiceLocator.electricItemProxy.isElectricItem(item)) {
            return false;
        }
        for (int i = 0; i < this._filterInventory.c(); ++i) {
            kp stack = this._filterInventory.g_(i);
            if (stack == null) continue;
            if (discharged && SimpleServiceLocator.electricItemProxy.isDischarged(item, partial, stack.a())) {
                return true;
            }
            if (discharged || !SimpleServiceLocator.electricItemProxy.isCharged(item, partial, stack.a())) continue;
            return true;
        }
        return false;
    }

    @Override
    public SinkReply sinksItem(kp item) {
        if (this.findElectricItem(item, !this.isDischargeMode(), true)) {
            SinkReply reply = new SinkReply();
            reply.fixedPriority = SinkReply.FixedPriority.ItemSink;
            reply.isPassive = true;
            return reply;
        }
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 40;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(ph nbttagcompound, String prefix) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
        this.setDischargeMode(nbttagcompound.o("discharge"));
    }

    @Override
    public void writeToNBT(ph nbttagcompound, String prefix) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.a("discharge", this.isDischargeMode());
    }

    @Override
    public void tick() {
        if (++this.currentTick < this.ticksToAction) {
            return;
        }
        this.currentTick = 0;
        ni inv = this._invProvider.getInventory();
        if (inv == null) {
            return;
        }
        for (int i = 0; i < inv.c(); ++i) {
            kp item = inv.g_(i);
            if (item == null || !this.findElectricItem(item, this.isDischargeMode(), false)) continue;
            this._itemSender.sendStack(inv.a(i, 1));
        }
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Discharge Mode: " + (this.isDischargeMode() ? "Yes" : "No"));
        list.add("Supplied: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }
}

