/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes.modules;

import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.network.INBTPacketProvider;
import buildcraft.logisticspipes.IInventoryProvider;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.ISendRoutedItem;
import buildcraft.logisticspipes.modules.IWorldProvider;
import buildcraft.logisticspipes.modules.SinkReply;

public class ModuleApiaristSink
implements ILogisticsModule,
INBTPacketProvider {
    public SinkSetting[] filter = new SinkSetting[6];
    public IWorldProvider worldProvider;
    private int slotNumber;

    public ModuleApiaristSink() {
        this.filter[0] = new SinkSetting(this);
        this.filter[1] = new SinkSetting(this);
        this.filter[2] = new SinkSetting(this);
        this.filter[3] = new SinkSetting(this);
        this.filter[4] = new SinkSetting(this);
        this.filter[5] = new SinkSetting(this);
    }

    @Override
    public void readFromNBT(ph nbttagcompound, String prefix) {
        ph filters = nbttagcompound.m("filters");
        for (int i = 0; i < this.filter.length; ++i) {
            ph filterNBT = filters.m("" + i);
            this.filter[i].readFromNBT(filterNBT);
        }
    }

    @Override
    public void writeToNBT(ph nbttagcompound, String prefix) {
        ph filters = new ph();
        for (int i = 0; i < this.filter.length; ++i) {
            ph filterNBT = new ph();
            this.filter[i].writeToNBT(filterNBT);
            filters.a("" + i, filterNBT);
        }
        nbttagcompound.a("filters", filters);
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world) {
        this.worldProvider = world;
    }

    @Override
    public int getGuiHandlerID() {
        return 28;
    }

    public boolean isFiltered(kp itemBee) {
        int i;
        Boolean[] groups = new Boolean[6];
        for (i = 0; i < 6; ++i) {
            groups[i] = null;
            for (SinkSetting setting : this.filter) {
                if (setting.filterGroup - 1 != i) continue;
                if (groups[i] == null) {
                    groups[i] = setting.isFiltered(itemBee);
                    continue;
                }
                Boolean[] booleanArray = groups;
                int n = i;
                Boolean.valueOf(booleanArray[n] & setting.isFiltered(itemBee));
            }
        }
        for (i = 0; i < 6; ++i) {
            if (groups[i] == null || !groups[i].booleanValue()) continue;
            return true;
        }
        for (SinkSetting setting : this.filter) {
            if (setting.filterGroup != 0 || !setting.isFiltered(itemBee)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SinkReply sinksItem(kp item) {
        if (SimpleServiceLocator.forestryProxy.isBee(item) && SimpleServiceLocator.forestryProxy.isAnalysedBee(item) && this.isFiltered(item)) {
            SinkReply reply = new SinkReply();
            reply.fixedPriority = SinkReply.FixedPriority.APIARIST_BeeSink;
            reply.isPassive = true;
            return reply;
        }
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public void readFromPacketNBT(ph tag) {
        this.readFromNBT(tag, "");
    }

    @Override
    public void writeToPacketNBT(ph tag) {
        this.writeToNBT(tag, "");
    }

    public static class SinkSetting {
        private final ModuleApiaristSink module;
        public FilterType filterType = FilterType.Null;
        public int firstBee = -1;
        public int secondBee = -1;
        public int filterGroup = 0;

        public SinkSetting(ModuleApiaristSink module) {
            this.module = module;
        }

        public void firstBeeUp() {
            boolean changed = false;
            for (int id2 = this.firstBee + 1; id2 <= 256; ++id2) {
                if (!SimpleServiceLocator.forestryProxy.isVaildAlleleId(id2) || !SimpleServiceLocator.forestryProxy.isKnownAlleleId(id2, this.module.worldProvider.getWorld())) continue;
                this.firstBee = id2;
                changed = true;
                break;
            }
            if (!changed) {
                this.firstBee = -1;
            }
        }

        public void firstBeeDown() {
            boolean changed = false;
            for (int id2 = this.firstBee - 1; id2 >= 0; --id2) {
                if (!SimpleServiceLocator.forestryProxy.isVaildAlleleId(id2) || !SimpleServiceLocator.forestryProxy.isKnownAlleleId(id2, this.module.worldProvider.getWorld())) continue;
                this.firstBee = id2;
                changed = true;
                break;
            }
            if (!changed) {
                this.firstBee = -1;
            }
        }

        public void firstBeeReset() {
            this.firstBee = -1;
        }

        public void secondBeeUp() {
            boolean changed = false;
            for (int id2 = this.secondBee + 1; id2 <= 256; ++id2) {
                if (!SimpleServiceLocator.forestryProxy.isVaildAlleleId(id2) || !SimpleServiceLocator.forestryProxy.isKnownAlleleId(id2, this.module.worldProvider.getWorld())) continue;
                this.secondBee = id2;
                changed = true;
                break;
            }
            if (!changed) {
                this.secondBee = -1;
            }
        }

        public void secondBeeDown() {
            boolean changed = false;
            for (int id2 = this.secondBee - 1; id2 >= 0; --id2) {
                if (!SimpleServiceLocator.forestryProxy.isVaildAlleleId(id2) || !SimpleServiceLocator.forestryProxy.isKnownAlleleId(id2, this.module.worldProvider.getWorld())) continue;
                this.secondBee = id2;
                changed = true;
                break;
            }
            if (!changed) {
                this.secondBee = -1;
            }
        }

        public void secondBeeReset() {
            this.secondBee = -1;
        }

        public void filterGroupUp() {
            this.filterGroup = this.filterGroup <= 5 ? ++this.filterGroup : 0;
        }

        public void filterGroupDown() {
            this.filterGroup = this.filterGroup >= 1 ? --this.filterGroup : 6;
        }

        public void filterGroupReset() {
            this.filterGroup = 0;
        }

        public void FilterTypeUp() {
            this.filterType = this.filterType.ordinal() + 1 >= FilterType.values().length ? FilterType.values()[0] : FilterType.values()[this.filterType.ordinal() + 1];
        }

        public void FilterTypeDown() {
            this.filterType = this.filterType.ordinal() - 1 < 0 ? FilterType.values()[FilterType.values().length - 1] : FilterType.values()[this.filterType.ordinal() - 1];
        }

        public void FilterTypeReset() {
            this.filterType = FilterType.Null;
        }

        public void readFromNBT(ph nbttagcompound) {
            this.filterType = nbttagcompound.c("filterType") ? FilterType.values()[nbttagcompound.f("filterType")] : FilterType.Null;
            this.firstBee = nbttagcompound.f("firstBee");
            this.secondBee = nbttagcompound.f("secondBee");
        }

        public void writeToNBT(ph nbttagcompound) {
            nbttagcompound.a("filterType", this.filterType.ordinal());
            nbttagcompound.a("firstBee", this.firstBee);
            nbttagcompound.a("secondBee", this.secondBee);
        }

        private boolean allAllele(kp bee) {
            return this.firstAllele(bee) && this.secondAllele(bee);
        }

        private boolean firstAllele(kp bee) {
            return SimpleServiceLocator.forestryProxy.getFirstAlleleId(bee) == this.firstBee || this.firstBee == -1;
        }

        private boolean secondAllele(kp bee) {
            return SimpleServiceLocator.forestryProxy.getSecondAlleleId(bee) == this.secondBee || this.secondBee == -1;
        }

        public boolean isFiltered(kp bee) {
            switch (this.filterType) {
                case BeeAllele: {
                    return this.allAllele(bee);
                }
                case Drone: {
                    return this.allAllele(bee) && SimpleServiceLocator.forestryProxy.isDrone(bee);
                }
                case Princess: {
                    return this.allAllele(bee) && SimpleServiceLocator.forestryProxy.isPrincess(bee);
                }
                case Queen: {
                    return this.allAllele(bee) && SimpleServiceLocator.forestryProxy.isQueen(bee);
                }
                case Purebred: {
                    return this.firstAllele(bee) && SimpleServiceLocator.forestryProxy.isPurebred(bee);
                }
                case Nocturnal: {
                    return this.allAllele(bee) && SimpleServiceLocator.forestryProxy.isNocturnal(bee);
                }
                case PureNocturnal: {
                    return this.allAllele(bee) && SimpleServiceLocator.forestryProxy.isPureNocturnal(bee);
                }
                case Flyer: {
                    return this.allAllele(bee) && SimpleServiceLocator.forestryProxy.isFlyer(bee);
                }
                case PureFlyer: {
                    return this.allAllele(bee) && SimpleServiceLocator.forestryProxy.isPureFlyer(bee);
                }
                case Cave: {
                    return this.allAllele(bee) && SimpleServiceLocator.forestryProxy.isCave(bee);
                }
                case PureCave: {
                    return this.allAllele(bee) && SimpleServiceLocator.forestryProxy.isPureCave(bee);
                }
            }
            return false;
        }
    }

    public static enum FilterType {
        Null("", 0, 0),
        BeeAllele("gui.pipe.filter.BEE", 3, 2),
        Drone("gui.pipe.filter.DRONE", 4, 2),
        Princess("gui.pipe.filter.PRINCESS", 5, 2),
        Queen("gui.pipe.filter.QUEEN", 6, 2),
        Purebred("gui.pipe.filter.PURE_BREED", 7, 1),
        Nocturnal("gui.pipe.filter.NOCTURNAL", 8, 2),
        PureNocturnal("gui.pipe.filter.PURE_NOCTURNAL", 9, 2),
        Flyer("gui.pipe.filter.FLYER", 10, 2),
        PureFlyer("gui.pipe.filter.PURE_FLYER", 11, 2),
        Cave("gui.pipe.filter.CAVE", 12, 2),
        PureCave("gui.pipe.filter.PURE_CAVE", 13, 2);

        public String path;
        public int icon;
        public int secondSlots;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private FilterType(int text) {
            void secondSlot;
            void id2;
            this.path = (String)text;
            this.icon = id2;
            this.secondSlots = secondSlot;
        }
    }
}

