/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes.modules;

import buildcraft.api.Orientations;
import buildcraft.core.Utils;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.logisticspipes.IInventoryProvider;
import buildcraft.logisticspipes.SidedInventoryAdapter;
import buildcraft.logisticspipes.modules.IClientInformationProvider;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.ISendRoutedItem;
import buildcraft.logisticspipes.modules.ISneakyOrientationreceiver;
import buildcraft.logisticspipes.modules.IWorldProvider;
import buildcraft.logisticspipes.modules.SinkReply;
import buildcraft.logisticspipes.modules.SneakyOrientation;
import forge.ISidedInventory;
import java.util.ArrayList;
import java.util.List;
import krapht.SimpleInventory;

public class ModuleAdvancedExtractor
implements ILogisticsModule,
ISneakyOrientationreceiver,
IClientInformationProvider {
    protected int currentTick = 0;
    private final SimpleInventory _filterInventory = new SimpleInventory(9, "Item list", 1);
    private boolean _itemsIncluded = true;
    protected IInventoryProvider _invProvider;
    protected ISendRoutedItem _itemSender;
    protected SneakyOrientation _sneakyOrientation = SneakyOrientation.Default;

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
    }

    public SimpleInventory getFilterInventory() {
        return this._filterInventory;
    }

    @Override
    public SneakyOrientation getSneakyOrientation() {
        return this._sneakyOrientation;
    }

    @Override
    public void setSneakyOrientation(SneakyOrientation sneakyOrientation) {
        this._sneakyOrientation = sneakyOrientation;
    }

    @Override
    public void readFromNBT(ph nbttagcompound, String prefix) {
        this._filterInventory.readFromNBT(nbttagcompound, prefix);
        this.setItemsIncluded(nbttagcompound.o("itemsIncluded"));
        this._sneakyOrientation = SneakyOrientation.values()[nbttagcompound.f("sneakyorientation")];
    }

    @Override
    public void writeToNBT(ph nbttagcompound, String prefix) {
        this._filterInventory.writeToNBT(nbttagcompound, prefix);
        nbttagcompound.a("itemsIncluded", this.areItemsIncluded());
        nbttagcompound.a("sneakyorientation", this._sneakyOrientation.ordinal());
    }

    @Override
    public int getGuiHandlerID() {
        return 27;
    }

    @Override
    public SinkReply sinksItem(kp item) {
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    protected int ticksToAction() {
        return 100;
    }

    protected int itemsToExtract() {
        return 1;
    }

    public boolean connectedToSidedInventory() {
        return this._invProvider.getRawInventory() instanceof ISidedInventory;
    }

    @Override
    public void tick() {
        kp stack;
        if (++this.currentTick < this.ticksToAction()) {
            return;
        }
        this.currentTick = 0;
        ni inventory = this._invProvider.getRawInventory();
        if (inventory == null) {
            return;
        }
        if (inventory instanceof ISidedInventory) {
            Orientations extractOrientation;
            switch (this._sneakyOrientation) {
                case Bottom: {
                    extractOrientation = Orientations.YNeg;
                    break;
                }
                case Top: {
                    extractOrientation = Orientations.YPos;
                    break;
                }
                case Side: {
                    extractOrientation = Orientations.ZPos;
                    break;
                }
                default: {
                    extractOrientation = this._invProvider.inventoryOrientation().reverse();
                }
            }
            inventory = new SidedInventoryAdapter((ISidedInventory)inventory, extractOrientation);
        }
        if ((stack = this.checkExtract(inventory, true, this._invProvider.inventoryOrientation().reverse())) == null) {
            return;
        }
        this._itemSender.sendStack(stack);
    }

    public kp checkExtract(ni inventory, boolean doRemove, Orientations from) {
        ni inv = Utils.getInventory((ni)inventory);
        kp result = this.checkExtractGeneric(inv, doRemove, from);
        return result;
    }

    public kp checkExtractGeneric(ni inventory, boolean doRemove, Orientations from) {
        for (int k = 0; k < inventory.c(); ++k) {
            kp slot;
            if (inventory.g_(k) == null || inventory.g_((int)k).a <= 0 || (slot = inventory.g_(k)) == null || slot.a <= 0 || !this.CanExtract(slot)) continue;
            if (doRemove) {
                return inventory.a(k, this.itemsToExtract());
            }
            return slot;
        }
        return null;
    }

    public boolean CanExtract(kp item) {
        if (!this.shouldSend(item)) {
            return false;
        }
        for (int i = 0; i < this._filterInventory.c(); ++i) {
            kp stack = this._filterInventory.g_(i);
            if (stack == null || stack.c != item.c) continue;
            if (id.d[item.c].g()) {
                return this.areItemsIncluded();
            }
            if (stack.h() != item.h()) continue;
            return this.areItemsIncluded();
        }
        return !this.areItemsIncluded();
    }

    protected boolean shouldSend(kp stack) {
        return SimpleServiceLocator.logisticsManager.hasDestination(stack, true, this._itemSender.getSourceUUID(), true);
    }

    public boolean areItemsIncluded() {
        return this._itemsIncluded;
    }

    public void setItemsIncluded(boolean flag) {
        this._itemsIncluded = flag;
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.areItemsIncluded() ? "Included" : "Excluded");
        list.add("Extraction: " + this._sneakyOrientation.name());
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }
}

