/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes.items;

import buildcraft.logisticspipes.IInventoryProvider;
import buildcraft.logisticspipes.items.ItemModuleProxy;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.ISendRoutedItem;
import buildcraft.logisticspipes.modules.IWorldProvider;
import buildcraft.logisticspipes.modules.ModuleAdvancedExtractor;
import buildcraft.logisticspipes.modules.ModuleAdvancedExtractorMK2;
import buildcraft.logisticspipes.modules.ModuleAdvancedExtractorMK3;
import buildcraft.logisticspipes.modules.ModuleApiaristAnalyser;
import buildcraft.logisticspipes.modules.ModuleApiaristSink;
import buildcraft.logisticspipes.modules.ModuleElectricManager;
import buildcraft.logisticspipes.modules.ModuleExtractor;
import buildcraft.logisticspipes.modules.ModuleExtractorMk2;
import buildcraft.logisticspipes.modules.ModuleExtractorMk3;
import buildcraft.logisticspipes.modules.ModuleItemSink;
import buildcraft.logisticspipes.modules.ModulePassiveSupplier;
import buildcraft.logisticspipes.modules.ModulePolymorphicItemSink;
import buildcraft.logisticspipes.modules.ModuleProvider;
import buildcraft.logisticspipes.modules.ModuleQuickSort;
import buildcraft.logisticspipes.modules.ModuleTerminus;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class ItemModule
extends ItemModuleProxy {
    public static final String textureMap = "0000111111111111000001111111111100000000011111111110111011111111111011101111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
    public static final int BLANK = 0;
    public static final int ITEMSINK = 1;
    public static final int PASSIVE_SUPPLIER = 2;
    public static final int EXTRACTOR = 3;
    public static final int POLYMORPHIC_ITEMSINK = 4;
    public static final int QUICKSORT = 5;
    public static final int TERMINUS = 6;
    public static final int ADVANCED_EXTRACTOR = 7;
    public static final int BEEANALYZER = 8;
    public static final int BEESINK = 9;
    public static final int EXTRACTOR_MK2 = 103;
    public static final int ADVANCED_EXTRACTOR_MK2 = 107;
    public static final int EXTRACTOR_MK3 = 203;
    public static final int ADVANCED_EXTRACTOR_MK3 = 207;
    public static final int ELECTRICMANAGER = 300;
    public static final int PROVIDER = 500;
    private List modules = new ArrayList();

    public ItemModule(int i) {
        super(i);
        this.bT = true;
    }

    @Override
    public void loadModules() {
        super.loadModules();
        this.registerModule(0, "Blank module", null);
        this.registerModule(1, "ItemSink module", ModuleItemSink.class);
        this.registerModule(2, "Passive Supplier module", ModulePassiveSupplier.class);
        this.registerModule(3, "Extractor module", ModuleExtractor.class);
        this.registerModule(4, "Polymorphic ItemSink module", ModulePolymorphicItemSink.class);
        this.registerModule(5, "QuickSort module", ModuleQuickSort.class);
        this.registerModule(6, "Terminus module", ModuleTerminus.class);
        this.registerModule(7, "Advanced Extractor module", ModuleAdvancedExtractor.class);
        this.registerModule(103, "Extractor MK2 module", ModuleExtractorMk2.class);
        this.registerModule(107, "Advanced Extractor MK2", ModuleAdvancedExtractorMK2.class);
        this.registerModule(203, "Extractor MK3 module", ModuleExtractorMk3.class);
        this.registerModule(207, "Advanced Extractor MK3", ModuleAdvancedExtractorMK3.class);
        this.registerModule(500, "Provider module", ModuleProvider.class);
        this.registerModule(300, "Electric Manager module", ModuleElectricManager.class, 96);
        this.registerModule(8, "Bee Analyzer module", ModuleApiaristAnalyser.class);
        this.registerModule(9, "BeeSink module", ModuleApiaristSink.class);
    }

    public void registerModule(int id2, String name, Class moduleClass) {
        boolean flag = true;
        for (Module module : this.modules) {
            if (module.getId() != id2) continue;
            flag = false;
        }
        if ("".equals(name) || !flag) {
            if (!flag) {
                throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Module. (Id " + id2 + " already in use)");
            }
            throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Module. (No name given)");
        }
        this.modules.add(new Module(id2, name, moduleClass));
    }

    public void registerModule(int id2, String name, Class moduleClass, int textureId) {
        boolean flag = true;
        for (Module module : this.modules) {
            if (module.getId() != id2) continue;
            flag = false;
        }
        if ("".equals(name) || !flag) {
            if (!flag) {
                throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Module. (Id " + id2 + " already in use)");
            }
            throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Module. (No name given)");
        }
        this.modules.add(new Module(id2, name, moduleClass, textureId));
    }

    public int addOverlay(String newFileName) {
        return ModLoader.addOverride((String)"/logisticspipes/item_textures.png", (String)newFileName);
    }

    public int[] getRegisteredModulesIDs() {
        int[] array = new int[this.modules.size()];
        int i = 0;
        for (Module module : this.modules) {
            array[i++] = module.getId();
        }
        return array;
    }

    public void addCreativeItems(ArrayList itemList) {
        for (Module module : this.modules) {
            itemList.add(new kp((id)this, 1, module.getId()));
        }
    }

    public ILogisticsModule getModuleForItem(kp itemStack, ILogisticsModule currentModule, IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.c != this.bP) {
            return null;
        }
        for (Module module : this.modules) {
            if (itemStack.h() != module.getId()) continue;
            if (module.getILogisticsModuleClass() == null) {
                return null;
            }
            if (currentModule != null && module.getILogisticsModuleClass().equals(currentModule.getClass())) {
                return currentModule;
            }
            ILogisticsModule newmodule = module.getILogisticsModule();
            if (newmodule == null) {
                return null;
            }
            newmodule.registerHandler(invProvider, itemSender, world);
            return newmodule;
        }
        return null;
    }

    @Override
    public String getModuleDisplayName(kp itemstack) {
        for (Module module : this.modules) {
            if (itemstack.h() != module.getId()) continue;
            return module.getName();
        }
        return null;
    }

    @Override
    public int getModuleIconFromDamage(int i) {
        for (Module module : this.modules) {
            if (module.getId() != i || module.getTextureIndex() == -1) continue;
            return module.getTextureIndex();
        }
        if (i >= 500) {
            return 80 + (i - 500);
        }
        if (i >= 200) {
            return 64 + (i - 200);
        }
        if (i >= 100) {
            return 48 + (i - 100);
        }
        return 32 + i;
    }

    @Override
    public String getTextureMap() {
        return textureMap;
    }

    private class Module {
        private String name;
        private int id;
        private Class moduleClass;
        private int textureIndex = -1;

        private Module(int id2, String name, Class moduleClass) {
            this.id = id2;
            this.name = name;
            this.moduleClass = moduleClass;
        }

        private Module(int id2, String name, Class moduleClass, int textureIndex) {
            this.id = id2;
            this.name = name;
            this.moduleClass = moduleClass;
            this.textureIndex = textureIndex;
        }

        private ILogisticsModule getILogisticsModule() {
            if (this.moduleClass == null) {
                return null;
            }
            try {
                return (ILogisticsModule)this.moduleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return null;
        }

        private Class getILogisticsModuleClass() {
            return this.moduleClass;
        }

        private int getId() {
            return this.id;
        }

        private String getName() {
            return this.name;
        }

        private int getTextureIndex() {
            return this.textureIndex;
        }
    }
}

