/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes;

import buildcraft.api.APIProxy;
import buildcraft.api.Orientations;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.routing.IRouter;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.logisticspipes.TransportLayer;

public class RouteLayer {
    private final IRouter _router;
    private final TransportLayer _transport;

    public RouteLayer(IRouter router, TransportLayer transport) {
        this._router = router;
        this._transport = transport;
    }

    public Orientations getOrientationForItem(IRoutedItem item) {
        if (item.getDestination() == null && APIProxy.isRemote()) {
            return null;
        }
        if (item.getDestination() == null) {
            if (item.getSource() != null) {
                return Orientations.Unknown;
            }
            item = SimpleServiceLocator.logisticsManager.assignDestinationFor(item, this._router.getId(), false);
        }
        if (item.getDestination() != null && !this._router.hasRoute(item.getDestination())) {
            item = SimpleServiceLocator.logisticsManager.destinationUnreachable(item, this._router.getId());
        }
        if (item.getDestination() == null) {
            return Orientations.Unknown;
        }
        if (item.getDestination().equals(this._router.getId())) {
            if (!this._transport.stillWantItem(item)) {
                return this.getOrientationForItem(SimpleServiceLocator.logisticsManager.assignDestinationFor(item, this._router.getId(), true));
            }
            item.setDoNotBuffer(true);
            Orientations o = this._transport.itemArrived(item);
            return o != null ? o : Orientations.Unknown;
        }
        if (!this._router.hasRoute(item.getDestination())) {
            return Orientations.Unknown;
        }
        return this._router.getExitFor(item.getDestination());
    }
}

