/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes;

import buildcraft.api.Orientations;
import buildcraft.krapht.pipes.PipeLogisticsChassi;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.logisticspipes.TransportLayer;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.SinkReply;

public class ChassiTransportLayer
extends TransportLayer {
    private final PipeLogisticsChassi _chassiPipe;

    public ChassiTransportLayer(PipeLogisticsChassi chassiPipe) {
        this._chassiPipe = chassiPipe;
    }

    @Override
    public Orientations itemArrived(IRoutedItem item) {
        return this._chassiPipe.getPointedOrientation();
    }

    @Override
    public boolean stillWantItem(IRoutedItem item) {
        ILogisticsModule module = this._chassiPipe.getLogisticsModule();
        if (module == null) {
            return false;
        }
        if (!this._chassiPipe.isEnabled()) {
            return false;
        }
        SinkReply reply = module.sinksItem(item.getItemStack());
        if (reply == null) {
            return false;
        }
        if (reply.maxNumberOfItems != 0 && item.getItemStack().a > reply.maxNumberOfItems) {
            Orientations o = this._chassiPipe.getPointedOrientation();
            if (o == null || o == Orientations.Unknown) {
                o = Orientations.YPos;
            }
            IRoutedItem newItem = item.split(this._chassiPipe.worldObj, reply.maxNumberOfItems, o.reverse());
            return false;
        }
        return module.sinksItem(item.getItemStack()) != null;
    }
}

