/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.routing;

import buildcraft.api.Orientations;
import buildcraft.api.Position;
import buildcraft.krapht.CoreRoutedPipe;
import buildcraft.krapht.IRequireReliableTransport;
import buildcraft.krapht.PipeTransportLogistics;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.routing.ExitRoute;
import buildcraft.krapht.routing.IRouter;
import buildcraft.krapht.routing.PathFinder;
import buildcraft.krapht.routing.RouteLaser;
import buildcraft.krapht.routing.RoutedEntityItem;
import buildcraft.krapht.routing.RouterCost;
import buildcraft.krapht.routing.RouterManager;
import buildcraft.krapht.routing.WorldProxy;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.transport.TileGenericPipe;
import forge.DimensionManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import krapht.ItemIdentifier;

public class Router
implements IRouter {
    public HashMap _adjacent = new HashMap();
    private final LinkedList _outboundItems = new LinkedList();
    private final LinkedList _inboundItems = new LinkedList();
    private static int _LSDVersion = 0;
    private int _lastLSDVersion = 0;
    private static RouteLaser _laser = new RouteLaser();
    private static LinkedList SharedLSADatabase = new LinkedList();
    private LSA _myLsa = new LSA();
    private HashMap _routeTable = new HashMap();
    private HashMap _routeCosts = new HashMap();
    private LinkedList _routersByCost = null;
    private LinkedList _externalRoutersByCost = null;
    private boolean _blockNeedsUpdate;
    public final UUID id;
    private int _dimension;
    private final int _xCoord;
    private final int _yCoord;
    private final int _zCoord;

    public static void ResetStatics() {
        SharedLSADatabase.clear();
        _LSDVersion = 0;
        _laser = new RouteLaser();
    }

    public Router(UUID id2, int dimension, int xCoord, int yCoord, int zCoord) {
        this.id = id2;
        this._dimension = dimension;
        this._xCoord = xCoord;
        this._yCoord = yCoord;
        this._zCoord = zCoord;
        this._myLsa = new LSA();
        this._myLsa.source = this;
        this._myLsa.neighboursWithMetric = new HashMap();
        SharedLSADatabase.add(this._myLsa);
    }

    @Override
    @Deprecated
    public CoreRoutedPipe getPipe() {
        ge worldObj = DimensionManager.getWorld((int)this._dimension);
        if (worldObj == null) {
            worldObj = DimensionManager.getWorld((int)0);
        }
        if (worldObj == null) {
            worldObj = WorldProxy.getMainWorld();
        }
        if (worldObj == null) {
            return null;
        }
        qj tile = worldObj.b(this._xCoord, this._yCoord, this._zCoord);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        TileGenericPipe pipe = (TileGenericPipe)tile;
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return null;
        }
        return (CoreRoutedPipe)pipe.pipe;
    }

    private void ensureRouteTableIsUpToDate() {
        if (_LSDVersion > this._lastLSDVersion) {
            this.CreateRouteTable();
            this._routersByCost = null;
            this._externalRoutersByCost = null;
            this._lastLSDVersion = _LSDVersion;
            CoreRoutedPipe pipe = this.getPipe();
            if (pipe == null) {
                return;
            }
            PipeTransportLogistics pipeTransportLogistics = (PipeTransportLogistics)pipe.transport;
        }
    }

    @Override
    public HashMap getRouteTable() {
        this.ensureRouteTableIsUpToDate();
        return this._routeTable;
    }

    @Override
    @Deprecated
    public LinkedList getRoutersByCost() {
        this.ensureRouteTableIsUpToDate();
        if (this._routersByCost == null) {
            this._routersByCost = new LinkedList();
            LinkedList<RouterCost> tempList = new LinkedList<RouterCost>();
            block0: for (Router r : this._routeCosts.keySet()) {
                for (int i = 0; i < tempList.size(); ++i) {
                    if ((Integer)this._routeCosts.get(r) >= ((RouterCost)tempList.get((int)i)).cost) continue;
                    tempList.add(i, new RouterCost(r, (Integer)this._routeCosts.get(r)));
                    continue block0;
                }
                tempList.addLast(new RouterCost(r, (Integer)this._routeCosts.get(r)));
            }
            while (tempList.size() > 0) {
                this._routersByCost.addLast(((RouterCost)tempList.removeFirst()).router);
            }
        }
        return this._routersByCost;
    }

    @Override
    public LinkedList getIRoutersByCost() {
        this.ensureRouteTableIsUpToDate();
        if (this._externalRoutersByCost == null) {
            this._externalRoutersByCost = new LinkedList();
            LinkedList<RouterCost> tempList = new LinkedList<RouterCost>();
            block0: for (Router r : this._routeCosts.keySet()) {
                for (int i = 0; i < tempList.size(); ++i) {
                    if ((Integer)this._routeCosts.get(r) >= ((RouterCost)tempList.get((int)i)).cost) continue;
                    tempList.add(i, new RouterCost(r, (Integer)this._routeCosts.get(r)));
                    continue block0;
                }
                tempList.addLast(new RouterCost(r, (Integer)this._routeCosts.get(r)));
            }
            while (tempList.size() > 0) {
                this._externalRoutersByCost.addLast(((RouterCost)tempList.removeFirst()).router);
            }
            this._externalRoutersByCost.addFirst(this);
        }
        return this._externalRoutersByCost;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    private void recheckAdjacent() {
        boolean adjacentChanged = false;
        CoreRoutedPipe thisPipe = this.getPipe();
        if (thisPipe == null) {
            return;
        }
        HashMap adjacent = PathFinder.getConnectedRoutingPipes(thisPipe.container, core_LogisticsPipes.LOGISTICS_DETECTION_COUNT, core_LogisticsPipes.LOGISTICS_DETECTION_LENGTH);
        for (RoutedPipe pipe : this._adjacent.keySet()) {
            if (adjacent.containsKey(pipe)) continue;
            adjacentChanged = true;
        }
        for (RoutedPipe pipe : adjacent.keySet()) {
            if (!this._adjacent.containsKey(pipe)) {
                adjacentChanged = true;
                break;
            }
            ExitRoute newExit = (ExitRoute)adjacent.get(pipe);
            ExitRoute oldExit = (ExitRoute)this._adjacent.get(pipe);
            if (newExit.exitOrientation == oldExit.exitOrientation && newExit.metric == oldExit.metric) continue;
            adjacentChanged = true;
            break;
        }
        if (adjacentChanged) {
            this._adjacent = adjacent;
            this._blockNeedsUpdate = true;
            this.SendNewLSA();
        }
    }

    private void SendNewLSA() {
        this._myLsa.neighboursWithMetric = new HashMap();
        for (RoutedPipe adjacent : this._adjacent.keySet()) {
            this._myLsa.neighboursWithMetric.put(RouterManager.get(adjacent.getRouter().getId()), ((ExitRoute)this._adjacent.get((Object)adjacent)).metric);
        }
        ++_LSDVersion;
        this.CreateRouteTable();
    }

    private void CreateRouteTable() {
        HashMap<Router, LinkedList> tree = new HashMap<Router, LinkedList>();
        HashMap<Router, Integer> treeCost = new HashMap<Router, Integer>();
        tree.put(this, new LinkedList());
        treeCost.put(this, 0);
        HashMap<Router, Router> candidates = new HashMap<Router, Router>();
        HashMap<Router, Integer> candidatesCost = new HashMap<Router, Integer>();
        for (RoutedPipe pipe : this._adjacent.keySet()) {
            candidates.put(RouterManager.get(pipe.getRouter().getId()), this);
            candidatesCost.put(RouterManager.get(pipe.getRouter().getId()), ((ExitRoute)this._adjacent.get((Object)pipe)).metric);
        }
        while (!candidates.isEmpty()) {
            Router lowestCostCandidateRouter = null;
            int lowestCost = Integer.MAX_VALUE;
            for (Router candidate : candidatesCost.keySet()) {
                if ((Integer)candidatesCost.get(candidate) >= lowestCost) continue;
                lowestCostCandidateRouter = candidate;
                lowestCost = (Integer)candidatesCost.get(candidate);
            }
            Router lowestParent = (Router)candidates.get(lowestCostCandidateRouter);
            LinkedList lowestPath = (LinkedList)((LinkedList)tree.get(lowestParent)).clone();
            lowestPath.addLast(lowestCostCandidateRouter);
            tree.put(lowestCostCandidateRouter, lowestPath);
            treeCost.put(lowestCostCandidateRouter, lowestCost);
            candidates.remove(lowestCostCandidateRouter);
            candidatesCost.remove(lowestCostCandidateRouter);
            for (LSA lsa : SharedLSADatabase) {
                if (lsa.source != lowestCostCandidateRouter) continue;
                for (Router newCandidate : lsa.neighboursWithMetric.keySet()) {
                    if (tree.containsKey(newCandidate)) continue;
                    int candidateCost = lowestCost + (Integer)lsa.neighboursWithMetric.get(newCandidate);
                    if (candidates.containsKey(newCandidate) && (Integer)candidatesCost.get(newCandidate) <= candidateCost) continue;
                    candidates.put(newCandidate, lowestCostCandidateRouter);
                    candidatesCost.put(newCandidate, candidateCost);
                }
            }
        }
        this._routeTable = new HashMap();
        this._routeCosts = new HashMap();
        for (Router node : tree.keySet()) {
            CoreRoutedPipe firstPipe;
            LinkedList route = (LinkedList)tree.get(node);
            if (route.size() == 0) {
                this._routeTable.put(node, Orientations.Unknown);
                continue;
            }
            Router firstHop = (Router)route.getFirst();
            if (firstHop == null || (firstPipe = firstHop.getPipe()) == null || !this._adjacent.containsKey(firstPipe) || this._adjacent.get(firstPipe) == null) continue;
            this._routeCosts.put(node, treeCost.get(node));
            this._routeTable.put(node, ((ExitRoute)this._adjacent.get((Object)firstPipe)).exitOrientation);
        }
    }

    @Override
    public LinkedList GetNonRoutedExits() {
        LinkedList<Orientations> ret = new LinkedList<Orientations>();
        block0: for (int i = 0; i < 6; ++i) {
            Orientations o = Orientations.values()[i];
            boolean found = false;
            for (ExitRoute route : this._adjacent.values()) {
                if (route.exitOrientation != o) continue;
                found = true;
                continue block0;
            }
            ret.add(o);
        }
        return ret;
    }

    @Override
    public void displayRoutes() {
        _laser.displayRoute(this);
    }

    @Override
    public void displayRouteTo(IRouter r) {
        _laser.displayRoute((IRouter)this, r);
    }

    @Override
    public int getInboundItemsCount() {
        return this._inboundItems.size();
    }

    @Override
    public int getOutboundItemsCount() {
        return this._outboundItems.size();
    }

    @Override
    public void startTrackingRoutedItem(RoutedEntityItem routedEntityItem) {
        if (!this._outboundItems.contains(routedEntityItem)) {
            this._outboundItems.add(routedEntityItem);
        }
    }

    @Override
    public void startTrackingInboundItem(RoutedEntityItem routedEntityItem) {
        if (!this._inboundItems.contains(routedEntityItem)) {
            this._inboundItems.add(routedEntityItem);
        }
    }

    @Override
    public void outboundItemArrived(RoutedEntityItem routedEntityItem) {
        if (this._outboundItems.contains(routedEntityItem)) {
            this._outboundItems.remove(routedEntityItem);
        }
    }

    @Override
    public void inboundItemArrived(RoutedEntityItem routedEntityItem) {
        CoreRoutedPipe pipe;
        if (this._inboundItems.contains(routedEntityItem)) {
            this._inboundItems.remove(routedEntityItem);
        }
        if ((pipe = this.getPipe()) != null && pipe.logic instanceof IRequireReliableTransport) {
            ((IRequireReliableTransport)pipe.logic).itemArrived(ItemIdentifier.get(routedEntityItem.item));
        }
    }

    @Override
    public void itemDropped(RoutedEntityItem routedEntityItem) {
        if (this._outboundItems.contains(routedEntityItem)) {
            this._outboundItems.remove(routedEntityItem);
        }
        if (this._inboundItems.contains(routedEntityItem)) {
            this._inboundItems.remove(routedEntityItem);
        }
    }

    @Override
    public void destroy() {
        if (SharedLSADatabase.contains(this._myLsa)) {
            SharedLSADatabase.remove(this._myLsa);
            ++_LSDVersion;
        }
        RouterManager.removeRouter(this.id);
    }

    @Override
    public void update(boolean doFullRefresh) {
        if (doFullRefresh) {
            this.recheckAdjacent();
            if (this._blockNeedsUpdate) {
                CoreRoutedPipe pipe = this.getPipe();
                if (pipe == null) {
                    return;
                }
                pipe.worldObj.k(pipe.xCoord, pipe.yCoord, pipe.zCoord);
                this._blockNeedsUpdate = false;
            }
            return;
        }
    }

    @Override
    public void sendRoutedItem(kp item, Router destination, Position origin) {
    }

    @Override
    public boolean isRoutedExit(Orientations o) {
        return !this.GetNonRoutedExits().contains(o);
    }

    @Override
    public Orientations getExitFor(UUID id2) {
        return (Orientations)this.getRouteTable().get(RouterManager.get(id2));
    }

    @Override
    public boolean hasRoute(UUID id2) {
        if (!SimpleServiceLocator.routerManager.isRouter(id2)) {
            return false;
        }
        IRouter r = SimpleServiceLocator.routerManager.getRouter(id2);
        return this.getRouteTable().containsKey(r);
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        CoreRoutedPipe pipe = this.getPipe();
        if (pipe == null) {
            return null;
        }
        return pipe.getLogisticsModule();
    }

    public class LSA {
        public Router source;
        public HashMap neighboursWithMetric;
    }
}

