/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.routing;

import buildcraft.api.EntityPassiveItem;
import buildcraft.api.Orientations;
import buildcraft.krapht.IRequireReliableTransport;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.pipes.PipeLogisticsChassi;
import buildcraft.krapht.routing.IRouter;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import java.util.UUID;
import krapht.ItemIdentifier;
import sun.reflect.Reflection;

public class RoutedEntityItem
extends EntityPassiveItem
implements IRoutedItem {
    public UUID sourceUUID;
    public UUID destinationUUID;
    private boolean _doNotBuffer;
    public boolean arrived;
    private IRoutedItem.TransportMode _transportMode = IRoutedItem.TransportMode.Unknown;

    public RoutedEntityItem(ge world, EntityPassiveItem entityItem) {
        super(world, entityItem.entityId);
        this.container = entityItem.container;
        this.deterministicRandomization = entityItem.deterministicRandomization;
        this.posX = entityItem.posX;
        this.posY = entityItem.posY;
        this.posZ = entityItem.posZ;
        this.speed = entityItem.speed;
        this.synchroTracker = entityItem.synchroTracker;
        this.item = entityItem.item;
    }

    public ja toEntityItem(Orientations dir) {
        return super.toEntityItem(dir);
    }

    public void changeDestination(UUID newDestination) {
        if (this.destinationUUID != null && SimpleServiceLocator.routerManager.isRouter(this.destinationUUID)) {
            IRouter destinationRouter = SimpleServiceLocator.routerManager.getRouter(this.destinationUUID);
            destinationRouter.itemDropped(this);
            if (!this.arrived && destinationRouter.getPipe() != null && destinationRouter.getPipe().logic instanceof IRequireReliableTransport) {
                ((IRequireReliableTransport)destinationRouter.getPipe().logic).itemLost(ItemIdentifier.get(this.item));
            }
        }
        this.destinationUUID = newDestination;
    }

    public void remove() {
        if (this.sourceUUID != null && SimpleServiceLocator.routerManager.isRouter(this.sourceUUID)) {
            SimpleServiceLocator.routerManager.getRouter(this.sourceUUID).itemDropped(this);
        }
        if (this.destinationUUID != null && SimpleServiceLocator.routerManager.isRouter(this.destinationUUID)) {
            IRouter destinationRouter = SimpleServiceLocator.routerManager.getRouter(this.destinationUUID);
            destinationRouter.itemDropped(this);
            if (!this.arrived && destinationRouter.getPipe() != null && destinationRouter.getPipe().logic instanceof IRequireReliableTransport) {
                ((IRequireReliableTransport)destinationRouter.getPipe().logic).itemLost(ItemIdentifier.get(this.item));
            }
        }
        super.remove();
    }

    @Override
    public UUID getDestination() {
        return this.destinationUUID;
    }

    @Override
    public kp getItemStack() {
        return this.item;
    }

    @Override
    public void setDestination(UUID destination) {
        this.destinationUUID = destination;
    }

    @Override
    public UUID getSource() {
        return this.sourceUUID;
    }

    @Override
    public void setSource(UUID source) {
        this.sourceUUID = source;
    }

    @Override
    public void setDoNotBuffer(boolean isBuffered) {
        this._doNotBuffer = isBuffered;
    }

    @Override
    public boolean getDoNotBuffer() {
        return this._doNotBuffer;
    }

    @Override
    public EntityPassiveItem getEntityPassiveItem() {
        return this;
    }

    @Override
    @Deprecated
    public void setArrived() {
        this.arrived = true;
    }

    @Override
    public IRoutedItem split(ge worldObj, int itemsToTake, Orientations orientation) {
        EntityPassiveItem newItem = new EntityPassiveItem(worldObj);
        newItem.posX = this.posX;
        newItem.posY = this.posY;
        newItem.posZ = this.posZ;
        newItem.speed = this.speed;
        newItem.item = this.item.a(itemsToTake);
        if (this.container instanceof TileGenericPipe && ((TileGenericPipe)this.container).pipe.transport instanceof PipeTransportItems && ((TileGenericPipe)this.container).pipe instanceof PipeLogisticsChassi) {
            PipeLogisticsChassi chassi = (PipeLogisticsChassi)((TileGenericPipe)this.container).pipe;
            chassi.queueRoutedItem(SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(worldObj, newItem), orientation.reverse());
        }
        return SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(worldObj, newItem);
    }

    @Override
    public void SetPosition(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    @Override
    public void setTransportMode(IRoutedItem.TransportMode transportMode) {
        this._transportMode = transportMode;
    }

    @Override
    public IRoutedItem.TransportMode getTransportMode() {
        return this._transportMode;
    }

    public boolean hasContributions() {
        try {
            Class caller = Reflection.getCallerClass((int)3);
            if (caller.equals(PipeTransportItems.class)) {
                return true;
            }
            return super.hasContributions();
        }
        catch (Exception e) {
            return true;
        }
    }
}

