/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.routing;

import buildcraft.api.APIProxy;
import buildcraft.api.LaserKind;
import buildcraft.api.Orientations;
import buildcraft.api.Position;
import buildcraft.core.EntityBlock;
import buildcraft.core.Utils;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.routing.IPaintPath;
import buildcraft.krapht.routing.IRouter;
import buildcraft.krapht.routing.PathFinder;
import buildcraft.krapht.routing.Router;
import java.util.HashMap;
import java.util.LinkedList;

class RouteLaser
implements IPaintPath {
    private LinkedList _lasers = new LinkedList();
    private IRouter _lastRouter;
    private LaserKind _pewpewLazors = LaserKind.Stripes;

    RouteLaser() {
    }

    public void clear() {
        for (EntityBlock b : this._lasers) {
            APIProxy.removeEntity((tv)b);
        }
        this._lasers = new LinkedList();
    }

    private void addLeg(ge worldObj, Position start, Orientations o) {
        Position end = new Position(start.x, start.y, start.z, o);
        end.moveForwards(1.0);
        switch (o) {
            case XNeg: 
            case YNeg: 
            case ZNeg: {
                this._lasers.add(Utils.createLaser((ge)worldObj, (Position)end, (Position)start, (LaserKind)this._pewpewLazors));
                break;
            }
            default: {
                this._lasers.add(Utils.createLaser((ge)worldObj, (Position)start, (Position)end, (LaserKind)this._pewpewLazors));
            }
        }
    }

    public void displayRoute(IRouter source, IRouter destination) {
        this._pewpewLazors = LaserKind.Red;
        LinkedList<IRouter> routerList = new LinkedList<IRouter>();
        routerList.add(destination);
        this.displayRoute(source, routerList);
        this._pewpewLazors = LaserKind.Stripes;
    }

    public void displayRoute(IRouter r) {
        LinkedList<Router> knownRouters = new LinkedList<Router>();
        for (Router table : r.getRouteTable().keySet()) {
            if (table == r) continue;
            knownRouters.add(table);
        }
        this.displayRoute(r, knownRouters);
    }

    public void displayRoute(IRouter r, LinkedList knownRouters) {
        this.clear();
        if (r == this._lastRouter) {
            this._lastRouter = null;
            return;
        }
        this._lastRouter = r;
        block0: while (!knownRouters.isEmpty()) {
            IRouter targetRouter = (IRouter)knownRouters.pop();
            boolean found = false;
            Orientations next = (Orientations)r.getRouteTable().get(targetRouter);
            if (next == Orientations.Unknown) {
                System.out.println("BAAAD MOJO");
            }
            IRouter nextRouter = r;
            LinkedList<IRouter> visited = new LinkedList<IRouter>();
            while (nextRouter != targetRouter) {
                if (visited.contains(nextRouter)) {
                    System.out.println("ROUTE LOOP");
                    continue block0;
                }
                visited.add(nextRouter);
                LinkedList<IRouter> discovered = new LinkedList<IRouter>();
                Position firstPos = new Position((double)nextRouter.getPipe().container.l, (double)nextRouter.getPipe().container.m, (double)nextRouter.getPipe().zCoord, next);
                this.addLeg(r.getPipe().worldObj, firstPos, next);
                HashMap result = PathFinder.paintAndgetConnectedRoutingPipes(nextRouter.getPipe().container, next, 50, 100, this);
                for (RoutedPipe pipe : result.keySet()) {
                    discovered.add(pipe.getRouter());
                }
                if (discovered.isEmpty()) {
                    System.out.println("BAD ROUTE");
                }
                boolean ok = false;
                for (IRouter dicoveredRouter : discovered) {
                    if (knownRouters.contains(dicoveredRouter)) {
                        knownRouters.remove(dicoveredRouter);
                    }
                    if (!dicoveredRouter.getRouteTable().containsKey(targetRouter)) continue;
                    ok = true;
                    nextRouter = dicoveredRouter;
                    next = (Orientations)dicoveredRouter.getRouteTable().get(targetRouter);
                }
                if (ok) continue;
                System.out.println("DEAD ROUTE");
                continue block0;
            }
        }
    }

    @Override
    public void addLaser(ge worldObj, Position start, Orientations o) {
        this.addLeg(worldObj, start, o);
    }
}

